/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.table.db;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import kd.bos.db.datasource.DBConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.datasource.DBType;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.ColumnInfo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.db.AbstractColumnInfoReader;

public class DatabaseMetaDataReader
extends AbstractColumnInfoReader {
    private static Log LOG = LogFactory.getLog(DatabaseMetaDataReader.class);

    public DatabaseMetaDataReader(String dbRoute) {
        super(dbRoute);
    }

    @Override
    public List<ColumnInfo> read(String tableName) {
        ArrayList columnInfoList = Lists.newArrayList();
        if (tableName == null) {
            return columnInfoList;
        }
        boolean tableCase = this.getDefaultTableUpperCase();
        if (this.addColumnInfo(tableName, columnInfoList, tableCase)) {
            return columnInfoList;
        }
        this.addColumnInfo(tableName, columnInfoList, !tableCase);
        return columnInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addColumnInfo(String tableName, List<ColumnInfo> infoList, boolean upperCaseTable) {
        boolean find = false;
        String queryTableName = this.getQueryTableName(tableName, upperCaseTable);
        Object schema = null;
        ResultSet rs = null;
        try {
            rs = this.getConnection().getMetaData().getColumns(this.getConnection().getCatalog(), this.getSchema(), queryTableName, null);
            LOG.info("table = {}, queryTableName = {},  db schema = {}, db type = {}", new Object[]{tableName, queryTableName, this.getSchema(), this.getConnection().getDBType()});
            while (rs.next()) {
                if (!find) {
                    find = true;
                }
                ColumnInfo columnInfo = new ColumnInfo();
                columnInfo.setName(rs.getString("column_name") == null ? null : rs.getString("column_name").toLowerCase(Locale.ROOT));
                columnInfo.setType(rs.getString("type_name"));
                columnInfo.setLength(rs.getInt("column_size"));
                columnInfo.setDecimal(rs.getInt("decimal_digits"));
                columnInfo.setDefaultValue(rs.getString("column_def"));
                columnInfo.setAllowNull(rs.getBoolean("nullable"));
                infoList.add(columnInfo);
            }
            LOG.info("column info size = {}", (Object)infoList.size());
        }
        catch (SQLException exp) {
            LOG.error("read table {} column info fail, {}", (Object)tableName, (Object)exp.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignore) {
                    LOG.warn("table query {}, rs close error : {} ", (Object)tableName, (Object)ignore.getMessage());
                }
            }
        }
        return find;
    }

    private String getSchema() throws SQLException {
        if (this.isOracle()) {
            return Optional.ofNullable(this.getConnection().getDBConfig()).map(DBConfig::getUser).orElse(null);
        }
        return this.getConnection().getSchema();
    }

    private boolean isOracle() {
        DBType dbType = this.getConnection().getDBType();
        return DBType.oracle.equals((Object)dbType);
    }

    private String getQueryTableName(String tableName, boolean upperCaseTable) {
        if (upperCaseTable) {
            return tableName.toUpperCase(Locale.ROOT);
        }
        return tableName;
    }

    private boolean getDefaultTableUpperCase() {
        return this.isOracle();
    }
}

