/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.table.type;

import java.util.Locale;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.type.DataTypeConverter;
import kd.hrmp.hric.common.constants.DataTypeConstants;

public class NormalDataTypeConverter
implements DataTypeConverter {
    private static Log LOG = LogFactory.getLog(NormalDataTypeConverter.class);

    @Override
    public String getKsqlDataType(String dataType) {
        String castType;
        switch (castType = StringUtils.upperCase((String)dataType, (Locale)Locale.ROOT)) {
            case "NUMERIC": {
                return "DECIMAL";
            }
            case "INT8": {
                return "BIGINT";
            }
            case "INT4": {
                return "INT";
            }
            case "BPCHAR": {
                return "CHAR";
            }
        }
        return StringUtils.upperCase((String)dataType, (Locale)Locale.ROOT);
    }

    @Override
    public String getKsqlDataTypeWithLength(String datatype, int length, int decimal) {
        String ksqlDataType = this.getKsqlDataType(datatype);
        StringBuilder ksqlDataTypeBuilder = new StringBuilder(ksqlDataType);
        if (this.checkTypeWithLength(ksqlDataType)) {
            this.appendLength(ksqlDataTypeBuilder, ksqlDataType, length, decimal);
        }
        return ksqlDataTypeBuilder.toString();
    }

    private void appendLength(StringBuilder ksqlDataTypeBuilder, String ksqlDataType, int length, int decimal) {
        ksqlDataTypeBuilder.append("(");
        if (DataTypeConstants.DECIAML_TYPE_SET.contains(ksqlDataType)) {
            ksqlDataTypeBuilder.append(length).append(",").append(decimal);
        } else {
            ksqlDataTypeBuilder.append(length);
        }
        ksqlDataTypeBuilder.append(")");
    }

    private boolean checkTypeWithLength(String ksqlDataType) {
        return DataTypeConstants.DATATYPE_WITH_LENGTH_SET.contains(ksqlDataType);
    }
}

