/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.designer.dao.DesignerData;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.isv.ISVService;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.bo.MetadataBo;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.exception.KDHricException;

public abstract class MetadataUtils {
    public static final DesignerData DESIGNER_DATA = new DesignerData();
    private static final String QUERY_METADATA_SQL = "SELECT FID id, FMasterId masterId, FParentId parentId, FVERSION version, FNumber number, finheritpath inheritPath, fmodifydate modifyDate from  T_META_FORMDESIGN WHERE  %s in (%s);";
    private static final String METADATA_EXT_SQL = "SELECT FId id, FMasterId masterId, FNumber number, finheritpath inheritPath, fmodifydate modifyDate from  T_META_FORMDESIGN WHERE fmasterid in (%s) and ftype = '2' order by fmasterid, FInheritPath desc;";
    private static final String METADATA_DETAIL_SQL = "SELECT FID, FMasterId, FParentId, FNumber number, FVERSION, FNumber, finheritpath, fmodifydate from  T_META_FORMDESIGN WHERE  fid in (%s);";
    private static final String TABLE_NAME_META_FORMDESIGN = "T_META_FORMDESIGN";

    public static boolean checkNumber(String number) {
        return DESIGNER_DATA.checkNumber(number);
    }

    public static Map<String, Object> createBlankModel(Map<String, Object> parameters) {
        if (MetadataUtils.useBosDesigner()) {
            return DESIGNER_DATA.createBlankModel(parameters);
        }
        return MetadataUtils.createBlankModelSimple(parameters);
    }

    private static boolean useBosDesigner() {
        if (Boolean.TRUE.toString().equalsIgnoreCase(BaseConfigServiceHelper.get("midtable.generate.no.bos.designer"))) {
            return false;
        }
        return HRStringUtils.isNotEmpty((String)ISVService.getISVInfo().getId());
    }

    public static Map<String, Object> save(Map<String, Object> content) {
        if (MetadataUtils.useBosDesigner()) {
            return DESIGNER_DATA.save(content, true);
        }
        return MetadataUtils.saveSimple(content);
    }

    public static DynamicProperty getDynamicProperty(String entityNumber, String prop) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return type.getProperty(prop);
    }

    public static Map<String, Object> getDesignerMetadata(String number) {
        String id = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form);
        Map designerMetadata = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
        if (designerMetadata != null) {
            designerMetadata.put("subSystem", 1);
            designerMetadata.put("isv", "kingdee");
        }
        return designerMetadata;
    }

    public static List<MainEntityType> getEntityTypeList(String number) {
        ArrayList<MainEntityType> entityTypeList = new ArrayList<MainEntityType>();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            entityTypeList.add(queryType.getMainEntityType());
            entityTypeList.addAll(queryType.getAllJoinEntityType());
        } else {
            entityTypeList.add(mainType);
        }
        return entityTypeList;
    }

    public static String getExtMetaNumber(String number) {
        ArrayList<String> nodeList = new ArrayList<String>();
        String entityId = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            throw new KDBizException("metadata not exists, number = " + number);
        }
        nodeList.add(MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form));
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FNumber from ", new Object[0]).append(TABLE_NAME_META_FORMDESIGN, new Object[0]).append(" WHERE ", new Object[0]).appendIn("FMasterId", nodeList.toArray()).append(" and FType = '2' order by FInheritPath", new Object[0]);
        ResultSetHandler action = rs -> {
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString("FNumber"));
            }
            return list;
        };
        List list = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        return CollectionUtils.isEmpty((Collection)list) ? number : (String)list.get(0);
    }

    public static Map<String, MetadataBo> getMetadataBoByNumberMap(Set<String> numberSet) {
        String queryField = "fnumber";
        return MetadataUtils.getStringMetadataBoMap(queryField, numberSet);
    }

    public static Map<String, MetadataBo> getMetadataBoByIdMap(Set<String> idSet) {
        String queryField = "fid";
        return MetadataUtils.getStringMetadataBoMap(queryField, idSet);
    }

    private static Map<String, MetadataBo> getStringMetadataBoMap(String key, Set<String> keySet) {
        String sql = String.format(Locale.ROOT, QUERY_METADATA_SQL, key, MetadataUtils.getOccupySymbel(keySet));
        Map metadataBoMap = (Map)HRDBUtil.query((DBRoute)DBRoute.meta, (String)sql, (Object[])keySet.toArray(), resultSet -> {
            HashMap map = Maps.newHashMapWithExpectedSize((int)AppConstants.MAP_SIZE);
            while (resultSet.next()) {
                MetadataBo metadataBo = MetadataUtils.packageBo(resultSet);
                map.put(metadataBo.getId(), metadataBo);
            }
            return map;
        });
        return metadataBoMap;
    }

    private static MetadataBo packageBo(ResultSet resultSet) throws SQLException {
        MetadataBo metadataBo = new MetadataBo();
        metadataBo.setId(resultSet.getString("id"));
        metadataBo.setMasterId(resultSet.getString("masterId"));
        metadataBo.setModifyDate(resultSet.getTimestamp("modifyDate"));
        metadataBo.setInheritPath(resultSet.getString("inheritPath"));
        metadataBo.setNumber(resultSet.getString("number"));
        return metadataBo;
    }

    private static String getOccupySymbel(Set<String> numberSet) {
        List list = numberSet.stream().map(it -> "?").collect(Collectors.toList());
        return StringUtils.join((Object[])list.toArray(), (String)",");
    }

    public static Map<String, String> getMetadataInheritPath(Map<String, MetadataBo> boMap) {
        Set boSet = boMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        Map<String, String> map = boSet.stream().collect(Collectors.toMap(it -> it.getId(), it -> it.getNumber(), (o1, o2) -> o1));
        String sql = String.format(Locale.ROOT, METADATA_EXT_SQL, MetadataUtils.getOccupySymbel(map.keySet()));
        List metadataBoList = (List)HRDBUtil.query((DBRoute)DBRoute.meta, (String)sql, (Object[])map.keySet().toArray(), resultSet -> {
            ArrayList boList = Lists.newArrayList();
            if (resultSet.next()) {
                boList.add(MetadataUtils.packageBo(resultSet));
            }
            return boList;
        });
        Map<String, List<MetadataBo>> mapList = metadataBoList.stream().collect(Collectors.groupingBy(it -> it.getMasterId()));
        Map<String, String> resultMap = boMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toMap(it -> it.getId(), it -> it.getInheritPath() + "," + it.getId()));
        for (Map.Entry<String, List<MetadataBo>> entry : mapList.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            MetadataBo bo = entry.getValue().get(0);
            resultMap.put(entry.getKey(), bo.getInheritPath() + "," + bo.getId());
        }
        return resultMap;
    }

    public static Map<String, Object> createBlankModelSimple(Map<String, Object> parameters) {
        String modelType = (String)parameters.get("modelType");
        String key = (String)parameters.get("id");
        String objName = (String)parameters.get("name");
        LocaleString name = new LocaleString("zh_CN", objName);
        String parentId = (String)parameters.get("parentId");
        String bizappid = (String)parameters.get("bizappid");
        String devType = (String)parameters.get("devType");
        devType = StringUtils.isBlank((CharSequence)devType) ? "0" : devType;
        IFormTemplate template = FormTemplateFactory.createTemplate((String)modelType);
        EntityMetadata entityMeta = null;
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)parentId, (MetaCategory)MetaCategory.Form);
        formMeta.setId(DBServiceHelper.genStringId());
        String inheritPath = formMeta.getInheritPath();
        formMeta.setModelType(modelType);
        formMeta.setParentId(parentId);
        formMeta.setDevType(devType);
        if (!StringUtils.isEmpty((CharSequence)parentId)) {
            inheritPath = StringUtils.isBlank((CharSequence)inheritPath) ? parentId : inheritPath + ',' + parentId;
            formMeta.setInheritPath(inheritPath);
            MetadataUtils.setInheritFlag(formMeta.getItems());
        }
        formMeta.setKey(key);
        formMeta.setName(name);
        String entityId = (String)parameters.get("entityId");
        if (StringUtils.isBlank((CharSequence)parentId)) {
            throw new KDHricException("templdate id should not be empty");
        }
        entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        entityMeta.setParentId(parentId);
        entityMeta.setId(formMeta.getId());
        entityMeta.setModelType(modelType);
        entityMeta.getRootEntity().setTemplate(false);
        if (entityMeta.getRootEntity() instanceof BillEntity) {
            ((BillEntity)entityMeta.getRootEntity()).setDefaultPageSetting("{\"mblist\":\"\",\"pclist\":\"\",\"pcbill\":\"\",\"mbbill\":\"\"}");
        }
        MetadataUtils.setInheritFlag(entityMeta.getItems());
        entityId = formMeta.getId();
        entityMeta.setKey(key);
        entityMeta.setName(name);
        entityMeta.getRootEntity().setKey(key);
        entityMeta.getRootEntity().setdbRoute("hmp");
        formMeta.setBizappId(bizappid);
        entityMeta.setBizappId(bizappid);
        formMeta.bindEntityMetadata(entityMeta);
        formMeta.setEntityId(entityId);
        formMeta.setIsv("kingdee");
        return formMeta.buildDesignMeta("zh_CN");
    }

    public static Map<String, Object> saveSimple(Map<String, Object> content) {
        Map formMeta = (Map)content.get("formmeta");
        String modelType = (String)formMeta.get("ModelType");
        AbstractMetadata metadata = new FormMetadataConverter().convertTo(content);
        EntityMetadata entityMetadata = ((FormMetadata)metadata).getEntityMetadata();
        entityMetadata.setIsvSign(metadata.getIsvSign());
        MetadataUtils.clearSubRuntimeMeta((AbstractMetadata)((FormMetadata)metadata));
        return new MetadataWriter(modelType).save(Boolean.valueOf(true), new AbstractMetadata[]{metadata, entityMetadata});
    }

    private static void clearSubRuntimeMeta(AbstractMetadata formMeta) {
        ArrayList<String> formIds = new ArrayList<String>();
        formIds.add(formMeta.getId());
        MetadataDao.clearSubRuntimeMeta(formIds);
    }

    private static void setInheritFlag(List<? extends AbstractElement> elementList) {
        elementList.forEach(ele -> ele.setInherit(true));
    }

    public static List<EntityItem<?>> getEntityFieldItems(String entityNumber) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null) {
            return new ArrayList();
        }
        List entityItems = entityMetadata.getItems();
        return entityItems.stream().filter(item -> item instanceof Field).collect(Collectors.toList());
    }

    public static boolean isExist(String number) {
        String id = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Entity);
        return StringUtils.isNotEmpty((CharSequence)id);
    }

    public static MainEntityType getMainEntityType(String entityNumber) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            return queryType;
        }
        return mainType;
    }
}

