/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.util;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.hrmp.hric.common.util.HricStringUtils;

public class TableUtils {
    private static final String INDEX_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_{table}_{field}') CREATE INDEX IDX_{table}_{field} ON T_{table} ( {field} );";
    private static final String DROP_SQL = "IF EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '{table}' AND KSQL_COL_NAME ='{field}') \n ALTER TABLE {table} DROP COLUMN {field};";
    private static final String DROP_TABLE_SQL = "IF EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '{table}')  DROP TABLE {table}";

    public static boolean addIndexOnTable(String dbRouteKey, String tableName, String fieldName) {
        SqlBuilder sqlBuilder = new SqlBuilder().append(TableUtils.getSql(tableName, fieldName, INDEX_SQL), new Object[0]);
        return DB.execute((DBRoute)new DBRoute(dbRouteKey), (SqlBuilder)sqlBuilder);
    }

    public static boolean dropTableColumn(String dbRouteKey, String tableName, String fieldName) {
        SqlBuilder sqlBuilder = new SqlBuilder().append(TableUtils.getSql(tableName, fieldName, DROP_SQL), new Object[0]);
        return DB.execute((DBRoute)new DBRoute(dbRouteKey), (SqlBuilder)sqlBuilder);
    }

    private static String getSql(String tableName, String fieldName, String symbleSql) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        paramMap.put("table", tableName.toUpperCase(Locale.ROOT));
        paramMap.put("field", fieldName.toUpperCase(Locale.ROOT));
        return HricStringUtils.replaceHold((CharSequence)symbleSql, (Map)paramMap);
    }

    public static boolean dropTable(String dbRouteKey, String tableName) {
        return DB.execute((DBRoute)new DBRoute(dbRouteKey), (String)TableUtils.getSql(tableName, "", DROP_TABLE_SQL));
    }
}

