/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.plan;

import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.plan.PlanImplItemBo;
import kd.hrmp.hric.common.constants.msg.PlanMsgEnum;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class PlanBo {
    private String number;
    private String name;
    private String planPerson;
    private String masterPlanStructNumber;
    private DynamicObject planDyn;
    private List<PlanImplItemBo> implItemBoList;

    public PlanBo(DynamicObject planDyn) {
        this.planDyn = planDyn;
        this.number = planDyn.getString("number");
        this.name = planDyn.getLocaleString("name").getLocaleValue();
        Object planPersonObj = planDyn.get("planperson");
        if (planPersonObj != null) {
            this.planPerson = planPersonObj instanceof DynamicObject ? ((DynamicObject)planPersonObj).getPkValue().toString() : planPersonObj.toString();
        }
        this.masterPlanStructNumber = (String)Splitter.on((String)"!").trimResults().splitToList((CharSequence)planDyn.getString("structnumber")).get(0);
        this.implItemBoList = planDyn.getDynamicObjectCollection("itementryentity").stream().map(it -> new PlanImplItemBo((DynamicObject)it, this)).collect(Collectors.toList());
    }

    public void init(int[] selectRows) {
        Arrays.stream(selectRows).forEach(rowIndex -> this.implItemBoList.get(rowIndex).addSelected());
    }

    public boolean validateAllImplItemInit() {
        return this.implItemBoList.stream().filter(PlanImplItemBo::isSelected).allMatch(PlanImplItemBo::hasInitLog);
    }

    public String isMandatoryValidate() {
        StringBuilder msgBuilder = new StringBuilder();
        this.implItemBoList.stream().filter(PlanImplItemBo::isSelected).filter(implItemBo -> !implItemBo.hasInitLog()).filter(PlanImplItemBo::isMandatory).forEach(implItemBo -> msgBuilder.append(String.format(Locale.ROOT, PlanMsgEnum.SKIP_STRONG_MSG.getMsg(), implItemBo.getImplItemName().getLocaleValue())).append("\n"));
        return msgBuilder.toString();
    }

    public String dependentValidate(List<ImmutableTriple<Long, String, Long>> implItemIdTriple) {
        StringBuilder msgBuilder = new StringBuilder();
        List<Long> currSelectEntryImplItemIdList = this.getSelectEntry();
        this.implItemBoList.stream().filter(PlanImplItemBo::isSelected).filter(implItemBo -> !implItemBo.hasInitLog()).filter(implItemBo -> !implItemBo.isMandatory()).forEach(implItemBo -> {
            for (ImmutableTriple triple : implItemIdTriple) {
                Long preId = (Long)triple.getLeft();
                String ImplItemName = (String)triple.getMiddle();
                Long entryImplItemId = (Long)triple.getRight();
                if (preId.longValue() != implItemBo.getId().longValue()) continue;
                if (currSelectEntryImplItemIdList.contains(entryImplItemId)) {
                    return;
                }
                msgBuilder.append(String.format(Locale.ROOT, PlanMsgEnum.SKIP_WEAK_MSG.getMsg(), implItemBo.getImplItemName().getLocaleValue(), ImplItemName)).append("\n");
            }
        });
        return msgBuilder.toString();
    }

    private List<Long> getSelectEntry() {
        return this.implItemBoList.stream().filter(impl -> impl.isSelected()).map(impl -> impl.getId()).collect(Collectors.toList());
    }

    public String numbersIsEmpty() {
        if (HRStringUtils.isEmpty((String)this.number)) {
            return String.format(Locale.ROOT, PlanMsgEnum.PLAN_NUMBER_IS_EMPTY_MSG.get(), this.name);
        }
        return "";
    }

    public String nameIsEmpty() {
        if (HRStringUtils.isEmpty((String)this.name)) {
            return String.format(Locale.ROOT, PlanMsgEnum.PLAN_NAME_IS_EMPTY_MSG.get(), this.number);
        }
        return "";
    }

    public String planPersonIsEmpty() {
        if (HRStringUtils.isEmpty((String)this.planPerson)) {
            return String.format(Locale.ROOT, PlanMsgEnum.PLAN_PERSON_IS_EMPTY_MSG.get(), this.name);
        }
        return "";
    }

    public String getMasterPlanStructNumber() {
        return this.masterPlanStructNumber;
    }

    public List<PlanImplItemBo> getImplItemBoList() {
        return this.implItemBoList;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setMasterPlanStructNumber(String masterPlanStructNumber) {
        this.masterPlanStructNumber = masterPlanStructNumber;
    }

    public DynamicObject getPlanDyn() {
        return this.planDyn;
    }

    public void setPlanDyn(DynamicObject planDyn) {
        this.planDyn = planDyn;
    }

    public void setImplItemBoList(List<PlanImplItemBo> implItemBoList) {
        this.implItemBoList = implItemBoList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

