/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.plan;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.plan.PlanBo;
import kd.hrmp.hric.common.constants.msg.PlanMsgEnum;

public class PlanImplItemBo {
    private PlanBo plan;
    private DynamicObject dyn;
    private boolean selected;
    private DynamicObject implItem;
    private ILocaleString implItemName;
    private Long id;
    private Boolean skip;
    private Boolean dataVerify;
    private String executePerson;
    private String verifyPerson;
    private static Log LOG = LogFactory.getLog(PlanImplItemBo.class);

    public PlanImplItemBo(DynamicObject dyn, PlanBo plan) {
        this.plan = plan;
        this.dyn = dyn;
        this.implItem = dyn.getDynamicObject("implitem");
        this.skip = dyn.getBoolean("isskip");
        this.dataVerify = dyn.getBoolean("isdataverify");
        this.exeOrverifyPersonInit(dyn);
        if (this.implItem != null) {
            this.implItemName = this.implItem.getLocaleString("name");
            this.id = this.implItem.getLong("id");
        } else {
            LOG.error("[HRIC]Current plan:{}, entry:{} is empty", (Object)plan.getNumber(), (Object)dyn.getLocaleString("itemname").getLocaleValue());
        }
    }

    private void exeOrverifyPersonInit(DynamicObject dyn) {
        Object verifyPerson;
        Object executePerson = dyn.get("executeperson");
        if (executePerson != null) {
            this.executePerson = executePerson instanceof DynamicObject ? ((DynamicObject)executePerson).getPkValue().toString() : executePerson.toString();
        }
        if ((verifyPerson = dyn.get("verifyperson")) != null) {
            this.verifyPerson = verifyPerson instanceof DynamicObject ? ((DynamicObject)verifyPerson).getPkValue().toString() : verifyPerson.toString();
        }
    }

    public void addSelected() {
        this.selected = true;
    }

    public DynamicObject getDyn() {
        return this.dyn;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public ILocaleString getImplItemName() {
        return this.implItemName;
    }

    public Long getId() {
        return this.id;
    }

    public PlanBo getPlan() {
        return this.plan;
    }

    public void setPlan(PlanBo plan) {
        this.plan = plan;
    }

    public Boolean getSkip() {
        return this.skip;
    }

    public void setSkip(Boolean skip) {
        this.skip = skip;
    }

    public boolean hasInitLog() {
        if (this.implItem == null) {
            return false;
        }
        String isInitLog = this.implItem.getString("isinitlog");
        return HRStringUtils.equals((String)isInitLog, (String)"B");
    }

    public boolean isMandatory() {
        if (this.implItem == null) {
            return false;
        }
        return this.implItem.getBoolean("ismandatory");
    }

    public String execPersonIsEmpty() {
        if (!this.skip.booleanValue() && HRStringUtils.isEmpty((String)this.executePerson)) {
            return String.format(Locale.ROOT, PlanMsgEnum.PLAN_EXEC_PERSON_IS_EMPTY_MSG.get(), this.plan.getName(), this.implItemName.getLocaleValue());
        }
        return "";
    }

    public String verifyPersonIsEmpty() {
        if (this.dataVerify.booleanValue() && HRStringUtils.isEmpty((String)this.verifyPerson)) {
            return String.format(Locale.ROOT, PlanMsgEnum.PLAN_VERIFY_PERSON_IS_EMPTY_MSG.get(), this.plan.getName(), this.implItemName.getLocaleValue());
        }
        return "";
    }
}

