/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hrmp.hric.bussiness.task.InitAsyncTask;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.exception.code.HRICErrorEnum;
import kd.hrmp.hric.common.util.DateUtils;

public class AsyncTaskServiceHelper {
    private static Log LOG = LogFactory.getLog(AsyncTaskServiceHelper.class);
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hric_asynctask");
    private static final String OPEARTE_SELECT_PROPERTIES = "status, latesttime, endtime, params, params_tag, errormsg, errormsg_tag, tasktype, retrytimes";

    public static DynamicObject get(long id) {
        DynamicObject[] dys = serviceHelper.query(OPEARTE_SELECT_PROPERTIES, new QFilter("id", "=", (Object)id).toArray());
        if (Objects.nonNull(dys) && dys.length > 0) {
            return dys[0];
        }
        return null;
    }

    public static DynamicObject[] getExecuteTasks(int retryTimes) {
        return serviceHelper.query(OPEARTE_SELECT_PROPERTIES, new QFilter("retrytimes", "<=", (Object)retryTimes).and(new QFilter("starttime", ">=", (Object)DateUtils.getMinuteAgoTime((int)-30)).and(new QFilter("tasktype.autoretry", "=", (Object)Boolean.TRUE)).and(new QFilter("status", "=", (Object)"15").or("status", "=", (Object)"10"))).toArray());
    }

    public static void save(DynamicObject dynamicObject) {
        serviceHelper.saveOne(dynamicObject);
    }

    public static void save(Collection<DynamicObject> dynamicObjectCollection) {
        serviceHelper.save(dynamicObjectCollection.toArray(new DynamicObject[0]));
    }

    public static DynamicObject createTaskAndSave(Map<String, Object> paramMap, String objNumber, String operateType, Long taskSceneId) {
        DynamicObject dy = AsyncTaskServiceHelper.createTask(paramMap, objNumber, operateType, taskSceneId);
        serviceHelper.saveOne(dy);
        return dy;
    }

    public static DynamicObject createTask(Map<String, Object> paramMap, String objNumber, String operateType, Long taskSceneId) {
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("starttime", (Object)new Date());
        dynamicObject.set("objnumber", (Object)objNumber);
        try {
            dynamicObject.set("params_tag", (Object)HRJSONUtils.toString(paramMap));
        }
        catch (IOException ex) {
            throw new KDHricException(HRICErrorEnum.JSON_PARSE_ERROR, new Object[]{ex});
        }
        dynamicObject.set("operatetype", (Object)operateType);
        dynamicObject.set("status", (Object)"10");
        dynamicObject.set("tasktype", (Object)taskSceneId);
        return dynamicObject;
    }

    public static String startJob(long asyncTaskId) {
        JobInfo jobInfo = AsyncTaskServiceHelper.buildJobInfo();
        jobInfo.setParams((Map)ImmutableMap.of((Object)"asyncTaskId", (Object)asyncTaskId));
        return ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
    }

    public static String startJob() {
        JobInfo jobInfo = AsyncTaskServiceHelper.buildJobInfo();
        jobInfo.setParams((Map)ImmutableMap.of((Object)"isBatch", (Object)true));
        return ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
    }

    public static JobInfo buildJobInfo() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("hric");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(UserServiceHelper.getCurrentUserId());
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(InitAsyncTask.class.getName());
        return jobInfo;
    }
}

