/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.QFilterUtils;

public class ImplItemListDaoHelper {
    private static HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hric_implitem");

    public static DynamicObject[] getImplItemObjectByIds(String selectProperties, List<Long> idList) {
        DynamicObject[] dys = SERVICE_HELPER.query(selectProperties, new QFilter("id", "in", idList).toArray());
        Map<Long, DynamicObject> dyMap = Stream.of(dys).collect(Collectors.toMap(it -> it.getLong("id"), it -> it, (before, after) -> before));
        DynamicObject[] newDys = new DynamicObject[dys.length];
        for (int index = 0; index < dys.length; ++index) {
            newDys[index] = dyMap.get(idList.get(index));
        }
        return newDys;
    }

    public static Map<Object, DynamicObject> getAllFrontImplItem(QFilter[] filters) {
        return BusinessDataServiceHelper.loadFromCache((String)"hric_implitem", (String)"mulfrontimpl", (QFilter[])filters);
    }

    public static List<DynamicObject> getImplItemObjectByBizSubArea(String selectProperties, Set<Long> subAreaIDSet, String usescene, boolean isMustExec) {
        QFilter qFilter = QFilterUtils.getEnableQFilter();
        qFilter.and(new QFilter("bizsubarea", "in", subAreaIDSet));
        if (HRStringUtils.isNotEmpty((String)usescene)) {
            qFilter.and(new QFilter("usescene", "like", (Object)("%" + usescene + "%")));
        }
        if (isMustExec) {
            qFilter.and(new QFilter("ismandatory", "=", (Object)true));
        }
        Object[] dyns = SERVICE_HELPER.query(selectProperties, qFilter.toArray(), "listseq asc");
        return ConvertUtils.transferArrayToList((Object[])dyns);
    }

    public static void updateImplItem(DynamicObject implItem) {
        SERVICE_HELPER.updateOne(implItem);
    }

    public static DynamicObject getImplItemById(long id) {
        return SERVICE_HELPER.queryOne("isinitlog", new QFilter("id", "=", (Object)id));
    }

    public static DynamicObject getImplItemDiEntityById(long id) {
        return SERVICE_HELPER.queryOne("dientryentity.sourcesystem,dientryentity.integrationservicetype,dientryentity.discheme", new QFilter("id", "=", (Object)id));
    }

    public static DynamicObject[] getImplByEntityNumber(List<String> entityNumbers, List<Long> ids) {
        return SERVICE_HELPER.query("entityobjscope", new QFilter("entityobjscope", "in", entityNumbers).and("id", "not in", ids).and("enable", "=", (Object)"1").toArray());
    }

    public static DynamicObject[] getImplItemListByIds(List<Long> ids) {
        return SERVICE_HELPER.query("name,entityobjscope,enable", new QFilter("id", "in", ids).and("enable", "!=", (Object)"1").and("initfordatasource", "!=", (Object)"C").toArray());
    }

    public static DynamicObject[] getAvailableAndDisableImplByBizSubArea(Set<Long> idSet) {
        return SERVICE_HELPER.query("enable,isinitlog", new QFilter("bizsubarea", "in", idSet).and(new QFilter("enable", "=", (Object)"0").or("enable", "=", (Object)"1")).toArray());
    }
}

