/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.back.AbstractCallbackHandle;
import kd.hrmp.hric.bussiness.service.processing.ExecTaskCacheHandle;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;

public class InitExecTaskServiceHelper {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hric_exectask");
    private static Log LOG = LogFactory.getLog(AbstractCallbackHandle.class);
    private static final String QUERY_FINISH_COUNT_SQL = "select sum(fcount) total_count from t_hric_exectask where fpid = ? and ftaskstatus in (?, ?)";
    private static final String QUERY_EXECTASK_MIN_MAX_SQL = "select min(fid) min_id, max(fid) max_id from %s where %s";
    private static final String EXEC_TASK_FIELDS = "number,taskstatus,operatetype,taskinfo,batchnumber,count,pid,taskstarttime,taskendtime,lastretrytime,midtableids";

    public static DynamicObject getExecTaskById(Long id) {
        return SERVICE_HELPER.loadDynamicObject(new QFilter("id", "=", (Object)id));
    }

    public static DynamicObject getExecTaskById(String selectProperties, Long id) {
        return SERVICE_HELPER.queryOne(selectProperties, (Object)id);
    }

    public static boolean isExistSubExecTask(Long pid) {
        return SERVICE_HELPER.isExists(new QFilter("pid", "=", (Object)pid));
    }

    public static ExecTaskCacheHandle finishTaskStatus(Long execTaskId, boolean discard) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hric_exectask");
        DynamicObject dynamicObject = serviceHelper.queryOne("id, taskstatus, count, batchnumber, pid, taskendtime, result, result_tag", new QFilter("id", "=", (Object)execTaskId).toArray());
        InitExecTaskServiceHelper.clearErrorMsg(discard, dynamicObject);
        String taskFinishStatus = discard ? "H" : "C";
        dynamicObject.set("taskstatus", (Object)taskFinishStatus);
        dynamicObject.set("taskendtime", (Object)new Date());
        serviceHelper.saveOne(dynamicObject);
        if (dynamicObject.getLong("pid") == 0L) {
            return new ExecTaskCacheHandle(null, Boolean.TRUE, dynamicObject.getLong("batchnumber"));
        }
        return new ExecTaskCacheHandle(dynamicObject.getLong("count"), Boolean.FALSE, dynamicObject.getLong("batchnumber"));
    }

    private static void clearErrorMsg(boolean discard, DynamicObject dynamicObject) {
        if (discard || !HRStringUtils.equals((String)dynamicObject.getString("taskstatus"), (String)"G")) {
            return;
        }
        HricDynamicObjectUtils.clearBigText((DynamicObject)dynamicObject, (String)"result");
    }

    public static ExecTaskCacheHandle finishTaskStatus(Long execTaskId) {
        return InitExecTaskServiceHelper.finishTaskStatus(execTaskId, false);
    }

    public static ExecTaskCacheHandle tryFinishParentTask(Long execTaskId, DynamicObject execTask) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hric_exectask");
        Long pid = execTask.getLong("pid");
        if (Objects.isNull(pid) || pid.equals(0L)) {
            return new ExecTaskCacheHandle(null, Boolean.TRUE, execTask.getLong("batchnumber"));
        }
        QFilter pidQFilter = new QFilter("pid", "=", (Object)pid);
        QFilter statusQFilter = new QFilter("taskstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"D", "A", "G"}));
        QFilter idQFilter = new QFilter("id", "<>", (Object)execTaskId);
        boolean existProcessing = serviceHelper.isExists(pidQFilter.and(statusQFilter).and(idQFilter).toArray());
        LOG.info("tryFinishParentTask,existProcessing:{}, execTaskId:{}", (Object)existProcessing, (Object)execTaskId);
        if (!existProcessing) {
            return InitExecTaskServiceHelper.finishTaskStatus(pid);
        }
        return new ExecTaskCacheHandle();
    }

    public static Long saveRtnMsg(Long execTaskId, Object body) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hric_exectask");
        DynamicObject dynamicObject = serviceHelper.queryOne("taskstatus, result_tag, batchnumber", new QFilter("id", "=", (Object)execTaskId));
        dynamicObject.set("result_tag", body);
        dynamicObject.set("taskstatus", (Object)"B");
        serviceHelper.save(new DynamicObject[]{dynamicObject});
        return dynamicObject.getLong("batchnumber");
    }

    public static void save(DynamicObject pTask) {
        SERVICE_HELPER.save(new DynamicObject[]{pTask});
    }

    public static Long getFinishCountByPid(Long pid) {
        return (Long)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)QUERY_FINISH_COUNT_SQL, (Object[])new Object[]{pid, "C", "H"}, rs -> {
            if (rs.next()) {
                return rs.getLong("total_count");
            }
            return 0L;
        });
    }

    public static Map<String, Long> getStartExecTaskId(String entityNumber, String filter) {
        return (Map)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)String.format(QUERY_EXECTASK_MIN_MAX_SQL, entityNumber, filter), (Object[])new Object[0], rs -> {
            HashMap resultMap = Maps.newHashMap();
            if (rs.next()) {
                resultMap.put("startId", rs.getLong("min_id"));
                resultMap.put("endId", rs.getLong("max_id"));
            }
            return resultMap;
        });
    }

    public static DynamicObject getInitExecTaskByTaskId(Long taskId) {
        QFilter qFilter = new QFilter("batchnumber", "=", (Object)taskId);
        qFilter.and(new QFilter("pid", "=", (Object)0L));
        return SERVICE_HELPER.queryOne(EXEC_TASK_FIELDS, qFilter.toArray(), "taskstarttime desc");
    }
}

