/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisInitReturnBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTemplateServiceHelper;
import kd.hrmp.hric.bussiness.service.task.handle.ChangeProcessingStatusHandle;
import kd.hrmp.hric.bussiness.service.task.handle.ChangeValidatedStatusHandle;
import kd.hrmp.hric.bussiness.service.task.handle.MidTableHandleInfo;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.PredicateContainer;
import kd.hrmp.hric.common.bean.bo.ExecTaskCallbackBo;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;
import kd.hrmp.hric.common.util.QFilterUtils;

public class InitMidTableServiceHelper {
    private static final Log LOG = LogFactory.getLog(InitMidTableServiceHelper.class);
    private static final String QUERY_OPERATE_GROUPBY_COUNT_SQL = "select finitstatus,count(1) count from %s where %s group by finitstatus";
    private static final String QUERY_UNIQUE_GROUP_SQL = "select %s from %s where %s group by %s  having count(1) > 1";
    private static final String QUERY_UNIQUE_ID_SQL = "select t.fid from (%s) tmp %s where t.fhrictaskid = %s and t.finitstatus = 'A'";
    private static final String AND = " and ";

    public static DynamicObject[] queryPageCollection(String entityCode, QFilter[] qFilters) {
        return BusinessDataServiceHelper.load((String)entityCode, (String)HricDynamicObjectUtils.getFieldByPage((String)entityCode), (QFilter[])qFilters, (String)"id");
    }

    public static DynamicObject[] queryPageCollection(String entityCode, String selectProperties, QFilter[] qFilters, int pageIndex, int pageSize) {
        return BusinessDataServiceHelper.load((String)entityCode, (String)selectProperties, (QFilter[])qFilters, (String)"id", (int)pageIndex, (int)pageSize);
    }

    public static DynamicObject[] queryPageCollection(String entityCode, String selectProperties, QFilter[] qFilters) {
        return BusinessDataServiceHelper.load((String)entityCode, (String)selectProperties, (QFilter[])qFilters, (String)"id");
    }

    public static int queryCount(String entityCode, QFilter[] qFilters) {
        return new HRBaseServiceHelper(entityCode).count(entityCode, qFilters);
    }

    public static List<DynamicObject> loadBaseDataFromDBByImportProp(String entityType, Set<String> fieldValSet, String fieldName, String entityCode, String selectedProperties, String importProp, String json) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityType);
        QFilter searchFilter = new QFilter(importProp, "in", fieldValSet);
        Object[] dys = serviceHelper.query(selectedProperties, InitMidTableServiceHelper.buildHisQFilter(entityCode, fieldName, entityType, searchFilter, json).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.transferArrayToList((Object[])dys);
    }

    public static List<DynamicObject> loadBaseDataFromDB(String entityType, Set<String> fieldValSet, String fieldName, String entityCode, String selectedProperties) {
        ArrayList dyList = Lists.newArrayList();
        dyList.addAll(InitMidTableServiceHelper.loadBaseDataFromDBByType(entityType, fieldValSet, fieldName, entityCode, selectedProperties, "number"));
        Set keySet = dyList.stream().map(it -> it.get("id")).collect(Collectors.toSet());
        List<DynamicObject> dynamicObjectList = InitMidTableServiceHelper.loadBaseDataFromDBByType(entityType, fieldValSet, fieldName, entityCode, selectedProperties, "name");
        for (DynamicObject dynamicObject : dynamicObjectList) {
            if (keySet.contains(dynamicObject.get("id"))) continue;
            dyList.add(dynamicObject);
        }
        return dyList;
    }

    public static List<DynamicObject> loadBaseDataFromDBByType(String entityType, Set<String> fieldValSet, String fieldName, String entityCode, String selectedProperties, String type) {
        String json;
        Object[] dys;
        if (type == null) {
            return Lists.newArrayList();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityType);
        BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityType);
        QFilter searchFilter = new QFilter(type, "in", fieldValSet);
        if (!HricDynamicObjectUtils.entityContainsNumberAndName((BasedataEntityType)dataEntityType)) {
            String numberProperty = dataEntityType.getNumberProperty();
            searchFilter = HRStringUtils.isNotEmpty((String)numberProperty) ? new QFilter(numberProperty, "in", fieldValSet) : new QFilter(dataEntityType.getNameProperty(), "in", fieldValSet);
        }
        if (ObjectUtils.isEmpty((Object[])(dys = serviceHelper.query(selectedProperties, InitMidTableServiceHelper.buildHisQFilter(entityCode, fieldName, entityType, searchFilter, json = Optional.ofNullable(BaseConfigServiceHelper.get("hrpi_filter_field")).orElseGet(() -> "")).toArray())))) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.transferArrayToList((Object[])dys);
    }

    public static List<DynamicObject> loadBaseDataFromDBWithRefProp(String entityType, Set<String> fieldValSet, String fieldName, String entityCode) {
        IDataEntityProperty property = MetadataServiceHelper.getDataEntityType((String)entityCode).findProperty(fieldName);
        IDataEntityType relField = null;
        relField = property instanceof BasedataProp ? ((BasedataProp)property).getComplexType() : ((MulBasedataProp)property).getComplexType();
        String relFieldStr = relField.toString();
        String searchField = relFieldStr.substring(relFieldStr.indexOf(91) + 1, relFieldStr.lastIndexOf(93));
        return InitMidTableServiceHelper.loadBaseDataFromDB(entityType, fieldValSet, fieldName, entityCode, searchField + ",id");
    }

    private static QFilter buildHisQFilter(String entityCode, String fieldName, String entityType, QFilter defaultQFilter, String json) {
        try {
            JSONObject jsonObject;
            Set filedSet;
            if (HRStringUtils.isNotEmpty((String)json) && (filedSet = (jsonObject = JSONObject.parseObject((String)json)).keySet()).contains(entityType)) {
                String filter = jsonObject.getString(entityType);
                return defaultQFilter.and(QFilter.of((String)filter, (Object[])new Object[0]));
            }
            HisInitReturnBo hisInitReturnBo = HisModelController.getInstance().buildImportFilter(entityCode, fieldName, entityType);
            if (Objects.nonNull(hisInitReturnBo) && Objects.nonNull(hisInitReturnBo.getqFilter())) {
                LOG.info("importbo filter, {}", (Object)hisInitReturnBo.getqFilter());
                return defaultQFilter.and(hisInitReturnBo.getqFilter());
            }
        }
        catch (Exception ex) {
            LOG.error("his error", (Throwable)ex);
        }
        return defaultQFilter;
    }

    public static void updateMidForDisuse(List<DynamicObject> midList, String entityCode) {
        new HRBaseServiceHelper(entityCode).update(midList.toArray(new DynamicObject[0]));
    }

    public static boolean updateBizTableStatusForSignTask(String midTableNumber, Long taskId, boolean passed, ExecTaskCallbackBo execTaskCallbackBo) {
        MidTableHandleInfo midTableHandleInfo = new MidTableHandleInfo((long)taskId, midTableNumber, execTaskCallbackBo);
        if (passed) {
            return new ChangeValidatedStatusHandle(midTableHandleInfo).handle();
        }
        return new ChangeProcessingStatusHandle(midTableHandleInfo).handle();
    }

    public static Map<String, String> getMidTableAndEntityMappingWithoutName(String midTableNumber) {
        return InitMidTableServiceHelper.getMidTableAndEntityMapping(midTableNumber, false).inverse();
    }

    public static Map<String, String> getMidTableAndEntityMapping(String midTableNumber) {
        return InitMidTableServiceHelper.getMidTableAndEntityMapping(midTableNumber, true);
    }

    private static BiMap<String, String> getMidTableAndEntityMapping(String midTableNumber, boolean containsBasedataName) {
        HashBiMap mapping = HashBiMap.create();
        StringBuilder fields = new StringBuilder();
        fields.append(HricDynamicObjectUtils.getFieldByPage((String)"hric_initinducttp")).append(",").append("pid");
        DynamicObject tempObject = InitTemplateServiceHelper.getInitTemplateByMidNumber(fields.toString(), midTableNumber);
        DynamicObjectCollection dynamicObjectCollection = tempObject.getDynamicObjectCollection("treeentryentity");
        HashMap entityCodeMap = new HashMap(AppConstants.MAP_SIZE);
        PredicateContainer<DynamicObject> entityCodePredicate = InitMidTableServiceHelper.getEntityCodePredicate();
        Map<Long, Long> parentIdMap = InitMidTableServiceHelper.buildParentMap(dynamicObjectCollection, entityCodePredicate);
        dynamicObjectCollection.forEach(it -> {
            if (entityCodePredicate.allMatch(it)) {
                entityCodeMap.put(it.getLong("id"), it.getString("entitynumber"));
            }
        });
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (!dynamicObject.getBoolean("isimport")) continue;
            InitMidTableServiceHelper.addMappingInfo((Map<String, String>)mapping, (String)entityCodeMap.get(parentIdMap.get(dynamicObject.getLong("id"))), dynamicObject, containsBasedataName);
        }
        return mapping;
    }

    private static Map<Long, Long> buildParentMap(DynamicObjectCollection dynamicObjectCollection, PredicateContainer<DynamicObject> entityCodePredicate) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(AppConstants.MAP_SIZE);
        Set parentIdSet = dynamicObjectCollection.stream().filter(it -> entityCodePredicate.allMatch(it)).map(it -> it.getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> dynMap = dynamicObjectCollection.stream().collect(Collectors.toMap(it -> it.getLong("id"), it -> it));
        dynamicObjectCollection.forEach(it -> {
            if (parentIdSet.contains(it.getLong("pid"))) {
                map.put(it.getLong("id"), it.getLong("pid"));
            } else {
                DynamicObject dyn = (DynamicObject)dynMap.get(it.getLong("pid"));
                if (null != dyn && parentIdSet.contains(dyn.getLong("pid"))) {
                    map.put(it.getLong("id"), dyn.getLong("pid"));
                }
            }
            if (parentIdSet.contains(it.getLong("id"))) {
                map.put(it.getLong("id"), it.getLong("id"));
            }
        });
        return map;
    }

    private static PredicateContainer<DynamicObject> getEntityCodePredicate() {
        PredicateContainer entityCodeContainer = PredicateContainer.getInstance();
        entityCodeContainer.append(dy -> dy.getBoolean("istablehead")).append(dy -> !"billhead".equals(dy.getString("entitynumber"))).append(dy -> !"billentry".equals(dy.getString("entitynumber")));
        return entityCodeContainer;
    }

    private static void addMappingInfo(Map<String, String> mapping, String entityCode, DynamicObject dynamicObject, boolean containsBaseDataName) {
        String entityNumber = dynamicObject.getString("entitynumber");
        String alias = dynamicObject.getString("numberalias");
        String importProp = dynamicObject.getString("importprop");
        String key = entityCode + "." + entityNumber;
        if (HRStringUtils.isEmpty((String)importProp)) {
            mapping.put(key, alias);
        } else if ("number".equals(importProp)) {
            mapping.put(key + "." + "number", alias);
            if (containsBaseDataName) {
                mapping.put(key + "." + "name", alias + "a");
            }
        } else if (HRStringUtils.equals((String)"name", (String)importProp)) {
            mapping.put(key + "." + "name", alias);
        } else {
            mapping.put(key + "." + importProp, alias);
        }
    }

    public static Set<String> getBillHeadNumberAlias(String midTableNumber) {
        DynamicObject tempObject = InitTemplateServiceHelper.getInitTemplateByMidNumber("number, intermediatetable, uniquestring, entitynumber, groupfield, pid, numberalias", midTableNumber);
        DynamicObjectCollection dynamicObjectCollection = tempObject.getDynamicObjectCollection("treeentryentity");
        Map<String, Long> aliasPidMap = dynamicObjectCollection.stream().filter(it -> HRStringUtils.isNotEmpty((String)it.getString("numberalias"))).collect(Collectors.toMap(it -> it.getString("numberalias"), it -> it.getLong("pid"), (o1, o2) -> o1));
        Set billHeadSet = dynamicObjectCollection.stream().filter(it -> "billhead".equals(it.getString("entitynumber"))).map(it -> it.getLong("id")).collect(Collectors.toSet());
        String unionStr = tempObject.getString("uniquestring");
        List unionList = Splitter.on((String)",").trimResults().splitToList((CharSequence)unionStr);
        return unionList.stream().filter(it -> billHeadSet.contains(aliasPidMap.get(it))).collect(Collectors.toSet());
    }

    public static Map<String, Long> queryCountGroupByStatus(String midTableNumber, QFilter qFilter) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)midTableNumber);
        return (Map)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)String.format(QUERY_OPERATE_GROUPBY_COUNT_SQL, entityType.getAlias(), QFilterUtils.getFilterSql((QFilter)qFilter, (String)midTableNumber)), (Object[])new Object[0], rs -> {
            HashMap result = Maps.newHashMapWithExpectedSize((int)2);
            while (rs.next()) {
                result.put(rs.getString("finitstatus"), rs.getLong("count"));
            }
            return result;
        });
    }

    public static Set<Long> queryUniqueFieldGroup(Set<String> dateTimeFieldInDBSet, Set<String> dataFieldInDBSet, Set<String> mulLangFieldInDBSet, String uniqueFields, String uniqueFieldsInDB, String midTableNumber, Long taskId, QFilter notEmptyQFilter, Set<String> dateFieldSet) {
        HashSet resultSet = Sets.newHashSetWithExpectedSize((int)16);
        if (HRStringUtils.isEmpty((String)uniqueFields) || HRStringUtils.isEmpty((String)uniqueFieldsInDB)) {
            return resultSet;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)midTableNumber);
        String uniqueVerifySql = InitMidTableServiceHelper.assembleUniqueVerifySql(dateTimeFieldInDBSet, dataFieldInDBSet, mulLangFieldInDBSet, uniqueFieldsInDB, midTableNumber, taskId, entityType.getAlias(), notEmptyQFilter, dateFieldSet);
        return (Set)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)uniqueVerifySql, (Object[])new Object[0], rs -> {
            while (rs.next()) {
                resultSet.add(rs.getLong("fid"));
            }
            return resultSet;
        });
    }

    private static String assembleUniqueVerifySql(Set<String> dateTimeFieldInDBSet, Set<String> dataFieldInDBSet, Set<String> mulLangFieldInDBSet, String uniqueFieldsInDB, String midTableNumber, Long taskID, String midTable, QFilter notEmptyQFilter, Set<String> dateFieldSet) {
        QFilter qFilter = InitMidTableServiceHelper.getQFilter(taskID, notEmptyQFilter);
        String uniqueVerifyFormatSql = "select  t5.fid from (%s) t4, (%s) t5 where %s";
        String queryUniqueGroupSql = InitMidTableServiceHelper.getQueryUniqueGroupSql(dateTimeFieldInDBSet, dataFieldInDBSet, uniqueFieldsInDB, mulLangFieldInDBSet, midTable, QFilterUtils.getFilterSql((QFilter)qFilter, (String)midTableNumber));
        String queryUniqueSql = InitMidTableServiceHelper.getQueryUniqueInfoSql(dateTimeFieldInDBSet, dataFieldInDBSet, uniqueFieldsInDB, mulLangFieldInDBSet, midTable, QFilterUtils.getFilterSql((QFilter)qFilter, (String)midTableNumber));
        String whereSql = Arrays.stream(uniqueFieldsInDB.split(",")).map(field -> {
            String baseFieldSql = " t4." + field + "=t5." + field + " ";
            if (dateTimeFieldInDBSet.contains(field)) {
                return "(" + baseFieldSql + " or  (t4." + field + " is null and t5." + field + " is null ))";
            }
            return baseFieldSql;
        }).collect(Collectors.joining("and"));
        if (!CollectionUtils.isEmpty(mulLangFieldInDBSet)) {
            whereSql = whereSql + " and t4.flocaleid = t5.flocaleid";
        }
        return String.format(uniqueVerifyFormatSql, queryUniqueGroupSql, queryUniqueSql, whereSql);
    }

    private static QFilter getQFilter(Long taskID, QFilter notEmptyQFilter) {
        String[] successStatus = new String[]{OperateEnum.INITIMPORTDATA.getSuccessStatus(), OperateEnum.INITCHECK.getSuccessStatus(), OperateEnum.CHECK.getSuccessStatus(), OperateEnum.SYNC.getSuccessStatus(), OperateEnum.VERIFY.getSuccessStatus(), OperateEnum.FINISH.getSuccessStatus()};
        if (null == notEmptyQFilter) {
            return new QFilter("hrictaskid", "=", (Object)taskID).and(new QFilter("initstatus", "in", Arrays.stream(successStatus).collect(Collectors.toSet())));
        }
        return new QFilter("hrictaskid", "=", (Object)taskID).and(new QFilter("initstatus", "in", Arrays.stream(successStatus).collect(Collectors.toSet()))).and(notEmptyQFilter);
    }

    private static String getQueryUniqueGroupSql(Set<String> dateTimeFieldInDBSet, Set<String> dataFieldInDBSet, String uniqueFieldsInDB, Set<String> mulLangFieldInDBSet, String midTable, String filterSql) {
        String query_unique_group_having_sql = "select %s from (%s) t3 group by %s having count(1) > 1";
        String queryUniqueBaseSql = InitMidTableServiceHelper.getQueryUniqueBaseSql(dateTimeFieldInDBSet, dataFieldInDBSet, uniqueFieldsInDB, mulLangFieldInDBSet, midTable, filterSql);
        String selectFieldSql = Arrays.stream(uniqueFieldsInDB.split(",")).map(field -> "t3." + field).collect(Collectors.joining(","));
        if (CollectionUtils.isEmpty(mulLangFieldInDBSet)) {
            return String.format(query_unique_group_having_sql, selectFieldSql, queryUniqueBaseSql, selectFieldSql);
        }
        selectFieldSql = selectFieldSql + ",t3.flocaleid";
        return String.format(query_unique_group_having_sql, selectFieldSql, queryUniqueBaseSql, selectFieldSql);
    }

    private static String getQueryUniqueInfoSql(Set<String> dateTimeFieldInDBSet, Set<String> dataFieldInDBSet, String uniqueFieldsInDB, Set<String> mulLangFieldInDBSet, String midTable, String filterSql) {
        String query_unique_base_sql = "select %s from %s where %s ";
        if (CollectionUtils.isEmpty(mulLangFieldInDBSet)) {
            String selectFieldSql = Arrays.stream(uniqueFieldsInDB.split(",")).map(field -> InitMidTableServiceHelper.getCaseField(dateTimeFieldInDBSet, dataFieldInDBSet, field)).collect(Collectors.joining(","));
            return String.format(query_unique_base_sql, InitMidTableServiceHelper.getOtherField(dateTimeFieldInDBSet, dataFieldInDBSet, mulLangFieldInDBSet) + selectFieldSql, midTable, filterSql);
        }
        String selectFieldSql = Arrays.stream(uniqueFieldsInDB.split(",")).map(field -> InitMidTableServiceHelper.getCasePrefixField(dateTimeFieldInDBSet, dataFieldInDBSet, mulLangFieldInDBSet, field)).collect(Collectors.joining(","));
        selectFieldSql = selectFieldSql + ",case when t1.flocaleid is null then '" + RequestContext.get().getLang().toString() + "' else t1.flocaleid end flocaleid";
        String fromSql = String.format("%s t left join %s t1 on t.fid = t1.fid and t1.flocaleid = %s", midTable, midTable + "_l", "'" + RequestContext.get().getLang().toString() + "'");
        return String.format(query_unique_base_sql, InitMidTableServiceHelper.getOtherField(dateTimeFieldInDBSet, dataFieldInDBSet, mulLangFieldInDBSet) + selectFieldSql, fromSql, filterSql);
    }

    private static String getOtherField(Set<String> dateTimeFieldInDBSet, Set<String> dataFieldInDBSet, Set<String> mulLangFieldInDBSet) {
        if (dateTimeFieldInDBSet.contains("FId") || dateTimeFieldInDBSet.contains("fid") || dataFieldInDBSet.contains("FId") || dataFieldInDBSet.contains("fid")) {
            return "";
        }
        return CollectionUtils.isEmpty(mulLangFieldInDBSet) ? "fid," : "t.fid,";
    }

    private static String getQueryUniqueBaseSql(Set<String> dateTimeFieldInDBSet, Set<String> dataFieldInDBSet, String uniqueFieldsInDB, Set<String> mulLangFieldInDBSet, String midTable, String filterSql) {
        String query_unique_base_sql = "select %s from %s where %s ";
        if (CollectionUtils.isEmpty(mulLangFieldInDBSet)) {
            String selectFieldSql = Arrays.stream(uniqueFieldsInDB.split(",")).map(field -> InitMidTableServiceHelper.getCaseField(dateTimeFieldInDBSet, dataFieldInDBSet, field)).collect(Collectors.joining(","));
            return String.format(query_unique_base_sql, selectFieldSql, midTable, filterSql);
        }
        String selectFieldSql = Arrays.stream(uniqueFieldsInDB.split(",")).map(field -> InitMidTableServiceHelper.getCasePrefixField(dateTimeFieldInDBSet, dataFieldInDBSet, mulLangFieldInDBSet, field)).collect(Collectors.joining(","));
        selectFieldSql = selectFieldSql + ",case when t1.flocaleid is null then '" + RequestContext.get().getLang().toString() + "' else t1.flocaleid end flocaleid";
        String fromSql = String.format("%s t left join %s t1 on t.fid = t1.fid and t1.flocaleid = %s", midTable, midTable + "_l", "'" + RequestContext.get().getLang().toString() + "'");
        return String.format(query_unique_base_sql, selectFieldSql, fromSql, filterSql);
    }

    private static String getCasePrefixField(Set<String> dateTimeFieldInDBSet, Set<String> dataFieldInDBSet, Set<String> mulLangFieldInDBSet, String field) {
        String prefixField = InitMidTableServiceHelper.getTablePrefix(field, mulLangFieldInDBSet) + field;
        if (dateTimeFieldInDBSet.contains(field)) {
            return field;
        }
        if (dataFieldInDBSet.contains(field)) {
            return " case when " + prefixField + " is null then 0 else " + prefixField + " end " + field;
        }
        return " case when " + prefixField + " is null then ' ' else " + prefixField + " end " + field;
    }

    private static String getCaseField(Set<String> dateTimeFieldInDBSet, Set<String> dataFieldInDBSet, String field) {
        if (dateTimeFieldInDBSet.contains(field)) {
            return field;
        }
        if (dataFieldInDBSet.contains(field)) {
            return " case when " + field + " is null then 0 else " + field + " end " + field;
        }
        return " case when " + field + " is null then ' ' else " + field + " end " + field;
    }

    private static String getTablePrefix(String field, Set<String> mulLangFieldInDBSet) {
        if (mulLangFieldInDBSet.contains(field)) {
            return "t1.";
        }
        return "t.";
    }
}

