/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.MessageSendServiceHelper;
import kd.hrmp.hric.common.InitMessageInfoBuilder;
import kd.hrmp.hric.common.bean.InitMessageInfo;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.DateUtils;

public class InitPlanServiceHelper {
    private static Log LOG = LogFactory.getLog(InitPlanServiceHelper.class);
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hric_initplan");
    private static final List<String> PLANSTATUS_LIST = ImmutableList.of((Object)"B", (Object)"C");
    private static final String QUERY_BIZSUBZREA_SQL = "select fid from t_hric_bizsubarearange where fbasedataid in (%s) ";
    private static final String QUERY_GROUP_SQL = "select count(1) as count from t_hric_grouprange where fid = %s";
    private static final String QUERY_BIZSUBAREACOUNT_SQL = "select count(1) as count from t_hric_bizsubarearange where fid = %s";

    public static DynamicObject[] getInitPlansById(Long id) {
        return serviceHelper.loadDynamicObjectArray(new QFilter("parent", "=", (Object)id).toArray());
    }

    public static DynamicObject[] getInitPlansByStructNumber(String structNumber) {
        return serviceHelper.loadDynamicObjectArray(new QFilter("structnumber", "like", (Object)(structNumber + "%")).and("planstatus", "!=", (Object)"E").toArray());
    }

    public static DynamicObject[] getSubInitPlansByParentIds(List<Long> ids) {
        Object[] dys = serviceHelper.loadDynamicObjectArray(new QFilter("parent", "in", ids).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static DynamicObject[] getSubInitPlansByParentId(Long id) {
        Object[] dys = serviceHelper.loadDynamicObjectArray(new QFilter("parent", "=", (Object)id).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static DynamicObject[] getSubInitPlansByStructNumber(String structNumber) {
        Object[] dys = serviceHelper.loadDynamicObjectArray(new QFilter("structnumber", "like", (Object)(structNumber + "%")).and("configmode", "in", (Object)AppConstants.CONFIG_MODE_LIST).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static DynamicObject[] getSubInitPlansByStructNumbers(List<String> structNumbers) {
        QFilter[] qFilterArr = new QFilter[2];
        qFilterArr[0] = new QFilter("configmode", "in", (Object)AppConstants.CONFIG_MODE_LIST);
        structNumbers.forEach(str -> {
            qFilterArr[1] = qFilterArr[1] == null ? new QFilter("structnumber", "like", (Object)(str + "%")) : qFilterArr[1].or(new QFilter("structnumber", "like", (Object)(str + "%")));
        });
        Object[] dys = serviceHelper.loadDynamicObjectArray(qFilterArr);
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static DynamicObject[] getSubPlanIdsByStructNumber(String structNumber) {
        Object[] dys = serviceHelper.query("id", new QFilter("structnumber", "like", (Object)(structNumber + "%")).and("configmode", "in", (Object)AppConstants.CONFIG_MODE_LIST).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static void delInitPlans(Long[] ids) {
        serviceHelper.delete((Object[])ids);
    }

    public static Map<Long, String> getAllMasterPlanName() {
        Object[] dys = serviceHelper.query("id,name", new QFilter[]{new QFilter("layer", "=", (Object)1)});
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new HashMap<Long, String>();
        }
        HashMap<Long, String> allNameMap = new HashMap<Long, String>();
        Arrays.stream(dys).forEach(dyc -> allNameMap.put(dyc.getLong("id"), dyc.getString("name")));
        return allNameMap;
    }

    public static List<DynamicObject> getAllPlan() {
        QFilter qFilter = new QFilter("planstatus", "!=", (Object)"E");
        Object[] dys = serviceHelper.query("id,structnumber", new QFilter[]{qFilter});
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.transferArrayToList((Object[])dys);
    }

    public static DynamicObject getPlansById(Long id) {
        return serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)id).toArray());
    }

    public static DynamicObject[] getPlansByIdList(List<Long> ids) {
        Object[] dys = serviceHelper.loadDynamicObjectArray(new QFilter("id", "in", ids).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static DynamicObject[] getPlanStructNumberByIdList(List<Long> ids) {
        Object[] dys = serviceHelper.query("id,structnumber,name", new QFilter("id", "in", ids).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static Object updatePlanInfo(DynamicObject[] dys) {
        return serviceHelper.update(dys);
    }

    public static void delMasterPlans(Long[] ids) {
        if (ids.length == 0) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        serviceHelper.deleteByFilter(new QFilter[]{qFilter.or(new QFilter("parent", "in", (Object)ids))});
    }

    public static void delSonPlans(Long[] ids) {
        if (ids.length == 0) {
            return;
        }
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("parent", "in", (Object)ids)});
    }

    public static void updateParentPlanStatusPositive(String type, DynamicObject dyn) {
        DynamicObject parentPlan = null;
        if (HRStringUtils.equals((String)type, (String)"1")) {
            parentPlan = dyn.getDynamicObject("belongplan");
            if (HRObjectUtils.isEmpty((Object)(parentPlan = InitPlanServiceHelper.getPlansById(parentPlan.getLong("id")))) || !InitPlanServiceHelper.validateTaskAllFinished(parentPlan.getLong("id"))) {
                return;
            }
            InitPlanServiceHelper.updateParentPlansPositive(parentPlan);
        }
    }

    private static void updateParentPlansPositive(DynamicObject currentPlan) {
        DynamicObject plan;
        Long planId;
        String structNumber = currentPlan.getString("structnumber");
        DynamicObject[] planList = InitPlanServiceHelper.getAllParentPlans(structNumber);
        DynamicObject root = planList[planList.length - 1];
        List<Long> idList = Arrays.stream(planList).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        DynamicObject[] allPlans = InitPlanServiceHelper.getSubInitPlansByParentIds(idList);
        Map<Long, DynamicObject> planMap = Arrays.stream(allPlans).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        planMap.put(root.getLong("id"), root);
        Map<Long, List<DynamicObject>> parentMap = InitPlanServiceHelper.getParentSonMap(allPlans);
        ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(planList.length);
        ArrayList<InitMessageInfo> infoList = new ArrayList<InitMessageInfo>();
        DynamicObject[] dynamicObjectArray = planList;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n && ((planId = Long.valueOf((plan = dynamicObjectArray[i]).getLong("id"))).longValue() == currentPlan.getLong("id") || !HRObjectUtils.isEmpty((Object)plan) && InitPlanServiceHelper.validateSubPlanAllFinished(planId, parentMap)); ++i) {
            DynamicObject planDyn = planMap.get(planId);
            if (planDyn == root) {
                planDyn = InitPlanServiceHelper.getPlansById(root.getLong("id"));
            }
            if (HRStringUtils.equals((String)"C", (String)planDyn.getString("planstatus"))) {
                planDyn.set("planstatus", (Object)"C");
                planDyn.set("actualenddate", (Object)new Date());
                dynList.add(planDyn);
                continue;
            }
            planDyn.set("planstatus", (Object)"C");
            planDyn.set("actualenddate", (Object)new Date());
            dynList.add(planDyn);
            InitPlanServiceHelper.buildInfo(planDyn, infoList);
        }
        if (!CollectionUtils.isEmpty(dynList)) {
            serviceHelper.update(dynList.toArray(new DynamicObject[dynList.size()]));
        }
        if (!CollectionUtils.isEmpty(infoList)) {
            MessageSendServiceHelper.saveMessage(infoList);
        }
    }

    private static void buildInfo(DynamicObject plan, List<InitMessageInfo> infoList) {
        String content;
        ArrayList<Long> receivers = new ArrayList<Long>();
        if (null != plan.get("planperson")) {
            receivers.add(plan.get("planperson") instanceof DynamicObject ? plan.getDynamicObject("planperson").getLong("id") : plan.getLong("planperson"));
        }
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"name");
        if (HRStringUtils.equals((String)plan.getString("planstatus"), (String)"B")) {
            InitMessageInfo info = new InitMessageInfoBuilder().buildReceivers(receivers).buildSenderName(currentUser.getString("name")).buildSenderId(Long.valueOf(currentUser.getLong("id"))).buildEntityName("hric_initplandetail").buildEntityId(Long.valueOf(plan.getLong("id"))).buildContent(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u8d1f\u8d23\u7684%s\u72b6\u6001\u5df2\u66f4\u65b0\u4e3a\u201c\u6267\u884c\u4e2d\u201d\u3002", (String)"InitPlanServiceHelper_4", (String)"hrmp-hric-business", (Object[])new Object[0]), plan.getString("name"))).buildTitle(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8ba1\u5212\u72b6\u6001\u66f4\u65b0\u63d0\u9192", (String)"InitPlanServiceHelper_2", (String)"hrmp-hric-business", (Object[])new Object[0])).buildTag(ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb!", (String)"InitPlanServiceHelper_3", (String)"hrmp-hric-business", (Object[])new Object[0])).build();
            infoList.add(info);
            return;
        }
        if (null == plan.get("parent")) {
            String typeStr = HRStringUtils.equals((String)plan.getString("configmode"), (String)"A") ? ResManager.loadKDString((String)"\u8ba1\u5212", (String)"InitPlanServiceHelper_6", (String)"hrmp-hric-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4efb\u52a1", (String)"InitPlanServiceHelper_7", (String)"hrmp-hric-business", (Object[])new Object[0]);
            content = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u8d1f\u8d23\u7684%s\u5df2\u66f4\u65b0\u4e3a\u5df2\u5b8c\u6210\u3002\u8bf7\u524d\u5f80\u624b\u52a8\u6267\u884c\u201c\u8ba1\u5212\u521d\u59cb\u5316\u5b8c\u6210\u201d\u3002", (String)"InitPlanServiceHelper_5", (String)"hrmp-hric-business", (Object[])new Object[0]), plan.getString("name"), typeStr);
        } else {
            content = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u8d1f\u8d23\u7684%s\u72b6\u6001\u5df2\u66f4\u65b0\u4e3a\u201c\u5df2\u5b8c\u6210\u201d\u3002", (String)"InitPlanServiceHelper_0", (String)"hrmp-hric-business", (Object[])new Object[0]), plan.getString("name"));
        }
        InitMessageInfo info = new InitMessageInfoBuilder().buildReceivers(receivers).buildSenderName(currentUser.getString("name")).buildSenderId(Long.valueOf(currentUser.getLong("id"))).buildEntityName("hric_initplandetail").buildEntityId(Long.valueOf(plan.getLong("id"))).buildContent(content).buildTitle(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8ba1\u5212\u72b6\u6001\u66f4\u65b0\u63d0\u9192", (String)"InitPlanServiceHelper_2", (String)"hrmp-hric-business", (Object[])new Object[0])).buildTag(ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb!", (String)"InitPlanServiceHelper_3", (String)"hrmp-hric-business", (Object[])new Object[0])).build();
        infoList.add(info);
    }

    private static Map<Long, List<DynamicObject>> getParentSonMap(DynamicObject[] allPlans) {
        HashMap<Long, List<DynamicObject>> parentMap = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject dyn : allPlans) {
            long parentId = dyn.getLong("parent.id");
            parentMap.computeIfAbsent(parentId, k -> new ArrayList());
            ((List)parentMap.get(parentId)).add(dyn);
        }
        return parentMap;
    }

    public static DynamicObject[] getAllParentPlans(String structNumber) {
        HashSet structNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        int index = structNumber.indexOf(33);
        while (index > 0) {
            structNumberSet.add(structNumber.substring(0, index));
            index = structNumber.indexOf(33, index + 1);
        }
        structNumberSet.add(structNumber);
        QFilter qFilter = new QFilter("structnumber", "in", (Object)structNumberSet);
        return serviceHelper.query("id, planstatus,planperson,parent,name", qFilter.toArray(), "structnumber desc");
    }

    public static void batchUpdateParentPlanStatusNegative(DynamicObject[] dyns) {
        DynamicObjectCollection plans = new DynamicObjectCollection();
        List parentPlans = Arrays.asList(dyns).stream().map(it -> it.getDynamicObject("belongplan")).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(parentPlans)) {
            return;
        }
        ArrayList<InitMessageInfo> infoList = new ArrayList<InitMessageInfo>();
        DynamicObject[] plansList = InitPlanServiceHelper.getPlansByIdList(parentPlans.stream().map(it -> it.getLong("id")).collect(Collectors.toList()));
        List<DynamicObject> executePlan = Arrays.asList(plansList).stream().filter(it -> !HRStringUtils.equals((String)it.getString("planstatus"), (String)"B")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(executePlan)) {
            return;
        }
        for (DynamicObject plan : executePlan) {
            plan.set("planstatus", (Object)"B");
            plan.set("actualenddate", null);
            InitPlanServiceHelper.buildInfo(plan, infoList);
        }
        plans.addAll(executePlan);
        InitPlanServiceHelper.updateParentStatusNegative(executePlan, plans, infoList);
        serviceHelper.save(plans);
        if (!CollectionUtils.isEmpty(infoList)) {
            MessageSendServiceHelper.saveMessage(infoList);
        }
    }

    public static void updateParentStatusNegative(List<DynamicObject> dyn, DynamicObjectCollection plans, List<InitMessageInfo> infoList) {
        List<String> structNumbers = dyn.stream().map(it -> it.getString("structnumber")).collect(Collectors.toList());
        ArrayList<String> structList = new ArrayList<String>(AppConstants.LIST_SIZE);
        structNumbers.forEach(structNumber -> {
            int index = structNumber.indexOf(33);
            while (index > 0) {
                structList.add(structNumber.substring(0, index));
                index = structNumber.indexOf(33, index + 1);
            }
        });
        DynamicObject[] parePlanList = InitPlanServiceHelper.getPlanByStructNumbers(structList);
        Arrays.asList(parePlanList).forEach(plan -> {
            if (HRStringUtils.equals((String)plan.getString("planstatus"), (String)"B")) {
                return;
            }
            plan.set("planstatus", (Object)"B");
            plan.set("actualenddate", null);
            plans.add(plan);
            InitPlanServiceHelper.buildInfo(plan, infoList);
        });
    }

    private static boolean validateTaskAllFinished(long parentId) {
        DynamicObject[] initTasks;
        boolean isAllFinish = true;
        for (DynamicObject initTask : initTasks = InitTaskServiceHelper.getInitTaskByPlan(parentId)) {
            if (HRStringUtils.equals((String)initTask.getString("tasktype"), (String)"A") || HRStringUtils.equals((String)initTask.getString("taskstatus"), (String)"C") || HRStringUtils.equals((String)initTask.getString("taskstatus"), (String)"D")) continue;
            isAllFinish = false;
        }
        return isAllFinish;
    }

    private static boolean validateSubPlanAllFinished(long parentId, Map<Long, List<DynamicObject>> parentMap) {
        boolean isAllFinish = true;
        List<DynamicObject> subPlans = parentMap.get(parentId);
        for (DynamicObject subPlanDyn : subPlans) {
            if (HRStringUtils.equals((String)subPlanDyn.getString("planstatus"), (String)"C") || HRStringUtils.equals((String)subPlanDyn.getString("planstatus"), (String)"D")) continue;
            isAllFinish = false;
            break;
        }
        return isAllFinish;
    }

    public static List<HashMap<String, String>> getAllPlanNumber() {
        Object[] dys = serviceHelper.query("id,number", null);
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new ArrayList<HashMap<String, String>>();
        }
        ArrayList<HashMap<String, String>> numberList = new ArrayList<HashMap<String, String>>();
        Arrays.stream(dys).forEach(dyc -> {
            HashMap<String, String> numberMap = new HashMap<String, String>();
            numberMap.put("id", dyc.getLong("id") + "");
            numberMap.put("number", dyc.getString("number"));
            numberList.add(numberMap);
        });
        return numberList;
    }

    public static DynamicObject[] getImplItemPlanByStructNumber(String structNumber) {
        Object[] dys = serviceHelper.query("id,bizsubarea,planstatus,itementryentity.implitem,itementryentity.isskip", new QFilter[]{new QFilter("structnumber", "like", (Object)(structNumber + "%")).and(new QFilter("configmode", "in", (Object)AppConstants.CONFIG_MODE_LIST)).and(new QFilter("planstatus", "in", PLANSTATUS_LIST))});
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static DynamicObject[] getAllSonPlans(String structNumber) {
        QFilter qFilter = new QFilter("structnumber", "like", (Object)(structNumber + "%"));
        qFilter.and(new QFilter("planstatus", "!=", (Object)"E"));
        return serviceHelper.query("id, name, structnumber", qFilter.toArray(), "structnumber");
    }

    public static DynamicObject getMasterPlanByStructNumber(String structNumber) {
        return serviceHelper.loadDynamicObject(new QFilter("structnumber", "=", (Object)structNumber));
    }

    public static DynamicObject[] getRemindPlan(int nearDay, int extendedDay) {
        QFilter qFilter = new QFilter("enddate", ">=", (Object)DateUtils.getBeforeOrAfterDate((Date)DateUtils.getNowDateZero(), (int)extendedDay));
        qFilter.and("enddate", "<=", (Object)DateUtils.getBeforeOrAfterDate((Date)DateUtils.getNowDateZero(), (int)nearDay));
        qFilter.and("planstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B"}));
        Object[] dys = serviceHelper.loadDynamicObjectArray(qFilter.toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static DynamicObject[] getPlanByStructNumbers(List<String> structNumbers) {
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("structnumber", "in", structNumbers)});
    }

    public static DynamicObject getPlanByStructNumber(String structNumbers) {
        return serviceHelper.loadDynamicObject(new QFilter[]{new QFilter("structnumber", "=", (Object)structNumbers)});
    }

    public static DynamicObject[] getSonPlans(String structNumber) {
        QFilter qFilter = new QFilter("structnumber", "like", (Object)(structNumber + "%"));
        Object[] dys = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static void updateDynamicObjects(DynamicObject[] dys) {
        serviceHelper.updateDatas(dys);
    }

    public static int getMyPlanForCard() {
        QFilter qFilter = new QFilter("planperson", "=", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("planstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B"}));
        return serviceHelper.count("hric_initplan", qFilter.toArray());
    }

    public static QFilter getMyPlanForCardQfilter() {
        QFilter qFilter = new QFilter("planperson", "=", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("planstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B"}));
        return qFilter;
    }

    public static DynamicObject[] getPlanByBizArea(String areaIds) {
        ResultSetHandler action = rs -> {
            ArrayList<Long> list = new ArrayList<Long>();
            while (rs.next()) {
                list.add(rs.getLong("FId"));
            }
            return list;
        };
        List list = (List)DB.query((DBRoute)DBRoute.of((String)EntityMetadataCache.getDataEntityType((String)"hric_initplan").getDBRouteKey()), (String)String.format(Locale.ROOT, QUERY_BIZSUBZREA_SQL, areaIds), (ResultSetHandler)action);
        return InitPlanServiceHelper.getPlansByIdList(list);
    }

    public static long getBizAreaCountByPlanId(Long planId) {
        ResultSetHandler action = rs -> {
            ArrayList<Long> list = new ArrayList<Long>();
            while (rs.next()) {
                list.add(rs.getLong("count"));
            }
            return list;
        };
        return (Long)((List)DB.query((DBRoute)DBRoute.of((String)EntityMetadataCache.getDataEntityType((String)"hric_initplan").getDBRouteKey()), (String)String.format(Locale.ROOT, QUERY_GROUP_SQL, planId), (ResultSetHandler)action)).get(0);
    }

    public static long getBizSubAreaCountByPlanId(Long planId) {
        ResultSetHandler action = rs -> {
            ArrayList<Long> list = new ArrayList<Long>();
            while (rs.next()) {
                list.add(rs.getLong("count"));
            }
            return list;
        };
        return (Long)((List)DB.query((DBRoute)DBRoute.of((String)EntityMetadataCache.getDataEntityType((String)"hric_initplan").getDBRouteKey()), (String)String.format(Locale.ROOT, QUERY_BIZSUBAREACOUNT_SQL, planId), (ResultSetHandler)action)).get(0);
    }

    public static boolean isUpdateBaseField(long areaId) {
        DynamicObject[] plans = InitPlanServiceHelper.getPlanByBizArea(ConvertUtils.toString((Object)areaId));
        return !Arrays.asList(plans).stream().anyMatch(plan -> HRStringUtils.equals((String)plan.getString("planstatus"), (String)"B") || HRStringUtils.equals((String)plan.getString("planstatus"), (String)"C") && !HRStringUtils.equals((String)plan.getString("initfinish"), (String)"A"));
    }

    public static DynamicObject[] getPlanFields(String queryFields, String qFilterField, List<Long> planIds) {
        DynamicObject[] dys = serviceHelper.query(queryFields, new QFilter(qFilterField, "in", planIds).toArray());
        if (Objects.isNull(dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static void updateCurrTaskBelongPlanFinishStatus(List<DynamicObject> initTaskDycs) {
        ArrayList<Long> planIds = new ArrayList<Long>();
        List<Long> planIdList = initTaskDycs.stream().map(task -> task.getDynamicObject("belongplan").getLong("id")).collect(Collectors.toList());
        Object[] taskDycs = InitTaskServiceHelper.getImplExecTaskByPlanIds(planIdList);
        if (ObjectUtils.isEmpty((Object[])taskDycs)) {
            LOG.info("[HRIC] method:updateCurrTaskBelongPlanFinishStatus, The ImplItemExecuteTask cannot be queried according to the plan ID");
        }
        Map<Long, List<DynamicObject>> planTaskMapping = Arrays.stream(taskDycs).collect(Collectors.groupingBy(task -> task.getDynamicObject("belongplan").getLong("id")));
        planTaskMapping.entrySet().stream().forEach(entry -> {
            if (((List)entry.getValue()).stream().allMatch(dyc -> HRStringUtils.equals((String)dyc.getString("initfinish"), (String)"A"))) {
                planIds.add((Long)entry.getKey());
            }
        });
        if (CollectionUtils.isEmpty(planIds)) {
            return;
        }
        DynamicObject[] plans = InitPlanServiceHelper.getPlansByIdList(planIds);
        ArrayList<String> structNumbers = new ArrayList<String>();
        Arrays.stream(plans).forEach(plan -> {
            plan.set("initfinish", (Object)"A");
            structNumbers.add(plan.getString("structnumber"));
        });
        InitPlanServiceHelper.updateDynamicObjects(plans);
        InitPlanServiceHelper.updateParentPlanFinishStatus(structNumbers);
    }

    public static void updateParentPlanFinishStatus(List<String> structNumbers) {
        String planStructNumber = structNumbers.get(0);
        Splitter splitter = Splitter.on((char)'!').trimResults().omitEmptyStrings();
        String masterPlanStructNumber = (String)splitter.trimResults().omitEmptyStrings().splitToList((CharSequence)planStructNumber).get(0);
        DynamicObject[] plans = InitPlanServiceHelper.getSonPlans(masterPlanStructNumber);
        Map<Long, DynamicObject> planMps = Arrays.stream(plans).collect(Collectors.toMap(plan -> plan.getLong("id"), plan -> plan));
        ArrayList<Long> parentIds = new ArrayList<Long>();
        structNumbers.forEach(structNumber -> planMps.values().forEach(plan -> {
            if (plan.getString("structnumber").contains((CharSequence)structNumber)) {
                plan.set("initfinish", (Object)"A");
            }
            if (plan.getDynamicObject("parent") != null && HRStringUtils.equals((String)structNumber, (String)plan.getString("structnumber"))) {
                parentIds.add(plan.getDynamicObject("parent").getLong("id"));
            }
        }));
        InitPlanServiceHelper.findParent(planMps, parentIds);
        InitPlanServiceHelper.updateDynamicObjects(plans);
    }

    private static void findParent(Map<Long, DynamicObject> planMps, List<Long> parentIds) {
        if (CollectionUtils.isEmpty(parentIds)) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        List planList = planMps.values().stream().collect(Collectors.toList());
        parentIds.forEach(id -> {
            if (planList.stream().allMatch(plan -> {
                DynamicObject dyc = plan.getDynamicObject("parent");
                return dyc == null || !id.equals(dyc.getLong("id")) || HRStringUtils.equals((String)plan.getString("initfinish"), (String)"A");
            })) {
                ((DynamicObject)planMps.get(id)).set("initfinish", (Object)"A");
                DynamicObject parentDyc = ((DynamicObject)planMps.get(id)).getDynamicObject("parent");
                if (parentDyc != null && parentDyc.getLong("id") != 0L) {
                    ids.add(parentDyc.getLong("id"));
                }
            }
        });
        InitPlanServiceHelper.findParent(planMps, ids);
    }

    public static DynamicObject[] getAllPlans() {
        QFilter qFilter = new QFilter("planstatus", "!=", (Object)"E");
        Object[] dys = serviceHelper.query("id,structnumber,parent,createtime", new QFilter[]{qFilter});
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static DynamicObject[] getPlanByListQFilter(QFilter listQFilter) {
        QFilter qFilter = new QFilter("planstatus", "!=", (Object)"E");
        Object[] dys = serviceHelper.query("id,structnumber,parent,createtime", new QFilter[]{qFilter.and(listQFilter)});
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static List<DynamicObject> getAllPlansWithDataRule(QFilter dataRuleFilter) {
        Object[] docs = serviceHelper.query("id,structnumber,parent,createtime", new QFilter[]{new QFilter("planstatus", "!=", (Object)"E").and(dataRuleFilter)});
        if (ObjectUtils.isEmpty((Object[])docs)) {
            return new ArrayList<DynamicObject>();
        }
        return InitPlanServiceHelper.getFirstPlans((DynamicObject[])docs);
    }

    public static List<DynamicObject> getFirstPlans(DynamicObject[] docs) {
        Map<String, DynamicObject> docMap = Arrays.stream(docs).collect(Collectors.toMap(doc -> doc.getString("structnumber"), doc -> doc, (k1, k2) -> k1));
        List structNumbers = docMap.keySet().stream().sorted().collect(Collectors.toList());
        LinkedList<DynamicObject> queue = new LinkedList<DynamicObject>();
        for (String struct : structNumbers) {
            if (!queue.isEmpty() && struct.startsWith(queue.getLast().getString("structnumber"))) continue;
            queue.offer(docMap.get(struct));
        }
        return queue;
    }
}

