/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.bussiness.service.MessageSendServiceHelper;
import kd.hrmp.hric.common.NoParamConsumer;
import kd.hrmp.hric.common.bean.InitMessageInfo;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.exception.code.HRICErrorEnum;
import kd.hrmp.hric.common.util.ConvertUtils;

public class InitTaskServiceHelper {
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hric_inittask");
    private static Log LOG = LogFactory.getLog(InitTaskServiceHelper.class);
    private static QFilter TOBEGENERATE_STATUS_QFILTER = new QFilter("taskstatus", "!=", (Object)"Z");
    private static QFilter PARENT_TASK_QFILTER = new QFilter("parent", "=", (Object)0);

    public static DynamicObject[] getInitTaskByPlan(long planId) {
        QFilter qFilter = new QFilter("belongplan", "=", (Object)planId);
        return serviceHelper.loadDynamicObjectArray(qFilter.and(TOBEGENERATE_STATUS_QFILTER).and(PARENT_TASK_QFILTER).toArray());
    }

    public static DynamicObject[] getTaskNumbersWithCurrPlan(String taskNumberPrefix) {
        ArrayList qFilterList = Lists.newArrayList();
        qFilterList.add(new QFilter("number", "like", (Object)("%" + taskNumberPrefix)));
        qFilterList.add(PARENT_TASK_QFILTER);
        return serviceHelper.query("number", qFilterList.toArray(new QFilter[0]));
    }

    public static DynamicObject[] getInitTaskByPlanList(List<Long> planIds) {
        QFilter qFilter = new QFilter("belongplan", "in", planIds);
        return serviceHelper.loadDynamicObjectArray(qFilter.and(TOBEGENERATE_STATUS_QFILTER).and(PARENT_TASK_QFILTER).toArray());
    }

    public static DynamicObject[] getExecAndVerifyTaskByPlanIds(String selectProperties, List<Long> planIds) {
        QFilter[] qFilters = new QFilter("belongplan", "in", planIds).and(new QFilter("tasktype", "in", (Object)new String[]{"B", "C"})).and(TOBEGENERATE_STATUS_QFILTER).toArray();
        return serviceHelper.query(selectProperties, qFilters);
    }

    public static DynamicObject[] getImplItemTaskByPlanIds(List<Long> planIds) {
        Object[] result = serviceHelper.query("id,taskstatus", new QFilter("belongplan", "in", planIds).and(new QFilter("tasktype", "=", (Object)"B")).and(TOBEGENERATE_STATUS_QFILTER).and(PARENT_TASK_QFILTER).toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new DynamicObject[0];
        }
        return result;
    }

    public static DynamicObject[] getNonExecImplItemTaskByPlanIds(List<Long> planIds) {
        Object[] result = serviceHelper.loadDynamicObjectArray(new QFilter("belongplan", "in", planIds).and(new QFilter("tasktype", "=", (Object)"B").and(new QFilter("initfinish", "!=", (Object)"A"))).and(TOBEGENERATE_STATUS_QFILTER).and(PARENT_TASK_QFILTER).toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new DynamicObject[0];
        }
        return result;
    }

    public static DynamicObject[] getTaskByPlanIds(List<Long> planIds) {
        ArrayList taskType = Lists.newArrayList((Object[])new String[]{"B", "C"});
        Object[] result = serviceHelper.loadDynamicObjectArray(new QFilter("belongplan", "in", planIds).and(new QFilter("tasktype", "in", (Object)taskType)).and(TOBEGENERATE_STATUS_QFILTER).and(PARENT_TASK_QFILTER).toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new DynamicObject[0];
        }
        return result;
    }

    public static DynamicObject[] getImplExecTaskByPlanIds(List<Long> planIds) {
        Object[] result = serviceHelper.loadDynamicObjectArray(new QFilter("belongplan", "in", planIds).and(new QFilter("tasktype", "=", (Object)"B")).and(TOBEGENERATE_STATUS_QFILTER).and(PARENT_TASK_QFILTER).toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new DynamicObject[0];
        }
        return result;
    }

    public static DynamicObject[] getDataVerifyTaskByPlanIds(List<Long> planIds) {
        Object[] result = serviceHelper.loadDynamicObjectArray(new QFilter("belongplan", "in", planIds).and(new QFilter("tasktype", "=", (Object)"C")).and(TOBEGENERATE_STATUS_QFILTER).toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new DynamicObject[0];
        }
        return result;
    }

    public static DynamicObject getTask(long id) {
        return serviceHelper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    public static DynamicObject getTask(String selectProperties, long id) {
        return serviceHelper.queryOne(selectProperties, (Object)id);
    }

    public static DynamicObject[] getTaskList(List<Long> ids) {
        Object[] dys = serviceHelper.loadDynamicObjectArray(new QFilter("id", "in", ids).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static DynamicObject[] getTaskListContainSonTask(List<Long> ids) {
        Object[] dys = serviceHelper.loadDynamicObjectArray(new QFilter("id", "in", ids).or(new QFilter("parent", "in", ids)).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    public static DynamicObject[] getPostTask(long id) {
        String sql = "select fid from t_hric_pretask where fbasedataid = " + id;
        HashSet<Long> idSet = new HashSet<Long>();
        try (DataSet ds = HRDBUtil.queryDataSet((String)"hrmp_hric_pretask", (DBRoute)new DBRoute(AppMetadataCache.getAppInfo((String)"hric").getDbRoute()), (String)sql, (Object[])new Object[0]);){
            while (ds.hasNext()) {
                Row row = ds.next();
                idSet.add(row.getLong("fid"));
            }
        }
        return serviceHelper.loadDynamicObjectArray(idSet.toArray());
    }

    public static Object updateTaskFinish(DynamicObject dynamicObject) {
        if (HRStringUtils.equals((String)dynamicObject.getString("taskstatus"), (String)"F")) {
            dynamicObject.set("taskstatus", (Object)"A");
            dynamicObject.set("taskendtime", null);
            dynamicObject.set("taskbegintime", null);
            Object result = serviceHelper.updateOne(dynamicObject);
            InitTaskServiceHelper.updatePreTask(dynamicObject);
            return result;
        }
        dynamicObject.set("taskstatus", (Object)"C");
        dynamicObject.set("taskendtime", (Object)new Date());
        Object result = serviceHelper.updateOne(dynamicObject);
        InitPlanServiceHelper.updateParentPlanStatusPositive("1", dynamicObject);
        InitTaskServiceHelper.updatePostTask(dynamicObject, "1", null);
        return result;
    }

    private static void updatePreTask(DynamicObject dynamicObject) {
        Object preTmpTaskBase2;
        DynamicObject[] postTask = InitTaskServiceHelper.getPostTask(dynamicObject.getLong("id"));
        List<DynamicObject> executeTasks = Arrays.asList(postTask).stream().filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)"E")).collect(Collectors.toList());
        ArrayList<DynamicObject> executeTaskList = new ArrayList<DynamicObject>(executeTasks.size());
        block0: for (DynamicObject dynTask : executeTasks) {
            for (Object preTmpTaskBase2 : dynTask.getDynamicObjectCollection("pretask")) {
                DynamicObject preTmpTask = preTmpTaskBase2.getDynamicObject("fbasedataid");
                if (!HRStringUtils.equals((String)preTmpTask.getString("taskstatus"), (String)"E") && !HRStringUtils.equals((String)preTmpTask.getString("taskstatus"), (String)"F")) continue;
                continue block0;
            }
            executeTaskList.add(dynTask);
        }
        ArrayList<InitMessageInfo> infoList = new ArrayList<InitMessageInfo>(executeTasks.size());
        DynamicObjectCollection dyPreTask = dynamicObject.getDynamicObjectCollection("pretask");
        List<Long> dyPreTaskIds = dyPreTask.stream().map(it -> it.getDynamicObject("fbasedataid")).map(it -> it.getLong("id")).collect(Collectors.toList());
        preTmpTaskBase2 = executeTaskList.iterator();
        while (preTmpTaskBase2.hasNext()) {
            DynamicObject executeTask;
            List execPost = Arrays.asList(InitTaskServiceHelper.getPostTask((executeTask = (DynamicObject)preTmpTaskBase2.next()).getLong("id"))).stream().filter(task -> HRStringUtils.equals((String)task.getString("tasktype"), (String)"B") && !HRStringUtils.equals((String)task.getString("taskstatus"), (String)"A")).collect(Collectors.toList());
            executeTask.set("taskstatus", (Object)(CollectionUtils.isEmpty(execPost) ? "B" : "F"));
            executeTask.set("taskendtime", null);
            executeTask.set("taskbegintime", (Object)new Date());
            InitMessageInfo info = MessageSendServiceHelper.buildTaskMessage(executeTask, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u63d0\u9192\uff1a\u4efb\u52a1\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\uff01", (String)"InitTaskServiceHelper_2", (String)"hrmp-hric-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb!", (String)"InitTaskServiceHelper_3", (String)"hrmp-hric-business", (Object[])new Object[0]), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u8d1f\u8d23\u7684%1$s\u72b6\u6001\u5df2\u66f4\u65b0\u4e3a%2$s\uff0c\u8bf7\u524d\u5f80\u5904\u7406\uff01", (String)"InitTaskServiceHelper_5", (String)"hrmp-hric-business", (Object[])new Object[0]), executeTask.getString("name"), ((ComboProp)executeTask.getDynamicObjectType().getProperty("taskstatus")).getItemByName(executeTask.getString("taskstatus"))));
            infoList.add(info);
        }
        if (!CollectionUtils.isEmpty(executeTaskList)) {
            executeTaskList.add(dynamicObject);
            serviceHelper.update(executeTaskList.toArray(new DynamicObject[0]));
        }
        for (DynamicObject executeTask : executeTasks) {
            List<DynamicObject> preTaskList = executeTask.getDynamicObjectCollection("pretask").stream().map(it -> it.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            DynamicObjectCollection exPre = new DynamicObjectCollection();
            preTaskList.forEach(task -> {
                if (task.getLong("id") != dynamicObject.getLong("id") && !HRStringUtils.equals((String)task.getString("taskstatus"), (String)"A")) {
                    exPre.add(task);
                }
            });
            executeTask.set("pretask", InitTaskServiceHelper.getMulCollection((List<DynamicObject>)exPre, executeTask));
        }
        if (!CollectionUtils.isEmpty(executeTasks)) {
            dyPreTaskIds.addAll(executeTasks.stream().map(it -> it.getLong("id")).collect(Collectors.toList()));
            DynamicObject[] dyPre = InitTaskServiceHelper.getTaskList(dyPreTaskIds);
            dynamicObject.set("pretask", InitTaskServiceHelper.getMulCollection(Arrays.asList(dyPre), dynamicObject));
            executeTasks.add(dynamicObject);
            serviceHelper.update(executeTasks.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty(infoList)) {
            MessageSendServiceHelper.saveMessage(infoList);
        }
    }

    private static Object getMulCollection(List<DynamicObject> dynList, DynamicObject task) {
        if (CollectionUtils.isEmpty(dynList)) {
            return null;
        }
        MulBasedataDynamicObjectCollection mulCollection = new MulBasedataDynamicObjectCollection();
        dynList.forEach(dyn -> {
            if (HRStringUtils.equals((String)dyn.getString("tasktype"), (String)"B")) {
                DynamicObject dynamicObject = new DynamicObject(task.getDynamicObjectCollection("pretask").getDynamicObjectType());
                dynamicObject.set(0, null);
                dynamicObject.set(1, dyn);
                mulCollection.add(dynamicObject);
            }
        });
        return mulCollection;
    }

    public static Object updateTaskNegative(DynamicObject dynamicObject, Long itemId) {
        dynamicObject.set("taskstatus", (Object)"B");
        dynamicObject.set("taskendtime", null);
        Object result = serviceHelper.updateOne(dynamicObject);
        InitPlanServiceHelper.batchUpdateParentPlanStatusNegative(new DynamicObject[]{dynamicObject});
        InitTaskServiceHelper.updatePostTask(dynamicObject, "1", itemId);
        return result;
    }

    public static void updateTaskInfo(DynamicObject[] dys) {
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return;
        }
        serviceHelper.update(dys);
    }

    public static DynamicObject[] getSubPlanTask(long id) {
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("belongplan", "=", (Object)id), TOBEGENERATE_STATUS_QFILTER, PARENT_TASK_QFILTER});
    }

    public static DynamicObject getPlanTaskByPlanNumber(String number) {
        return serviceHelper.loadDynamicObject(new QFilter[]{new QFilter("number", "=", (Object)number)});
    }

    public static void updatePostTask(DynamicObject task, String direction, Long itemId) {
        DynamicObject[] postTasks = InitTaskServiceHelper.getPostTask(task.getLong("id"));
        switch (direction) {
            case "1": {
                InitTaskServiceHelper.updatePostTaskPositive(postTasks, itemId);
            }
        }
    }

    private static void updatePostTaskPositive(DynamicObject[] tasks, Long itemId) {
        DynamicObjectCollection statusChangeTasks = new DynamicObjectCollection();
        ArrayList<InitMessageInfo> infoList = new ArrayList<InitMessageInfo>();
        for (DynamicObject postTask : tasks) {
            boolean validatePreTaskAllFinish = InitTaskServiceHelper.validatePreTaskAllFinish(postTask);
            if ("A".equals(postTask.getString("taskstatus")) && validatePreTaskAllFinish) {
                postTask.set("taskstatus", (Object)"B");
                postTask.set("taskbegintime", (Object)new Date());
                statusChangeTasks.add((Object)postTask);
                InitTaskServiceHelper.buildInfo(postTask, infoList, Boolean.TRUE);
                continue;
            }
            if (!"B".equals(postTask.getString("taskstatus")) || validatePreTaskAllFinish) continue;
            postTask.set("taskstatus", (Object)"A");
            postTask.set("taskbegintime", null);
            statusChangeTasks.add((Object)postTask);
            if (null == itemId) {
                InitTaskServiceHelper.buildInfo(postTask, infoList, Boolean.FALSE);
                continue;
            }
            if (null != itemId && itemId.longValue() == postTask.getDynamicObject("implitemrel").getLong("id")) continue;
            InitTaskServiceHelper.buildNoPassInfo(postTask, infoList);
        }
        if (!CollectionUtils.isEmpty((Collection)statusChangeTasks)) {
            serviceHelper.update(tasks);
        }
        if (!CollectionUtils.isEmpty(infoList)) {
            MessageSendServiceHelper.saveMessage(infoList);
        }
    }

    private static void buildNoPassInfo(DynamicObject postTask, List<InitMessageInfo> infoList) {
        InitMessageInfo info = MessageSendServiceHelper.buildTaskMessage(postTask, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u63d0\u9192\uff1a\u4efb\u52a1\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\uff01", (String)"InitTaskServiceHelper_2", (String)"hrmp-hric-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb!", (String)"InitTaskServiceHelper_3", (String)"hrmp-hric-business", (Object[])new Object[0]), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u8d1f\u8d23\u7684%s\u72b6\u6001\u5df2\u66f4\u65b0\u4e3a\u201c\u7b49\u5f85\u4e2d\u201d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"InitTaskServiceHelper_1", (String)"hrmp-hric-business", (Object[])new Object[0]), postTask.getString("name")));
        infoList.add(info);
    }

    private static void buildInfo(DynamicObject postTask, List<InitMessageInfo> infoList, boolean isFinish) {
        String content = "";
        content = isFinish ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u8d1f\u8d23\u7684%s\u72b6\u6001\u5df2\u66f4\u65b0\u4e3a\u201c\u5904\u7406\u4e2d\u201d\uff0c\u8bf7\u524d\u5f80\u5904\u7406\u3002", (String)"InitTaskServiceHelper_0", (String)"hrmp-hric-business", (Object[])new Object[0]), postTask.getString("name")) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u8d1f\u8d23\u7684%s\u72b6\u6001\u5df2\u66f4\u65b0\u4e3a\u201c\u7b49\u5f85\u4e2d\u201d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"InitTaskServiceHelper_1", (String)"hrmp-hric-business", (Object[])new Object[0]), postTask.getString("name"));
        InitMessageInfo info = MessageSendServiceHelper.buildTaskMessage(postTask, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u63d0\u9192\uff1a\u4efb\u52a1\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\uff01", (String)"InitTaskServiceHelper_2", (String)"hrmp-hric-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb!", (String)"InitTaskServiceHelper_3", (String)"hrmp-hric-business", (Object[])new Object[0]), content);
        infoList.add(info);
    }

    private static boolean validatePreTaskAllFinish(DynamicObject task) {
        DynamicObjectCollection preTasks = task.getDynamicObjectCollection("pretask");
        for (DynamicObject preTask : preTasks) {
            DynamicObject dynamicObject = preTask.getDynamicObject("fbasedataid");
            if ("C".equals(dynamicObject.getString("taskstatus")) || "D".equals(dynamicObject.getString("taskstatus"))) continue;
            return false;
        }
        return true;
    }

    public static void dealPreTask(DynamicObject dyc) {
        String taskStatus = dyc.getString("taskstatus");
        String taskType = dyc.getString("tasktype");
        DynamicObjectCollection preTasks = dyc.getDynamicObjectCollection("pretask");
        if (HRStringUtils.equals((String)taskType, (String)"B")) {
            if (HRStringUtils.equals((String)taskStatus, (String)"A")) {
                InitTaskServiceHelper.dealPreTask(taskStatus, preTasks);
            } else if (HRStringUtils.equals((String)taskStatus, (String)"E")) {
                InitTaskServiceHelper.dealPreTask(taskStatus, preTasks);
            } else {
                dyc.set("pretask", null);
            }
        } else if (HRStringUtils.equals((String)taskType, (String)"C")) {
            if (HRStringUtils.equals((String)taskStatus, (String)"A")) {
                InitTaskServiceHelper.dealPreTask(taskStatus, preTasks);
            } else {
                dyc.set("pretask", null);
            }
        }
    }

    private static void dealPreTask(String taskStatus, DynamicObjectCollection preTasks) {
        if (CollectionUtils.isEmpty((Collection)preTasks)) {
            return;
        }
        ListIterator iter = preTasks.listIterator();
        while (iter.hasNext()) {
            DynamicObject dyc = (DynamicObject)((DynamicObject)iter.next()).get(1);
            String preTaskStatus = dyc.getString("taskstatus");
            if (HRStringUtils.equals((String)taskStatus, (String)"A")) {
                if (!HRStringUtils.equals((String)preTaskStatus, (String)"C")) continue;
                iter.remove();
                continue;
            }
            if (HRStringUtils.equals((String)preTaskStatus, (String)"F") || HRStringUtils.equals((String)preTaskStatus, (String)"E")) continue;
            iter.remove();
        }
    }

    public static boolean existTask(long taskId, String status) {
        if (taskId == 0L) {
            return false;
        }
        QFilter idEqQFilter = new QFilter("id", "=", (Object)taskId);
        QFilter statusQfilter = new QFilter("taskstatus", "=", (Object)status);
        return serviceHelper.isExists(idEqQFilter.and(statusQfilter));
    }

    private static boolean existExecPostTask(List<DynamicObject> postTasks) {
        boolean isExist = false;
        if (!CollectionUtils.isEmpty(postTasks)) {
            for (DynamicObject task : postTasks) {
                if (!HRStringUtils.equals((String)task.getString("tasktype"), (String)"B")) continue;
                isExist = true;
            }
        }
        return isExist;
    }

    public static List<DynamicObject> getPostTaskListByPlan(DynamicObject[] taskList) {
        DynamicObject plan = taskList[0].getDynamicObject("belongplan");
        String structNumber = plan.getString("structnumber");
        if (HRStringUtils.isEmpty((String)structNumber)) {
            return null;
        }
        String globalStructNumber = structNumber.split("!")[0];
        DynamicObject[] sonPlans = InitPlanServiceHelper.getAllSonPlans(globalStructNumber);
        List<Long> planIds = Arrays.stream(sonPlans).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        DynamicObject[] allTasks = InitTaskServiceHelper.getExecAndVerifyTaskByPlanIds("id,pretask,taskstatus", planIds);
        Map<Long, List<DynamicObject>> postTaskMap = InitTaskServiceHelper.getPostTaskMap(allTasks);
        List<DynamicObject> postTasks = InitTaskServiceHelper.getDistinctTaskList(taskList, postTaskMap);
        return postTasks;
    }

    public static Map<Long, List<DynamicObject>> getPostTaskMap(DynamicObject[] tasks) {
        HashMap postTaskMap = Maps.newHashMap();
        Arrays.stream(tasks).forEach(dyn -> {
            DynamicObjectCollection preTasks = dyn.getDynamicObjectCollection("pretask");
            if (!CollectionUtils.isEmpty((Collection)preTasks)) {
                preTasks.forEach(task -> {
                    postTaskMap.computeIfAbsent(task.getLong("fbasedataid_id"), k -> new ArrayList());
                    ((List)postTaskMap.get(task.getLong("fbasedataid_id"))).add(dyn);
                });
            }
        });
        return postTaskMap;
    }

    public static String getAfterStatus(DynamicObject task, List<Long> rollBackTaskIdList, Map<Long, List<DynamicObject>> postMap) {
        String taskType = task.getString("tasktype");
        String afterStatus = task.getString("taskstatus");
        if (HRStringUtils.equals((String)taskType, (String)"C")) {
            return "A";
        }
        if (HRStringUtils.equals((String)taskType, (String)"B")) {
            List<DynamicObject> postTasks = postMap.get(task.getLong("id"));
            if (InitTaskServiceHelper.existExecPostTask(postTasks)) {
                afterStatus = "E";
            } else {
                afterStatus = "F";
                if (!InitTaskServiceHelper.isPreTaskNeedRollback(task, rollBackTaskIdList)) {
                    afterStatus = "B";
                }
            }
            return afterStatus;
        }
        return "";
    }

    private static boolean isPreTaskNeedRollback(DynamicObject task, List<Long> rollBackTaskIdList) {
        DynamicObjectCollection preTasks = task.getDynamicObjectCollection("pretask");
        boolean preTaskNeedRollback = false;
        for (DynamicObject preTask : preTasks) {
            if (!rollBackTaskIdList.contains(preTask.getLong("fbasedataid_id"))) continue;
            preTaskNeedRollback = true;
            break;
        }
        return preTaskNeedRollback;
    }

    private static List<DynamicObject> getDistinctTaskList(DynamicObject[] taskList, Map<Long, List<DynamicObject>> postTaskMap) {
        ArrayList<DynamicObject> postTasks = new ArrayList<DynamicObject>();
        HashSet idSet = new HashSet();
        Arrays.stream(taskList).forEach(task -> {
            if (!idSet.contains(task.getLong("id"))) {
                postTasks.add((DynamicObject)task);
                idSet.add(task.getLong("id"));
                List<DynamicObject> postTaskList = InitTaskServiceHelper.getPostTasks(postTaskMap, task);
                postTaskList.stream().forEach(ppostTask -> {
                    if (!idSet.contains(ppostTask.getLong("id"))) {
                        postTasks.add((DynamicObject)ppostTask);
                        idSet.add(ppostTask.getLong("id"));
                    }
                });
            }
        });
        return postTasks;
    }

    private static List<DynamicObject> getPostTasks(Map<Long, List<DynamicObject>> postTaskMap, DynamicObject task) {
        ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>();
        List<DynamicObject> postTasks = postTaskMap.get(task.getLong("id"));
        if (CollectionUtils.isEmpty(postTasks)) {
            return tasks;
        }
        postTasks.forEach(postTask -> {
            tasks.add((DynamicObject)postTask);
            List<DynamicObject> ppostTasks = InitTaskServiceHelper.getPostTasks(postTaskMap, postTask);
            if (!CollectionUtils.isEmpty(ppostTasks)) {
                tasks.addAll(ppostTasks);
            }
        });
        return tasks;
    }

    public static void saveRollbackTasks(DynamicObject[] tasks) {
        serviceHelper.save(tasks);
        InitPlanServiceHelper.batchUpdateParentPlanStatusNegative(tasks);
    }

    public static DynamicObject getTotalPlanForTask(DynamicObject task) {
        Long planId = task.get("belongplan") instanceof DynamicObject ? task.getDynamicObject("belongplan").getLong("id") : task.getLong("belongplan");
        DynamicObject plan = InitPlanServiceHelper.getPlansById(planId);
        String structNumber = plan.getString("structnumber");
        int index = structNumber.indexOf(33);
        if (index > 0) {
            structNumber = structNumber.substring(0, index);
        }
        return InitPlanServiceHelper.getPlanByStructNumber(structNumber);
    }

    public static void saveInitTasks(DynamicObject[] tasks) {
        if (ObjectUtils.isEmpty((Object[])tasks)) {
            return;
        }
        serviceHelper.save(tasks);
    }

    public static DynamicObject[] getInitTaskByBelongPlanIds(List<Long> implItemPlanIds) {
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(new QFilter("belongplan", "in", implItemPlanIds).and(new QFilter("tasktype", "!=", (Object)"A")).and(TOBEGENERATE_STATUS_QFILTER).and(PARENT_TASK_QFILTER).toArray());
        if (Objects.isNull(dys)) {
            return new DynamicObject[0];
        }
        return dys;
    }

    private static List<DLock> createDLockList(DynamicObject[] tasks) {
        if (HRArrayUtils.isEmpty((Object[])tasks)) {
            return new ArrayList<DLock>(0);
        }
        ArrayList<DLock> dLocks = new ArrayList<DLock>(tasks.length);
        Arrays.stream(tasks).forEach(dyn -> dLocks.add(DLock.create((String)("task_processing_lock" + dyn.getLong("id")))));
        return dLocks;
    }

    public static void setTaskLock(DynamicObject[] tasks, HRICErrorEnum errorEnum, NoParamConsumer noParamConsumer) {
        List<DLock> dLockList = InitTaskServiceHelper.createDLockList(tasks);
        try {
            for (int i = 0; i < dLockList.size(); ++i) {
                if (dLockList.get(i).tryLock()) continue;
                throw new KDHricException(HRICErrorEnum.TASK_IN_PROCESSING_ERROR, new Object[]{tasks[i].getString("name")});
            }
            noParamConsumer.accept();
        }
        catch (KDHricException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KDHricException((Throwable)ex, errorEnum, new Object[0]);
        }
        finally {
            dLockList.forEach(dLock -> {
                try {
                    dLock.close();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            });
        }
    }

    public static List<DynamicObject> getToBeGenerateInitTasks(Long id) {
        QFilter statusQFilter = new QFilter("taskstatus", "=", (Object)"Z");
        Object[] dys = serviceHelper.query("id,name,implitemrel,taskstatus", new QFilter("belongplan", "=", (Object)id).and(statusQFilter).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.transferArrayToList((Object[])dys);
    }

    public static void batchDelTask(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        QFilter idQFilter = new QFilter("id", "in", ids);
        serviceHelper.deleteByFilter(idQFilter.toArray());
    }

    public static DynamicObject[] getTaskCountByImplItems(List<Long> ids) {
        return serviceHelper.query("taskstatus,parent", new QFilter("implitemrel", "in", ids).and("tasktype", "=", (Object)"B").toArray());
    }
}

