/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.AttachmentCountProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;
import org.apache.commons.lang3.ObjectUtils;

public class InitTemplateServiceHelper {
    private static final Log LOG = LogFactory.getLog(InitTemplateServiceHelper.class);
    private static final List<String> REPLACE_LIST = ImmutableList.of((Object)"ismustinput", (Object)"isimport", (Object)"entitydescription");
    private String RES_BILLHEAD_NAME = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"InitTemplateServiceHelper_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String RES_BILLBODY_NAME = ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"InitTemplateServiceHelper_12", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String RES_ID_NAME = ResManager.loadKDString((String)"\u5185\u7801", (String)"InitTemplateServiceHelper_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String RES_PARENT_ID_NAME = ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"InitTemplateServiceHelper_8", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private Map<String, String> dataRangeMap = new HashMap<String, String>();
    private Map<String, Integer[]> entityIndexMapping = new HashMap<String, Integer[]>();
    private Map<String, Integer> numberMap = new HashMap<String, Integer>();
    private final String TREE_ENTRY_ENTITY = "treeentryentity";
    private List<DynamicObject> dynamicObjectList;
    private DynamicObjectType dynamicObjectType;
    private String page;
    private String pageEntry;
    private Map<String, DynamicObject> treeEntryMap;
    private DynamicObject initTemplate;
    private Map<String, DynamicObject> importPlateFormMap = Maps.newHashMap();
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hric_initinducttp");

    public InitTemplateServiceHelper() {
    }

    public InitTemplateServiceHelper(List<DynamicObject> dynamicObjectList, DynamicObjectType dynamicObjectType, String page, String pageEntry) {
        this.dynamicObjectList = dynamicObjectList;
        this.dynamicObjectType = dynamicObjectType;
        this.page = page;
        this.pageEntry = pageEntry;
    }

    public void generateInitImportTemplate(DynamicObject initDy) {
        Long id = this.buildImportTemplateInfo(initDy);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hric_initinducttp");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne("importtemplateid", (Object)initDy.getLong("id"));
        dynamicObject.set("importtemplateid", (Object)id);
        hrBaseServiceHelper.saveOne(dynamicObject);
        LOG.info("generate init import template end, id: {}", (Object)id);
    }

    public static boolean isInDb(String key, String value, Long pkId, String enableStatus) {
        QFilter qFilter = new QFilter(key, "=", (Object)value);
        if (null != enableStatus) {
            qFilter.and(new QFilter("enable", "=", (Object)enableStatus));
        }
        if (null != pkId && 0L != pkId) {
            qFilter.and(new QFilter("id", "!=", (Object)pkId));
        }
        return serviceHelper.isExists(qFilter);
    }

    public static DynamicObject[] getDataByAppScopeNumber(String number) {
        QFilter qFilter = new QFilter("entityobjscope", "=", (Object)number);
        qFilter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        return serviceHelper.query("intermediatetable", new QFilter[]{qFilter});
    }

    public static DynamicObject getInitTemplateByMidNumber(String midNumber) {
        return InitTemplateServiceHelper.getInitTemplateByMidNumber(HricDynamicObjectUtils.getFieldByPage((String)"hric_initinducttp"), midNumber);
    }

    public static DynamicObject getInitTemplateByMidNumber(String selectProperties, String midNumber) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"hric_initinducttp", (String)selectProperties, (QFilter[])InitTemplateServiceHelper.getMidNumberFilter(midNumber).toArray());
    }

    public static DynamicObject getInitTemplateByTemplateID(Long templateID) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)templateID, (String)"hric_initinducttp", (String)HricDynamicObjectUtils.getFieldByPage((String)"hric_initinducttp"));
    }

    public static void downloadTempExcel(String interMediateTable, IFormView view) {
        DynamicObject templateDy = serviceHelper.queryOne("intermediatetable,importtemplateid", InitTemplateServiceHelper.getMidNumberFilter(interMediateTable).toArray());
        if (Objects.isNull(templateDy)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u521d\u59cb\u5316\u5bfc\u5165\u6a21\u7248\u3002", (String)"InitTemplateServiceHelper_9", (String)"hrmp-hric-business", (Object[])new Object[0]));
            return;
        }
        InitTemplateServiceHelper.downloadTempExcel(templateDy, view);
    }

    private static QFilter getMidNumberFilter(String interMediateTable) {
        return new QFilter("intermediatetable", "=", (Object)interMediateTable);
    }

    public static void downloadTempExcel(DynamicObject initTempObj, IFormView view) {
        String midFormId = initTempObj.getString("intermediatetable");
        if (kd.bos.orm.util.StringUtils.isEmpty((Object)midFormId)) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f13\u5b58\u8868\u7f16\u7801\u3002", (String)"InitTemplateServiceHelper_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
            return;
        }
        if (!MetadataDao.checkNumber((String)midFormId)) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u7f13\u5b58\u8868\uff0c\u7136\u540e\u4e0b\u8f7d\u6a21\u677f\u3002", (String)"InitTemplateServiceHelper_1", (String)"hrmp-hric-business", (Object[])new Object[0]));
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)midFormId);
        long tId = initTempObj.getLong("importtemplateid");
        if (mainEntityType == null) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u7f13\u5b58\u8868\uff0c\u7136\u540e\u4e0b\u8f7d\u6a21\u677f\u3002", (String)"InitTemplateServiceHelper_1", (String)"hrmp-hric-business", (Object[])new Object[0]));
            return;
        }
        if (tId <= 0L) {
            view.showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f\u540e\uff0c\u8bf7\u4e0b\u8f7d\u3002", (String)"InitTemplateServiceHelper_2", (String)"hrmp-hric-business", (Object[])new Object[0]));
            return;
        }
        InitTemplateServiceHelper.checkIsImportForSourceSys(midFormId);
        try {
            view.download(InitTemplateServiceHelper.buildDownloadUrl(midFormId, tId, initTempObj, mainEntityType, view.getFormShowParameter().getServiceAppId()));
            view.sendFormAction(view);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f", (String)"InitTemplateServiceHelper_10", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            LOG.error("download fail", (Throwable)ex);
            view.showMessage(ResManager.loadKDString((String)"\u4e0b\u8f7d\u521d\u59cb\u5316\u6a21\u677f\u5931\u8d25\u3002\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitTemplateServiceHelper_3", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
    }

    private static void checkIsImportForSourceSys(String midFormId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("bos_importtemplate");
        Object[] importTmps = hrBaseServiceHelper.query("treeentryentity.entitynumber,treeentryentity.isimport,treeentryentity.entitydescription", new QFilter("bizobject", "=", (Object)midFormId).toArray(), "modifytime desc");
        if (HRArrayUtils.isEmpty((Object[])importTmps)) {
            return;
        }
        Object importTmp = importTmps[0];
        boolean sign = false;
        DynamicObjectCollection treeentryentity = importTmp.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject it : treeentryentity) {
            if (!HRStringUtils.equals((String)it.getString("entitynumber"), (String)"hricsourcesys") && !HRStringUtils.equals((String)it.getString("entitynumber"), (String)"hricsourcesyskey") || it.getBoolean("isimport") && !HRStringUtils.isEmpty((String)it.getString("entitydescription"))) continue;
            sign = true;
            it.set("isimport", (Object)true);
            it.set("entitydescription", (Object)ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u3002\u7f13\u5b58\u8868\u6570\u636e\u96c6\u6210\u6765\u6e90\u7cfb\u7edf\u573a\u666f\uff0c\u8bf7\u586b\u5199\u3002", (String)"InitTemplateServiceHelper_12", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        if (sign) {
            hrBaseServiceHelper.saveOne((DynamicObject)importTmp);
        }
    }

    private static String buildDownloadUrl(String midFormId, long tId, DynamicObject initTempObj, MainEntityType mainEntityType, String appId) throws Exception {
        String fileName = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)"InitTemplateServiceHelper_4", (String)"hrmp-hric-business", (Object[])new Object[0]);
        fileName = initTempObj != null ? fileName + initTempObj.get("name") : fileName + mainEntityType.getDisplayName();
        fileName = fileName.replaceAll(" ", "_");
        String ctxPath = RequestContext.get().getClientFullContextPath();
        StringBuilder urlBuilder = new StringBuilder(ctxPath);
        urlBuilder.append(ctxPath.endsWith("/") ? "" : "/").append("form/export.do?templateid=").append(tId).append("&formid=").append(midFormId).append("&filename=").append(URLEncoder.encode(fileName, "UTF-8")).append('_').append(HRDateTimeUtils.format((Date)new Date(), (String)"MMdd")).append(".xlsx").append("&extenddata=&routeappid=").append(appId).append("&a=t");
        return urlBuilder.toString();
    }

    public static DynamicObject[] getTemplateListByAppScope(String number) {
        QFilter qFilter = new QFilter("entityobjscope", "=", (Object)number);
        qFilter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        return serviceHelper.query(qFilter.toArray());
    }

    public Long buildImportTemplateInfo(DynamicObject initTemplate) {
        this.initTemplate = initTemplate;
        String entityId = initTemplate.getString("intermediatetable");
        DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"bos_importtemplate");
        this.initTemplateData(data);
        this.buildBillTreeFieldsExt(entityId, this.getTreeEntryMap(initTemplate));
        this.buildPlateFormMap();
        this.addBasedataNameProp();
        this.resetOrder(initTemplate);
        this.buildForImportPlateForm(data, entityId);
        return this.dealTemplateData(data, initTemplate);
    }

    private void buildPlateFormMap() {
        this.buildPlateFormMap(this.getDynamicObjectList());
    }

    private void addBasedataNameProp() {
        List<String> basedataAliasList = this.initTemplate.getDynamicObjectCollection("treeentryentity").stream().filter(it -> "number".equals(it.getString("importprop"))).map(it -> it.getString("numberalias")).collect(Collectors.toList());
        basedataAliasList.forEach(initTemplateEntryAlias -> {
            if (this.importPlateFormMap.containsKey(this.getBasedataPropNameKey((String)initTemplateEntryAlias))) {
                DynamicObject plateTemplateEntryRow = this.importPlateFormMap.get(this.getBasedataPropNameKey((String)initTemplateEntryAlias));
                plateTemplateEntryRow.set("isimport", (Object)true);
            }
        });
    }

    private String getBasedataPropNameKey(String numberAlias) {
        return numberAlias + "a";
    }

    private void resetOrder(DynamicObject initTemplate) {
        this.dynamicObjectList = this.resetOrder(initTemplate.getDynamicObjectCollection("treeentryentity"));
        for (int index = 0; index < this.dynamicObjectList.size(); ++index) {
            this.dynamicObjectList.get(index).set("seq", (Object)(index + 1));
        }
    }

    public List<DynamicObject> resetOrder(DynamicObjectCollection oldCollection) {
        List<DynamicObject> collect = oldCollection.stream().filter(dyc -> this.filterTableHead((DynamicObject)dyc) == false).collect(Collectors.toList());
        ArrayList orderList = new ArrayList();
        ArrayList<DynamicObject> orderLastList = new ArrayList<DynamicObject>();
        collect.forEach(dyc -> {
            String key = this.getTemplateFieldKey((DynamicObject)dyc);
            if (this.importPlateFormMap.containsKey(key)) {
                orderList.add(this.importPlateFormMap.get(key));
                DynamicObject plateEntryRow = this.importPlateFormMap.get(key);
                if (plateEntryRow.getBoolean("isimport") && "number".equals(dyc.getString("importprop"))) {
                    this.addBasedataNameProp(orderList, (DynamicObject)dyc);
                }
                this.importPlateFormMap.remove(key);
            }
        });
        int number = 0;
        for (int i = 0; i < this.getDynamicObjectList().size(); ++i) {
            DynamicObject dyc2 = this.getDynamicObjectList().get(i);
            if (this.filterTableHead(dyc2).booleanValue()) {
                orderLastList.add(dyc2);
                continue;
            }
            if (this.importPlateFormMap.containsKey(this.getTemplateFieldKey(dyc2))) continue;
            orderLastList.add((DynamicObject)orderList.get(number++));
        }
        this.importPlateFormMap.forEach((key, value) -> {
            if (HRStringUtils.equals((String)key, (String)"hricsourcesys") || HRStringUtils.equals((String)key, (String)"hricsourcesyskey")) {
                value.set("isimport", (Object)true);
            }
            orderLastList.add((DynamicObject)value);
        });
        return orderLastList;
    }

    private String getTemplateFieldKey(DynamicObject dyc) {
        if (!dyc.containsProperty("numberalias")) {
            return dyc.getString("entitynumber");
        }
        String key = dyc.getString("numberalias");
        if (dyc.getBoolean("istablehead")) {
            key = dyc.getString("entitynumber");
        }
        return key;
    }

    public void buildPlateFormMap(List<DynamicObject> dys) {
        DynamicObject dynamicObject = dys.get(0);
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"numberalias")) {
            dys.stream().filter(dyc -> this.filterTableHead((DynamicObject)dyc) == false).forEach(dyc -> {
                String numberAlias = dyc.getString("numberalias");
                if (HRStringUtils.isNotEmpty((String)numberAlias)) {
                    this.importPlateFormMap.put(numberAlias, (DynamicObject)dyc);
                } else {
                    this.importPlateFormMap.put(dyc.getString("entitynumber"), (DynamicObject)dyc);
                }
            });
        } else {
            this.importPlateFormMap = this.dynamicObjectList.stream().filter(dyc -> this.filterTableHead((DynamicObject)dyc) == false).collect(Collectors.toMap(it -> it.getString("entitynumber"), Function.identity(), (oldValue, newValude) -> oldValue));
        }
    }

    private void addBasedataNameProp(List<DynamicObject> orderList, DynamicObject dyc) {
        DynamicObject plateEntryRowBasedataName = this.importPlateFormMap.get(this.getBasedataPropNameKey(dyc.getString("numberalias")));
        if (Objects.nonNull(plateEntryRowBasedataName)) {
            orderList.add(plateEntryRowBasedataName);
            this.importPlateFormMap.remove(this.getBasedataPropNameKey(dyc.getString("numberalias")));
        }
    }

    private Boolean filterTableHead(DynamicObject dyc) {
        return dyc.getLong("pid") == 0L || "billhead".equals(dyc.getString("entitynumber"));
    }

    private Map<String, DynamicObject> getTreeEntryMap(DynamicObject initTemplate) {
        DynamicObjectCollection treeEntry = initTemplate.getDynamicObjectCollection("treeentryentity");
        if (treeEntry == null) {
            return null;
        }
        return treeEntry.stream().collect(Collectors.toMap(it -> it.getString("numberalias"), Function.identity(), (oldValue, newValude) -> oldValue));
    }

    private Long dealTemplateData(DynamicObject data, DynamicObject initTemplate) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("bos_importtemplate");
        long importTemplateId = initTemplate.getLong("importtemplateid");
        if (importTemplateId > 0L) {
            hrBaseServiceHelper.deleteOne((Object)importTemplateId);
        }
        data.set("id", (Object)importTemplateId);
        DynamicObject dyc = (DynamicObject)hrBaseServiceHelper.saveOne(data);
        return dyc.getLong("id");
    }

    private void initTemplateData(DynamicObject data) {
        DynamicObjectCollection treeEntryEntity = data.getDynamicObjectCollection("treeentryentity");
        this.dynamicObjectType = treeEntryEntity.getDynamicObjectType();
        this.dynamicObjectList = new ArrayList<DynamicObject>();
        this.pageEntry = "T_BAS_IMPORTTEMPLATEENTRY";
        this.page = "bos_importtemplate";
    }

    private void buildForImportPlateForm(DynamicObject dynamicObject, String entityId) {
        dynamicObject.set("templatetype", (Object)"IMPT");
        dynamicObject.set("bizobject", (Object)entityId);
        dynamicObject.set("name", (Object)entityId);
        dynamicObject.set("number", (Object)this.setDefaultNumber(entityId));
        dynamicObject.set("comment", (Object)ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5bfc\u5165\u6a21\u677f\u751f\u6210\u7684\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f\uff0c\u4e0d\u53ef\u4fee\u6539\u3002", (String)"InitTemplateServiceHelper_11", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        dynamicObject.set("applyscope", (Object)0);
        dynamicObject.set("enable", (Object)1);
        dynamicObject.set("treeentryentity", (Object)new DynamicObjectCollection(this.dynamicObjectType, null, this.getDynamicObjectList()));
    }

    private String setDefaultNumber(String entityId) {
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            return "kingdee".equals(ISVService.getISVInfo().getId()) ? entityId + "_IMPL_S" : entityId + "_IMPL";
        }
        return "";
    }

    public void buildBillTreeFieldsExt(String number, Map<String, DynamicObject> treeEntryMap) {
        this.treeEntryMap = treeEntryMap;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        ArrayList<MainEntityType> entityTypes = new ArrayList<MainEntityType>();
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            entityTypes.add(queryType.getMainEntityType());
            entityTypes.addAll(queryType.getAllJoinEntityType());
        } else {
            entityTypes.add(mainType);
        }
        for (MainEntityType mainEntityType : entityTypes) {
            this.buildFldTreeRowExt(mainEntityType);
        }
    }

    private void buildFldTreeRowExt(MainEntityType mainType) {
        List<EntityItem<?>> newItems = InitTemplateServiceHelper.filterEntityItems(mainType);
        List<ControlAp<?>> aps = this.getFormMetadata(mainType.getName());
        Integer[] pRow = new Integer[]{this.dynamicObjectList.size() - 1 <= 0 ? 0 : this.dynamicObjectList.size(), null};
        DynamicObject dyc = new DynamicObject(this.dynamicObjectType);
        dyc.set("id", (Object)DBServiceHelper.genLongIds((String)this.pageEntry, (int)1)[0]);
        this.dynamicObjectList.add(dyc);
        this.entityIndexMapping.put(mainType.getName(), pRow);
        this.fillPartialFieldsInfo(mainType.getDisplayName().getLocaleValue_zh_CN(), mainType.getName(), pRow[0]);
        this.buildEntryTreeRow(mainType, newItems, aps, pRow);
        if (HRStringUtils.equals((String)"hric_initinducttp", (String)this.page)) {
            this.resetNumberAlias();
        }
    }

    private void resetNumberAlias() {
        HashMap map = new HashMap();
        this.getDynamicObjectList().forEach(dynamicObject -> {
            String number;
            if (!dynamicObject.getBoolean("istablehead") && this.numberMap.get(number = dynamicObject.getString("entitynumber")) != null && this.numberMap.get(number) != 1) {
                map.merge(number, 1, Integer::sum);
                dynamicObject.set("numberalias", (Object)(number + map.get(number)));
            }
        });
    }

    private void buildEntryTreeRow(MainEntityType mainType, List<EntityItem<?>> newItems, List<ControlAp<?>> aps, Integer[] pRow) {
        boolean isAllCheck = true;
        int row = -1;
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            IDataEntityType parentType;
            EntityType entityType = (EntityType)entry.getValue();
            if (entityType instanceof LinkEntryType) continue;
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            if (entityType instanceof MainEntityType) {
                entityNodeName = this.RES_BILLHEAD_NAME;
                entityNodeId = "billhead";
            }
            pRow = this.entityIndexMapping.get((parentType = entityType.getParent()) != null ? parentType.getName() : entityType.getName());
            if (row < 0) {
                DynamicObject dynamicObject = this.dynamicObjectList.get(pRow[0]);
                DynamicObject subDynamicObject = new DynamicObject(this.dynamicObjectType);
                subDynamicObject.set("id", (Object)DBServiceHelper.genLongIds((String)this.pageEntry, (int)1)[0]);
                subDynamicObject.set("pid", dynamicObject.get("id"));
                this.dynamicObjectList.add(subDynamicObject);
                row = this.dynamicObjectList.size() - 1;
            }
            List<IDataEntityProperty> properties = entityType.getFields().values().stream().filter(prop -> entityType instanceof QueryEntityType && !(prop instanceof JoinProperty) || this.isPropertyImport(newItems, (IDataEntityProperty)prop)).collect(Collectors.toList());
            this.getSortProperties(properties, aps, entityType);
            if (properties.isEmpty()) continue;
            isAllCheck = this.buildEntryFieldTreeRow(row, (String)entry.getKey(), entityNodeId, entityNodeName, properties);
            row = -1;
        }
        if (row > 0) {
            this.dynamicObjectList.remove(row);
        }
        if (isAllCheck) {
            this.dynamicObjectList.get(pRow[0]).set("ismustinput", (Object)Boolean.TRUE);
            this.dynamicObjectList.get(pRow[0]).set("isimport", (Object)Boolean.TRUE);
        }
    }

    private boolean buildEntryFieldTreeRow(int row, String entryKey, String entityNodeId, String entityNodeName, List<IDataEntityProperty> properties) {
        boolean isAllChildrenCheck = true;
        int[] rows = null;
        if (CollectionUtils.isEmpty((Collection)properties.stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
            isAllChildrenCheck = false;
        } else {
            int i;
            rows = new int[properties.size()];
            for (i = 0; i < properties.size(); ++i) {
                DynamicObject dyc = new DynamicObject(this.dynamicObjectType);
                dyc.set("id", (Object)DBServiceHelper.genLongIds((String)this.pageEntry, (int)1)[0]);
                dyc.set("pid", this.dynamicObjectList.get(row).get("id"));
                this.dynamicObjectList.add(dyc);
                rows[i] = this.dynamicObjectList.size() - 1;
            }
            i = 0;
            for (IDataEntityProperty property : properties) {
                if (!this.BuildFldTreeNode(property, rows[i], this.dynamicObjectList, this.page)) {
                    isAllChildrenCheck = false;
                }
                ++i;
            }
            if (!this.entityIndexMapping.containsKey(entryKey) && !CollectionUtils.isEmpty(Collections.singleton(rows))) {
                this.entityIndexMapping.put(entryKey, new Integer[]{row, rows[rows.length - 1]});
            }
        }
        this.fillPartialFieldsInfo(entityNodeName, entityNodeId, row);
        this.dynamicObjectList.get(row).set("ismustinput", (Object)isAllChildrenCheck);
        this.dynamicObjectList.get(row).set("isimport", (Object)isAllChildrenCheck);
        return isAllChildrenCheck;
    }

    private boolean BuildFldTreeNode(IDataEntityProperty fldProperty, int row, List<DynamicObject> dynamicObjectList, String page) {
        boolean isBaseData;
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (ObjectUtils.isEmpty((Object)prop)) {
            return false;
        }
        String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
        String entityNumber = prop.getName();
        if (prop == prop.getParent().getPrimaryKey()) {
            fldNodeName = this.RES_ID_NAME;
            if (prop.getParent() instanceof EntryType) {
                entityNumber = prop.getParent().getName() + "." + prop.getName();
            }
        } else if (prop.getName().equals("pid") && prop.getParent() instanceof TreeEntryType) {
            fldNodeName = this.RES_PARENT_ID_NAME;
            entityNumber = prop.getParent().getName() + "." + prop.getName();
        }
        if (fldProperty instanceof FieldProp && ((FieldProp)fldProperty).isMustInput() || fldProperty instanceof BasedataProp && ((BasedataProp)fldProperty).isMustInput() || fldProperty instanceof MulBasedataProp && ((MulBasedataProp)fldProperty).isMustInput()) {
            fldNodeName = fldNodeName + "*";
        }
        if (isBaseData = fldProperty instanceof IBasedataField) {
            dynamicObjectList.get(row).set("importprop", (Object)"number");
            dynamicObjectList.get(row).set("isbasedata", (Object)Boolean.TRUE);
        } else {
            dynamicObjectList.get(row).set("importprop", null);
            dynamicObjectList.get(row).set("isbasedata", (Object)Boolean.FALSE);
        }
        dynamicObjectList.get(row).set("entityname", (Object)fldNodeName);
        boolean isMustInput = fldNodeName.endsWith("*");
        if (isMustInput) {
            dynamicObjectList.get(row).set("ismustinput", (Object)Boolean.TRUE);
            dynamicObjectList.get(row).set("isimport", (Object)Boolean.TRUE);
        }
        dynamicObjectList.get(row).set("entitynumber", (Object)entityNumber);
        if (HRStringUtils.equals((String)"hric_initinducttp", (String)page)) {
            this.numberMap.merge(entityNumber, 1, Integer::sum);
            dynamicObjectList.get(row).set("numberalias", (Object)entityNumber);
        }
        dynamicObjectList.get(row).set("isfield", (Object)Boolean.TRUE);
        if (this.treeEntryMap != null) {
            this.fillDataByTreeEntry(dynamicObjectList.get(row));
        }
        return isMustInput;
    }

    private void fillDataByTreeEntry(DynamicObject entryRow) {
        String number = entryRow.getString("entitynumber");
        DynamicObject initTemplateEntryRow = this.treeEntryMap.get(number);
        if (initTemplateEntryRow == null) {
            return;
        }
        REPLACE_LIST.forEach(key -> entryRow.set(key, initTemplateEntryRow.get(key)));
    }

    private void getSortProperties(List<IDataEntityProperty> properties, List<ControlAp<?>> aps, EntityType entityType) {
        int j = 0;
        block0: for (ControlAp<?> ap : aps) {
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty prop = properties.get(i);
                if (ap.getKey().equals(prop.getName())) {
                    Collections.swap(properties, i, j++);
                    continue block0;
                }
                IDataEntityType rootEntityType = prop.getParent();
                while (rootEntityType.getParent() != null) {
                    rootEntityType = rootEntityType.getParent();
                }
                String propFullName = rootEntityType.getName() + "." + prop.getName();
                if (!ap.getKey().equals(this.dataRangeMap.get(propFullName))) continue;
                Collections.swap(properties, i, j++);
            }
        }
        ArrayList<Object> mustInputProps = new ArrayList<Object>();
        ArrayList<IDataEntityProperty> notMustInputProps = new ArrayList<IDataEntityProperty>();
        for (IDataEntityProperty propertie : properties) {
            if (propertie instanceof FieldProp && ((FieldProp)propertie).isMustInput()) {
                mustInputProps.add(propertie);
                continue;
            }
            notMustInputProps.add(propertie);
        }
        mustInputProps.addAll(notMustInputProps);
        properties.clear();
        properties.addAll(mustInputProps);
        if (entityType != null) {
            if (entityType instanceof TreeEntryType) {
                properties.add(0, (IDataEntityProperty)entityType.getProperty("pid"));
            }
            properties.add(0, (IDataEntityProperty)entityType.getPrimaryKey());
        }
    }

    private boolean isPropertyImport(List<EntityItem<?>> newItems, IDataEntityProperty prop) {
        if (prop instanceof AttachmentProp || prop instanceof AttachmentCountProp || "id".equalsIgnoreCase(prop.getName()) || "seq".equalsIgnoreCase(prop.getName())) {
            return false;
        }
        String controlKey = null;
        if (prop instanceof FlexProp) {
            controlKey = ((FlexProp)prop).getBasePropertyKey();
        } else if (prop instanceof ItemClassProp) {
            controlKey = ((ItemClassProp)prop).getTypePropName();
        }
        boolean existControlField = false;
        boolean existProp = false;
        for (EntityItem<?> item : newItems) {
            DateRangeField field;
            if (item instanceof DateRangeField) {
                field = (DateRangeField)item;
                if (field.getStartDateFieldKey().equals(prop.getName()) || field.getEndDateFieldKey().equals(prop.getName())) {
                    this.dataRangeMap.put(prop.getParent().getName() + "." + prop.getName(), field.getKey());
                    existProp = true;
                    break;
                }
            } else if (item instanceof TimeRangeField && ((field = (TimeRangeField)item).getStartDateFieldKey().equals(prop.getName()) || field.getEndDateFieldKey().equals(prop.getName()))) {
                this.dataRangeMap.put(prop.getParent().getName() + "." + prop.getName(), field.getKey());
                existProp = true;
                break;
            }
            if (controlKey != null && controlKey.equals(item.getKey())) {
                existControlField = true;
            }
            if (!prop.getName().equals(item.getKey())) continue;
            existProp = true;
            if (controlKey != null && !existControlField) continue;
            break;
        }
        return existProp && (controlKey == null || existControlField);
    }

    private void fillPartialFieldsInfo(String entityName, String entityNumber, int row) {
        this.dynamicObjectList.get(row).set("entityname", (Object)entityName);
        this.dynamicObjectList.get(row).set("entitynumber", (Object)entityNumber);
        this.dynamicObjectList.get(row).set("isfield", (Object)Boolean.FALSE);
        if (HRStringUtils.equals((String)"hric_initinducttp", (String)this.page)) {
            this.dynamicObjectList.get(row).set("istablehead", (Object)Boolean.TRUE);
        }
    }

    public static List<EntityItem<?>> filterEntityItems(MainEntityType mainType) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        return entityItems.stream().filter(item -> item instanceof Field && ((Field)item).getFeatures().isImportable()).collect(Collectors.toList());
    }

    private List<ControlAp<?>> getFormMetadata(String formId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List aps = formMetadata.getItems();
        Collections.sort(aps, new Comparator<ControlAp<?>>(){

            @Override
            public int compare(ControlAp<?> o1, ControlAp<?> o2) {
                int compareValue = 0;
                compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
                if (compareValue != 0) {
                    return compareValue;
                }
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
        return aps;
    }

    public List<DynamicObject> getDynamicObjectList() {
        return this.dynamicObjectList;
    }

    public static Map<Long, DynamicObject> getTemps(List<Long> ids) {
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(new QFilter("id", "in", ids).toArray());
        if (ObjectUtils.isEmpty((Object)dys)) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(dys).collect(Collectors.toMap(dyc -> dyc.getLong("id"), dyc -> dyc, (k1, k2) -> k1));
    }

    public String getBillHeadResName() {
        return this.RES_BILLHEAD_NAME;
    }

    public String getBillBodyResName() {
        return this.RES_BILLBODY_NAME;
    }
}

