/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.TreeEntryProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.bussiness.service.InitMidTableServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTemplateServiceHelper;
import kd.hrmp.hric.bussiness.service.factory.ThreadPoolFactory;
import kd.hrmp.hric.bussiness.service.task.handle.InitValidateThread;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.bean.TaskInfo;
import kd.hrmp.hric.common.exception.HricDifBizException;
import kd.hrmp.hric.common.util.ControlUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;
import kd.hrmp.hric.common.util.HricObjectUtils;

public class InitValidateServiceHelper {
    private static Log LOG = LogFactory.getLog(InitValidateServiceHelper.class);
    private String entityCode;
    private String midTableNumber;
    private Long taskID;
    private Map<String, IDataEntityProperty> midTableFieldMap = Maps.newHashMap();
    private Set<String> dateFieldSet = Sets.newHashSetWithExpectedSize((int)16);
    private Map<String, IDataEntityProperty> fieldMap = Maps.newHashMap();
    private Map<String, Set<String>> comboFieldMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, String> mustinputFieldMap = Maps.newHashMap();
    private Map<String, Boolean> existFieldMap = Maps.newHashMap();
    private Map<String, String> bdFieldMap = Maps.newHashMap();
    private Set<String> combinedUniqueFieldSet = Sets.newHashSetWithExpectedSize((int)16);
    private Set<String> entryUniqueFieldSet = Sets.newHashSetWithExpectedSize((int)16);
    private Map<String, Set<Long>> repeatIdMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Map<Object, DynamicObject>> baseDataMap = Maps.newConcurrentMap();
    private List<String> ENTRY_FILTER_FIELD = Lists.newArrayList((Object[])new String[]{"id", "seq"});

    public InitValidateServiceHelper(Long taskID, String entityCode, String midTableNumber) {
        this.taskID = taskID;
        this.entityCode = entityCode;
        this.midTableNumber = midTableNumber;
        this.init();
    }

    private final void init() {
        this.buildMidTableFieldMap();
        this.buildFieldMap();
        this.buildComboFieldMap();
        this.initTemplateConfig();
        this.initUniqueVerify();
    }

    private void buildComboFieldMap() {
        for (Map.Entry<String, IDataEntityProperty> midTableFieldEntry : this.midTableFieldMap.entrySet()) {
            if (!(midTableFieldEntry.getValue() instanceof ComboProp)) continue;
            this.comboFieldMap.put(midTableFieldEntry.getKey(), ControlUtils.getComboValueSet((IDataEntityProperty)midTableFieldEntry.getValue()));
        }
    }

    private void initTemplateConfig() {
        DynamicObject templateDyn = InitTemplateServiceHelper.getInitTemplateByMidNumber(this.midTableNumber);
        String entityNumber = templateDyn.getDynamicObject("entityobjscope").getString("number");
        LOG.info(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6821\u9a8c\uff1a\u6b63\u5728\u89e3\u6790\u6a21\u677f\u914d\u7f6e\uff0c\u6a21\u677f\u7f16\u7801\u4e3a{0}", (String)"InitValidateServiceHelper_7", (String)"hrmp-hric-business", (Object[])new Object[]{templateDyn.getString("number"), this.midTableNumber, this.taskID}));
        String uniqueString = templateDyn.getString("uniquestring");
        DynamicObjectCollection templateEntryCol = templateDyn.getDynamicObjectCollection("treeentryentity");
        this.buildFieldConfigMap(templateEntryCol, entityNumber);
        this.buildTmpValidateField(uniqueString);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        if (mainEntityType instanceof QueryEntityType) {
            this.combinedUniqueFieldSet.add(uniqueString.substring(1, uniqueString.length() - 1));
        } else {
            this.buildUniqueFieldsByTpl(uniqueString, templateEntryCol);
        }
    }

    private void buildTmpValidateField(String uniqueString) {
        List uniqueFields = Arrays.stream(uniqueString.split(",")).filter(field -> HRStringUtils.isNotEmpty((String)field)).collect(Collectors.toList());
        for (String field2 : uniqueFields) {
            this.entryUniqueFieldSet.remove(field2);
        }
    }

    private void initUniqueVerify() {
        this.combinedUniqueFieldSet.stream().forEach(uniqueFields -> {
            HashSet repeatIdSet = Sets.newHashSetWithExpectedSize((int)16);
            String[] uniqueFieldArray = uniqueFields.split(",");
            String uniqueFieldInDB = Arrays.stream(uniqueFieldArray).map(field -> this.midTableFieldMap.get(field).getAlias()).collect(Collectors.joining(","));
            Set<String> mulLangFieldInDBSet = Arrays.stream(uniqueFieldArray).filter(midTableField -> this.midTableFieldMap.get(midTableField) instanceof MuliLangTextProp).map(midTableField -> this.midTableFieldMap.get(midTableField).getAlias()).collect(Collectors.toSet());
            Set<String> dateTimeFieldInDBSet = Arrays.stream(uniqueFieldArray).filter(midTableField -> this.midTableFieldMap.get(midTableField) instanceof DateTimeProp).map(midTableField -> this.midTableFieldMap.get(midTableField).getAlias()).collect(Collectors.toSet());
            Set<String> dataFieldInDBSet = Arrays.stream(uniqueFieldArray).filter(midTableField -> this.midTableFieldMap.get(midTableField) instanceof DecimalProp || this.midTableFieldMap.get(midTableField) instanceof LongProp || this.midTableFieldMap.get(midTableField) instanceof TimeProp).map(midTableField -> this.midTableFieldMap.get(midTableField).getAlias()).collect(Collectors.toSet());
            String[] tmpUniques = Arrays.stream(uniqueFieldArray).filter(it -> this.entryUniqueFieldSet.contains(it)).collect(Collectors.toSet()).toArray(new String[0]);
            repeatIdSet.addAll(InitMidTableServiceHelper.queryUniqueFieldGroup(dateTimeFieldInDBSet, dataFieldInDBSet, mulLangFieldInDBSet, uniqueFields, uniqueFieldInDB, this.midTableNumber, this.taskID, this.getUniqueFieldNotEmptyQFilter(tmpUniques), this.dateFieldSet));
            this.repeatIdMap.put((String)uniqueFields, repeatIdSet);
        });
    }

    private QFilter getUniqueFieldNotEmptyQFilter(String[] uniqueFieldArray) {
        QFilter qFilter = null;
        for (String uniqueField : uniqueFieldArray) {
            IDataEntityProperty prop = this.midTableFieldMap.get(uniqueField);
            if (qFilter == null) {
                qFilter = this.getNotEmptyFilter(uniqueField, prop);
                continue;
            }
            qFilter.and(this.getNotEmptyFilter(uniqueField, prop));
        }
        return qFilter;
    }

    private QFilter getNotEmptyFilter(String uniqueField, IDataEntityProperty prop) {
        QFilter qFilter;
        if (prop instanceof TextProp || prop instanceof LargeTextProp || prop instanceof VarcharProp || prop instanceof MuliLangTextProp || prop instanceof ComboProp) {
            qFilter = QFilter.notEqualsContainsEmpty((String)uniqueField, null);
            qFilter.and(new QFilter(uniqueField, "!=", (Object)""));
        } else {
            qFilter = QFilter.isNotNull((String)uniqueField);
        }
        return qFilter;
    }

    public void handleData(Long execTaskId, DynamicObject[] dys) {
        long beginTime = System.currentTimeMillis();
        LOG.info(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6821\u9a8c\uff1a\u5f00\u59cb\u52a0\u8f7d\u57fa\u7840\u8d44\u6599", (String)"InitValidateServiceHelper_3", (String)"hrmp-hric-business", (Object[])new Object[0]));
        LOG.info("InitValidate: bdFieldMap key-value\uff1a {}", this.bdFieldMap);
        this.loadBaseData(dys);
        LOG.info(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6821\u9a8c\uff1a\u5f00\u59cb\u6821\u9a8c\u5fc5\u586b\u548c\u5b58\u5728\u6027\u5fc5\u5f55\u5b57\u6bb5\uff0c\u5fc5\u5f55\u5b57\u6bb5:{0}", (String)"InitValidateServiceHelper_4", (String)"hrmp-hric-business", (Object[])new Object[]{this.mustinputFieldMap.keySet().toString()}));
        LOG.info("InitValidate: existFieldMap key-value\uff1a {}", this.existFieldMap);
        LOG.info("InitValidate: mustInputFieldMap key-value\uff1a {}", this.mustinputFieldMap);
        this.validateBDExists(dys);
        LOG.info(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6821\u9a8c\uff1a\u6821\u9a8c\u7ec4\u5408\u552f\u4e00\u6027\u548c\u5355\u4e2a\u5b57\u6bb5\u552f\u4e00\u6027\u3002", (String)"InitValidateServiceHelper_5", (String)"hrmp-hric-business", (Object[])new Object[0]));
        this.validateUnique(dys);
        LOG.info(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6821\u9a8c\uff1a\u6821\u9a8c\u552f\u4e00\u6027\u7ed3\u675f\u3002\u6821\u9a8c\u4fe1\u606f\u5df2\u843d\u5e93\u3002", (String)"InitValidateServiceHelper_8", (String)"hrmp-hric-business", (Object[])new Object[0]));
        HRBaseServiceHelper saveHelper = new HRBaseServiceHelper(this.midTableNumber);
        saveHelper.save(dys);
        LOG.info(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6821\u9a8c\uff1a\u521d\u59cb\u5316\u6821\u9a8c\u7ebf\u7a0b\uff08\u4e8b\u52a1Id{0}\uff09\u5df2\u7ed3\u675f\uff0c\u5b8c\u6210\u8be5\u6279\u6b21\u521d\u59cb\u5316\u6821\u9a8c\uff0c\u8017\u65f6{1}\u6beb\u79d2\u3002", (String)"InitValidateServiceHelper_6", (String)"hrmp-hric-business", (Object[])new Object[]{execTaskId, System.currentTimeMillis() - beginTime}));
    }

    private void buildFieldConfigMap(DynamicObjectCollection templateEntryCol, String entityNumber) {
        for (DynamicObject entryDyn : templateEntryCol) {
            String fieldName;
            if (!entryDyn.getBoolean("isimport") || entryDyn.getBoolean("istablehead")) continue;
            if (entryDyn.getBoolean("ismustinput")) {
                fieldName = entryDyn.getString("entityname");
                if (entryDyn.getBoolean("isbasedata")) {
                    String entryEntityNumber = entryDyn.getString("entitynumber");
                    BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)this.getRelBaseDataNumber(entityNumber, entryEntityNumber));
                    if (!HricDynamicObjectUtils.entityContainsNumberAndName((BasedataEntityType)dataEntityType)) {
                        String nameProp = null;
                        String importProp = dataEntityType.getNumberProperty();
                        if (HRStringUtils.isEmpty((String)importProp)) {
                            importProp = dataEntityType.getNameProperty();
                        }
                        if (HRStringUtils.isNotEmpty((String)importProp)) {
                            nameProp = dataEntityType.getProperty(importProp).getDisplayName().getLocaleValue();
                        }
                        fieldName = fieldName + "." + nameProp;
                    } else {
                        DynamicObjectType type = new HRBaseServiceHelper("hric_initinducttp").generateEmptyDynamicObject().getDynamicObjectType();
                        fieldName = fieldName + "." + ((ComboProp)((TreeEntryProp)type.getProperty("treeentryentity")).getDynamicCollectionItemPropertyType().getProperty("importprop")).getItemByName(entryDyn.getString("importprop"));
                    }
                }
                this.mustinputFieldMap.put(entryDyn.getString("numberalias"), fieldName);
            }
            if (entryDyn.getBoolean("isbasedata")) {
                String importProp = entryDyn.getString("importprop");
                String fieldName2 = entryDyn.getString("numberalias");
                String entryEntityNumber = entryDyn.getString("entitynumber");
                BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)this.getRelBaseDataNumber(entityNumber, entryEntityNumber));
                if (!HricDynamicObjectUtils.entityContainsNumberAndName((BasedataEntityType)dataEntityType) && HRStringUtils.isEmpty((String)(importProp = dataEntityType.getNumberProperty()))) {
                    importProp = dataEntityType.getNameProperty();
                }
                this.bdFieldMap.put(fieldName2, importProp);
                if (entryDyn.getBoolean("isvalidateexist")) {
                    this.existFieldMap.put(fieldName2, entryDyn.getBoolean("isvalidateexist"));
                }
            }
            if (!entryDyn.getBoolean("isvalidateunique")) continue;
            fieldName = entryDyn.getString("numberalias");
            this.combinedUniqueFieldSet.add(fieldName);
            this.entryUniqueFieldSet.add(fieldName);
        }
    }

    private String getRelBaseDataNumber(String entityNumber, String entryEntityNumber) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        ArrayList baseDataProFieldList = Lists.newArrayList();
        if (dataEntityType instanceof QueryEntityType) {
            List joinEntitys = ((QueryEntityType)dataEntityType).getJoinEntitys();
            ArrayList entityNameList = Lists.newArrayList((Object[])new String[]{((QueryEntityType)dataEntityType).getEntityName()});
            joinEntitys.forEach(entity -> entityNameList.add(entity.getEntityName()));
            for (String entityName : entityNameList) {
                if (!CollectionUtils.isEmpty((Collection)baseDataProFieldList)) continue;
                this.getBaseDataNumber(entityName, entryEntityNumber, baseDataProFieldList);
            }
        } else if (dataEntityType instanceof BasedataEntityType) {
            this.getBaseDataNumber(entityNumber, entryEntityNumber, baseDataProFieldList);
        }
        if (CollectionUtils.isEmpty((Collection)baseDataProFieldList)) {
            throw new HricDifBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\uff1a%1$s\u4e2d\uff0c\u5b57\u6bb5%2$s\u5df2\u66f4\u540d\u3002\u8bf7\u524d\u5f80\u201c\u521d\u59cb\u5316\u5bfc\u5165\u6a21\u677f\u201d\u83dc\u5355\u91cd\u65b0\u751f\u6210\u7f13\u5b58\u8868\u540e\u91cd\u8bd5\u3002", (String)"InitValidateServiceHelper_15", (String)"hrmp-hric-business", (Object[])new Object[0]), entityNumber, entryEntityNumber));
        }
        return HricDynamicObjectUtils.getRelationBasedataNumberByProperty((IDataEntityProperty)((IDataEntityProperty)baseDataProFieldList.get(0)));
    }

    private void getBaseDataNumber(String entityNumber, String entryEntityNumber, List<IDataEntityProperty> baseDataProFieldList) {
        BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        properties.stream().forEach(pro -> {
            if (pro instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)pro).getDynamicCollectionItemPropertyType().getProperties();
                baseDataProFieldList.addAll(entryProperties.stream().filter(entryPro -> HRStringUtils.equals((String)entryPro.getName(), (String)entryEntityNumber)).collect(Collectors.toList()));
                return;
            }
            if (HRStringUtils.equals((String)pro.getName(), (String)entryEntityNumber)) {
                baseDataProFieldList.add((IDataEntityProperty)pro);
            }
        });
    }

    private void buildUniqueFieldsByTpl(String uniqueString, DynamicObjectCollection templateEntryCol) {
        List<Object> uniqueFieldList = Lists.newArrayListWithCapacity((int)16);
        List uniqueFields = Arrays.stream(uniqueString.split(",")).filter(field -> HRStringUtils.isNotEmpty((String)field)).collect(Collectors.toList());
        ArrayList<String> headFieldList = null;
        ArrayList<String> entryFieldList = null;
        if (templateEntryCol == null) {
            return;
        }
        for (DynamicObject entryDyn : templateEntryCol) {
            if (entryDyn == null || HRStringUtils.equals((String)entryDyn.getString("entitynumber"), (String)this.entityCode)) continue;
            if (entryDyn.getBoolean("istablehead")) {
                if (headFieldList == null) {
                    headFieldList = new ArrayList<String>();
                    uniqueFieldList.add(headFieldList);
                    continue;
                }
                if (entryFieldList != null && entryFieldList.size() <= 0) {
                    uniqueFieldList.remove(entryFieldList);
                }
                entryFieldList = new ArrayList<String>();
                entryFieldList.addAll(headFieldList);
                uniqueFieldList.add(entryFieldList);
                continue;
            }
            if (headFieldList != null && entryDyn != null && uniqueFields.contains(entryDyn.getString("numberalias")) && entryFieldList == null) {
                headFieldList.add(entryDyn.getString("numberalias"));
                continue;
            }
            if (entryFieldList == null || entryDyn == null || !uniqueFields.contains(entryDyn.getString("numberalias"))) continue;
            entryFieldList.add(entryDyn.getString("numberalias"));
        }
        if (uniqueFieldList.size() > 1) {
            ArrayList<String> finalHeadFields = headFieldList;
            List tmpList = uniqueFieldList.stream().filter(fields -> fields.size() > finalHeadFields.size()).collect(Collectors.toList());
            uniqueFieldList = CollectionUtils.isEmpty(tmpList) ? uniqueFieldList.subList(0, 1) : tmpList;
        }
        HashSet fieldSet = new HashSet(templateEntryCol.size());
        uniqueFieldList.stream().forEach(it -> it.forEach(str -> fieldSet.add(str)));
        this.combinedUniqueFieldSet.add(fieldSet.stream().collect(Collectors.joining(",")));
    }

    private void buildFieldMap() {
        List<IDataEntityProperty> entryPropList;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityCode);
        this.fieldMap = dataEntityType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, pro -> pro, (value1, value2) -> value2));
        if (dataEntityType instanceof QueryEntityType) {
            List allJoinEntityType = ((QueryEntityType)dataEntityType).getAllJoinEntityType();
            for (MainEntityType mainEntityType : allJoinEntityType) {
                this.fieldMap.putAll(mainEntityType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, pro -> pro, (value1, value2) -> value2)));
            }
        }
        if (CollectionUtils.isEmpty(entryPropList = this.fieldMap.values().stream().filter(pro -> pro instanceof EntryProp).collect(Collectors.toList()))) {
            return;
        }
        entryPropList.forEach(entryProp -> {
            ((EntryProp)entryProp).getDynamicCollectionItemPropertyType().getProperties().stream().filter(pro -> !this.ENTRY_FILTER_FIELD.contains(pro.getName())).forEach(pro -> this.fieldMap.put(pro.getName(), (IDataEntityProperty)pro));
            this.fieldMap.remove(entryProp.getName());
        });
    }

    private void buildMidTableFieldMap() {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.midTableNumber);
        this.midTableFieldMap = dataEntityType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, pro -> pro));
        this.dateFieldSet = dataEntityType.getProperties().stream().filter(it -> it.getPropertyType().getName().equals("java.util.Date")).map(it -> it.getAlias()).collect(Collectors.toSet());
    }

    private void loadBaseData(DynamicObject[] dys) {
        Set<String> bdFieldSet = this.bdFieldMap.keySet();
        String json = Optional.ofNullable(BaseConfigServiceHelper.get("hrpi_filter_field")).orElseGet(() -> "");
        bdFieldSet.forEach(fieldName -> {
            IDataEntityProperty prop = this.fieldMap.get(fieldName);
            HashSet<String> fieldValSet = new HashSet<String>();
            if (prop instanceof BasedataProp) {
                Arrays.stream(dys).map(dyc -> dyc.getString(fieldName)).forEach(fieldVal -> fieldValSet.add((String)fieldVal));
                String entityType = ((BasedataProp)this.fieldMap.get(fieldName)).getBaseEntityId();
                this.baseDataMapSetVal((String)fieldName, fieldValSet, entityType, json);
            } else if (prop instanceof MulBasedataProp) {
                Arrays.stream(dys).map(dyc -> dyc.getString(fieldName)).forEach(fieldVal -> fieldValSet.addAll(new HashSet(Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)fieldVal)))));
                String entityType = ((MulBasedataProp)this.fieldMap.get(fieldName)).getBaseEntityId();
                this.baseDataMapSetVal((String)fieldName, fieldValSet, entityType, json);
            }
        });
    }

    private void baseDataMapSetVal(String fieldName, HashSet<String> fieldValSet, String entityType, String json) {
        String importProp = this.bdFieldMap.get(fieldName);
        if (!this.baseDataMap.containsKey(entityType)) {
            this.baseDataMap.put(entityType, Maps.newConcurrentMap());
        }
        Map<Object, DynamicObject> dycMap = this.baseDataMap.get(entityType);
        List<DynamicObject> dys = InitMidTableServiceHelper.loadBaseDataFromDBByImportProp(entityType, fieldValSet, fieldName, this.entityCode, "id,number,name", importProp, json);
        dys.stream().forEach(dyc -> {
            if (!dycMap.containsKey(dyc.getString(importProp))) {
                dycMap.put(dyc.getString(importProp), (DynamicObject)dyc);
            }
        });
    }

    private void validateUnique(DynamicObject[] dys) {
        StringBuilder errMsgBuidler = new StringBuilder();
        Arrays.stream(dys).forEach(dyn -> {
            this.combinedUniqueFieldSet.stream().forEach(uniqueFields -> {
                Set<Long> combinedRepeatIdSet = this.repeatIdMap.get(uniqueFields);
                if (combinedRepeatIdSet.contains(dyn.getPkValue())) {
                    errMsgBuidler.append(this.getUniqueMsg((String)uniqueFields));
                }
            });
            if (errMsgBuidler.length() > 0) {
                HricDynamicObjectUtils.setBigText((DynamicObject)dyn, (String)"initerrormsg", (String)(HricDynamicObjectUtils.getBigText((DynamicObject)dyn, (String)"initerrormsg") + errMsgBuidler));
                dyn.set("initstatus", (Object)OperateEnum.INITCHECK.getErrorStatus());
            }
            errMsgBuidler.setLength(0);
        });
    }

    private void validateBDExists(DynamicObject[] dys) {
        Arrays.stream(dys).forEach(dyn -> {
            StringBuilder errBuilder = new StringBuilder();
            this.validateMustInput((DynamicObject)dyn, errBuilder);
            this.validateComboField((DynamicObject)dyn, errBuilder);
            this.validateExists((DynamicObject)dyn, errBuilder);
            if (HRStringUtils.isEmpty((String)errBuilder.toString())) {
                dyn.set("initstatus", (Object)OperateEnum.INITCHECK.getSuccessStatus());
                dyn.set("initerrormsg", (Object)"");
            } else {
                dyn.set("initstatus", (Object)OperateEnum.INITCHECK.getErrorStatus());
                HricDynamicObjectUtils.setBigText((DynamicObject)dyn, (String)"initerrormsg", (String)errBuilder.toString());
            }
        });
    }

    private void validateMustInput(DynamicObject dyn, StringBuilder errBuilder) {
        this.mustinputFieldMap.keySet().stream().forEach(mustinputField -> {
            if (HricObjectUtils.isEmpty((Object)dyn.get(mustinputField))) {
                errBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u5b57\u6bb5{0}\u7684\u503c\u3002", (String)"InitValidateServiceHelper_9", (String)"hrmp-hric-business", (Object[])new Object[]{this.mustinputFieldMap.get(mustinputField)}));
                dyn.set("initstatus", (Object)OperateEnum.INITCHECK.getErrorStatus());
            }
        });
    }

    private void validateComboField(DynamicObject dyn, StringBuilder errBuilder) {
        for (Map.Entry<String, Set<String>> comboFieldEntry : this.comboFieldMap.entrySet()) {
            if (!HRStringUtils.isNotEmpty((String)dyn.getString(comboFieldEntry.getKey())) || comboFieldEntry.getValue().contains(dyn.getString(comboFieldEntry.getKey()))) continue;
            errBuilder.append(ResManager.loadKDString((String)"\u679a\u4e3e\u5b57\u6bb5{0}\u65e0\u6cd5\u5339\u914d\u4e0b\u62c9\u9009\u9879\uff1a{1}\u3002", (String)"InitValidateServiceHelper_13", (String)"hrmp-hric-business", (Object[])new Object[]{this.midTableFieldMap.get(comboFieldEntry.getKey()).getDisplayName().getLocaleValue(), dyn.getString(comboFieldEntry.getKey())}));
        }
    }

    private void validateExists(DynamicObject dyn, StringBuilder errBuilder) {
        for (String fieldName : this.bdFieldMap.keySet()) {
            IDataEntityProperty prop = this.fieldMap.get(fieldName);
            if (HricObjectUtils.isEmpty((Object)dyn.get(fieldName)) || !this.existFieldMap.containsKey(fieldName)) continue;
            String baseEntityId = null;
            if (prop instanceof BasedataProp) {
                baseEntityId = ((BasedataProp)prop).getBaseEntityId();
            } else if (prop instanceof MulBasedataProp) {
                baseEntityId = ((MulBasedataProp)prop).getBaseEntityId();
            }
            if (!HRStringUtils.isNotEmpty((String)baseEntityId)) continue;
            Map<Object, DynamicObject> tempMap = this.baseDataMap.get(baseEntityId);
            String fieldValues = dyn.getString(fieldName);
            String filterValue = Arrays.stream(fieldValues.split(",")).filter(fieldValue -> !tempMap.containsKey(fieldValue)).collect(Collectors.joining(","));
            if (!HRStringUtils.isNotEmpty((String)filterValue)) continue;
            errBuilder.append(ResManager.loadKDString((String)"\u5b57\u6bb5{0}\u6240\u5bf9\u5e94\u503c{1}\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"InitValidateServiceHelper_10", (String)"hrmp-hric-business", (Object[])new Object[]{this.fieldMap.get(fieldName).getDisplayName().getLocaleValue(), filterValue}));
        }
    }

    public static void executeExecTask(Long taskId, TaskInfo taskInfo, List<DynamicObject> taskList) {
        String entityCode = taskInfo.getEntityNumber();
        String midTableNumber = taskInfo.getMidTableNumber();
        LOG.info(ResManager.loadKDString((String)"\u4e8b\u52a1\u5206\u9875\u5df2\u5b8c\u6210\u3002\u5f00\u59cb\u5f00\u542f\u591a\u7ebf\u7a0b\u6267\u884c\u521d\u59cb\u5316\u6821\u9a8c\uff1a\u201c\u4e8b\u52a1Id\u96c6\u5408{0}\u201d", (String)"InitValidateServiceHelper_11", (String)"hrmp-hric-business", (Object[])new Object[]{taskList.stream().filter(dyn -> dyn.getLong("pid") > 0L).map(dyn -> dyn.getLong("id")).collect(Collectors.toList())}));
        InitValidateServiceHelper validateServiceHelper = new InitValidateServiceHelper(taskId, entityCode, midTableNumber);
        for (DynamicObject execTask : taskList) {
            long pidId = execTask.getLong("pid");
            if (pidId == 0L) continue;
            ThreadPoolFactory.getInitValidateExecutor().execute(new InitValidateThread(execTask, validateServiceHelper));
        }
    }

    private String getUniqueMsg(String uniqueFields) {
        String fieldNames = Arrays.stream(uniqueFields.split(",")).map(uniqueField -> this.midTableFieldMap.get(uniqueField).getDisplayName().toString()).collect(Collectors.joining(","));
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6570\u636e%s\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InitValidateServiceHelper_12", (String)"hrmp-hric-business", (Object[])new Object[0]), fieldNames);
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public String getMidTableNumber() {
        return this.midTableNumber;
    }

    public Long getTaskID() {
        return this.taskID;
    }
}

