/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.IMessageService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.bussiness.service.factory.ThreadPoolFactory;
import kd.hrmp.hric.common.InitMessageInfoBuilder;
import kd.hrmp.hric.common.bean.InitMessageInfo;
import kd.hrmp.hric.common.constants.AsyncTaskSceneConstants;
import kd.hrmp.hric.common.util.ConvertUtils;

public class MessageSendServiceHelper {
    private static final Log LOG = LogFactory.getLog(MessageSendServiceHelper.class);
    private static final Map<String, Consumer<InitMessageInfo>> MESSAGE_CHANNEL_MAP = ImmutableMap.of((Object)"mcenter", message -> MessageSendServiceHelper.sendMessage(message), (Object)"sms", message -> MessageSendServiceHelper.sendShortMessage(message));
    private static final String UNITEST = "hric_unittest_message";

    public static InitMessageInfo buildTaskMessage(DynamicObject task, String title, String tag, String content) {
        ArrayList<Long> receivers = new ArrayList<Long>();
        receivers.add(task.get("taskleader") instanceof DynamicObject ? task.getDynamicObject("taskleader").getLong("id") : task.getLong("taskleader"));
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"name");
        InitMessageInfo info = new InitMessageInfoBuilder().buildReceivers(receivers).buildSenderName(currentUser.getString("name")).buildSenderId(Long.valueOf(currentUser.getLong("id"))).buildEntityName("hric_inittaskform").buildEntityId(Long.valueOf(task.getLong("id"))).buildContent(content).buildTitle(title).buildTag(tag).build();
        return info;
    }

    public static DynamicObject saveMessage(List<InitMessageInfo> initMessageInfoList) {
        MessageSendServiceHelper.setPhone(initMessageInfoList);
        MessageSendServiceHelper.setChannel(initMessageInfoList);
        return AsyncTaskServiceHelper.createTaskAndSave((Map<String, Object>)ImmutableMap.of((Object)"messageParams", (Object)JSON.toJSONString(initMessageInfoList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})), ID.genStringId(), "", AsyncTaskSceneConstants.SCENE_MESSAGE_NOTICE);
    }

    private static void setPhone(List<InitMessageInfo> messageInfoList) {
        HashSet receivers = Sets.newHashSet();
        messageInfoList.forEach(info -> receivers.addAll(info.getReceivers()));
        List userList = UserServiceHelper.get((List)Lists.newArrayList((Iterable)receivers)).stream().filter(it -> !HRStringUtils.isEmpty((String)((String)it.get("phone")))).collect(Collectors.toList());
        Map<Long, List> userListMap = userList.stream().collect(Collectors.toMap(it -> ConvertUtils.toLong(it.get("id")), it -> ImmutableList.of((Object)ConvertUtils.toString(it.get("phone")))));
        messageInfoList.forEach(messageInfo -> messageInfo.setPhone((List)userListMap.get(messageInfo.getReceivers().get(0))));
    }

    private static void sendMessage(InitMessageInfo messageInfo) {
        if (HRStringUtils.equals((String)BaseConfigServiceHelper.get(UNITEST), (String)"1")) {
            return;
        }
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo.convertToMessageInfo());
    }

    private static void sendShortMessage(InitMessageInfo messageInfo) {
        if (HRStringUtils.equals((String)BaseConfigServiceHelper.get(UNITEST), (String)"1")) {
            return;
        }
        ((IMessageService)ServiceFactory.getService(IMessageService.class)).sendShortMessage(messageInfo.convertToShortMessageInfo());
    }

    public static void sendSaveMessage(List<InitMessageInfo> initMessageInfoList, boolean sync) {
        if (sync) {
            MessageSendServiceHelper.doSendMessage(initMessageInfoList);
            return;
        }
        ThreadPoolFactory.getCommonExecutor().submit(() -> MessageSendServiceHelper.doSendMessage(initMessageInfoList));
    }

    public static void doSendMessage(List<InitMessageInfo> initMessageInfoList) {
        LOG.info("doSendMessage start");
        Instant start = Instant.now();
        initMessageInfoList.forEach(message -> message.getMessageChannelList().forEach(channel -> MESSAGE_CHANNEL_MAP.get(channel).accept((InitMessageInfo)message)));
        LOG.info("doSendMessage cost{}ms", (Object)Duration.between(start, Instant.now()).toMillis());
    }

    private static void setChannel(List<InitMessageInfo> initMessageInfoList) {
        initMessageInfoList.forEach(message -> {
            if (CollectionUtils.isEmpty((Collection)message.getMessageChannelList())) {
                message.addMessageChannel("mcenter");
                message.addMessageChannel("sms");
            }
        });
    }
}

