/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class MetadataPropertyHelper {
    private static Log LOG = LogFactory.getLog(MetadataPropertyHelper.class);
    private Map<String, IDataEntityProperty> billHeadFieldMap = new HashMap<String, IDataEntityProperty>();
    private Map<String, Map<String, IDataEntityProperty>> billEntryFieldMap = new HashMap<String, Map<String, IDataEntityProperty>>();
    private Set<String> billHeadBizKeySet = new HashSet<String>();
    private Set<String> billEntryBizKeySet = new HashSet<String>();
    private List<String> ENTRY_FILTER_FIELD = Lists.newArrayList((Object[])new String[]{"id", "seq"});
    private String entityCode;
    private String bussinessKey;

    public MetadataPropertyHelper(String entityCode, String bussinessKey) {
        this.entityCode = entityCode;
        this.bussinessKey = bussinessKey;
        this.init();
    }

    private void init() {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityCode);
        this.handleBill(dataEntityType);
        this.setNumberList();
    }

    private void handleBill(MainEntityType dataEntityType) {
        this.billHeadFieldMap = dataEntityType.getProperties().stream().collect(Collectors.toMap(pro -> pro.getName(), pro -> pro));
        List<IDataEntityProperty> entryPropList = this.billHeadFieldMap.values().stream().filter(pro -> pro instanceof EntryProp).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entryPropList)) {
            return;
        }
        entryPropList.forEach(entryProp -> {
            HashMap entryPropFieldMap = new HashMap();
            ((EntryProp)entryProp).getDynamicCollectionItemPropertyType().getProperties().stream().filter(pro -> !this.ENTRY_FILTER_FIELD.contains(pro.getName())).forEach(pro -> entryPropFieldMap.put(pro.getName(), pro));
            this.billEntryFieldMap.put(entryProp.getName(), entryPropFieldMap);
            this.billHeadFieldMap.remove(entryProp.getName());
        });
    }

    private void setNumberList() {
        ArrayList onlyFieldList = new ArrayList();
        if (HRStringUtils.isNotEmpty((String)this.bussinessKey)) {
            Splitter splitter = Splitter.on((String)"|").trimResults().omitEmptyStrings();
            onlyFieldList = Lists.newArrayList((Iterable)splitter.splitToList((CharSequence)this.bussinessKey));
        }
        Set<String> billHeadField = this.billHeadFieldMap.keySet();
        onlyFieldList.forEach(field -> {
            if (billHeadField.contains(field)) {
                this.billHeadBizKeySet.add((String)field);
            } else {
                this.billEntryBizKeySet.add((String)field);
            }
        });
    }

    public Set<String> getBillHeadBizKeySet() {
        return this.billHeadBizKeySet;
    }

    public Map<String, IDataEntityProperty> getBillHeadFieldMap() {
        return this.billHeadFieldMap;
    }

    public Map<String, Map<String, IDataEntityProperty>> getBillEntryFieldMap() {
        return this.billEntryFieldMap;
    }

    public Set<String> getBillEntryBizKeySet() {
        return this.billEntryBizKeySet;
    }
}

