/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hric.bussiness.service.WriteServiceHelper;
import kd.hrmp.hric.common.bean.WriteServiceInfo;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;
import kd.hrmp.hric.common.util.QFilterUtils;

public class MicConfigServiceHelper {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hric_micconfig");

    public static String getImplementNameByAppScope(String entityNumber) {
        QFilter qFilter = new QFilter("appscope", "=", (Object)entityNumber);
        qFilter.and(QFilterUtils.getEnableQFilter());
        DynamicObject dynamicObject = SERVICE_HELPER.queryOne("implementname", qFilter);
        return dynamicObject == null ? null : dynamicObject.getString("name") + "-" + dynamicObject.getString("implementname");
    }

    public static DynamicObject[] getBatchMicConfig(String selectProperties, QFilter qFilter) {
        if (qFilter == null) {
            return new DynamicObject[0];
        }
        QFilter filter = QFilterUtils.getEnableQFilter();
        filter.and(qFilter);
        DynamicObject[] dynamicObject = SERVICE_HELPER.query(selectProperties, filter.toArray());
        return dynamicObject;
    }

    public static DynamicObject getMicConfigByEntityCode(String entityCode) {
        QFilter qFilter = new QFilter("appscope.number", "=", (Object)entityCode);
        return MicConfigServiceHelper.getMicConfig(qFilter);
    }

    private static DynamicObject getMicConfig(QFilter qFilter) {
        qFilter.and(QFilterUtils.getEnableQFilter());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"hric_micconfig", (String)HricDynamicObjectUtils.getFieldByPage((String)"hric_micconfig"), (QFilter[])qFilter.toArray());
    }

    public static DynamicObject getMicConfigByAppId(String appId) {
        QFilter qFilter = new QFilter("appscope.id", "=", (Object)" ");
        qFilter.and(new QFilter("apprel.number", "=", (Object)appId));
        return MicConfigServiceHelper.getMicConfig(qFilter);
    }

    public static WriteServiceInfo getWriteServiceInfo(String entityCode) {
        return new WriteServiceHelper(entityCode).getWriteServiceInfo();
    }

    public static DynamicObject[] getMicConfigsByEntityNumber(String selectProperties, List<String> entityNumberList, List<Long> idList) {
        if (CollectionUtils.isEmpty(entityNumberList)) {
            return new DynamicObject[0];
        }
        QFilter qFilter = new QFilter("appscope", "in", entityNumberList);
        if (!CollectionUtils.isEmpty(idList)) {
            qFilter.and(new QFilter("id", "not in", idList));
        }
        return MicConfigServiceHelper.getBatchMicConfig(selectProperties, qFilter);
    }

    public static DynamicObject[] getMicConfigsByAppId(String selectProperties, List<String> appIdList, List<Long> idList) {
        if (CollectionUtils.isEmpty(appIdList)) {
            return new DynamicObject[0];
        }
        QFilter qFilter = new QFilter("apprel", "in", appIdList);
        qFilter.and(new QFilter("appscope", "=", (Object)" "));
        if (!CollectionUtils.isEmpty(idList)) {
            qFilter.and(new QFilter("id", "not in", idList));
        }
        return MicConfigServiceHelper.getBatchMicConfig(selectProperties, qFilter);
    }
}

