/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.MicConfigServiceHelper;
import kd.hrmp.hric.common.bean.WriteServiceInfo;
import kd.hrmp.hric.common.exception.KDHricException;

public class WriteServiceHelper {
    private static Log LOG = LogFactory.getLog(WriteServiceHelper.class);
    private static final String DEFAULT_HANDLE_CLASS_NAME = "kd.hr.hbp.business.init.CommonInitDomainDataByOpServiceImpl";
    private String region;
    private String handleClassName;
    private String queueName;
    private String entityCode;
    private DynamicObject entityConfig;
    private DynamicObject appConfig;

    public WriteServiceHelper(String entityCode) {
        this.entityCode = entityCode;
    }

    public WriteServiceInfo getWriteServiceInfo() {
        this.initRequestInfo();
        return new WriteServiceInfo(this.region, this.queueName, this.handleClassName);
    }

    public DynamicObject getWriteServiceDynamicObject() {
        this.initConfig();
        if (this.entityConfig != null) {
            return this.entityConfig;
        }
        return this.appConfig;
    }

    private void initRequestInfo() {
        this.initConfig();
        this.initRegionAndQueneName();
        this.initHandleClassName();
    }

    private void initConfig() {
        this.entityConfig = MicConfigServiceHelper.getMicConfigByEntityCode(this.entityCode);
        this.appConfig = MicConfigServiceHelper.getMicConfigByAppId(EntityMetadataCache.getDataEntityType((String)this.entityCode).getAppId());
    }

    private void initHandleClassName() {
        this.handleClassName = Optional.ofNullable(this.entityConfig).map(it -> it.getString("implementname")).orElse(null);
        if (HRStringUtils.isNotEmpty((String)this.handleClassName)) {
            return;
        }
        this.handleClassName = Optional.ofNullable(this.appConfig).map(it -> it.getString("implementname")).orElse(null);
        if (HRStringUtils.isNotEmpty((String)this.handleClassName)) {
            return;
        }
        this.handleClassName = DEFAULT_HANDLE_CLASS_NAME;
    }

    private void initRegionAndQueneName() {
        String topic = Optional.ofNullable(this.entityConfig).map(it -> it.getString("topic")).orElse(null);
        if (HRStringUtils.isNotEmpty((String)topic)) {
            this.parseTopic(topic);
            return;
        }
        topic = Optional.ofNullable(this.appConfig).map(it -> it.getString("topic")).orElse(null);
        if (HRStringUtils.isEmpty((String)topic)) {
            throw new KDHricException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5b9e\u4f53\u5bf9\u8c61\u7684\u5199\u5165\u670d\u52a1\u914d\u7f6e\u3002\u521d\u59cb\u5316\u4e2d\u5fc3-\u57fa\u7840\u914d\u7f6e-\u5199\u5165\u670d\u52a1\u914d\u7f6e\u3002", (String)"WriteServiceHelper_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        this.parseTopic(topic);
        LOG.info("region:{}, queneName:{}", (Object)this.region, (Object)this.queueName);
    }

    private void parseTopic(String topic) {
        List list = Splitter.on((String)"@").splitToList((CharSequence)topic);
        if (list.size() == 1) {
            String appId = EntityMetadataCache.getDataEntityType((String)this.entityCode).getAppId();
            this.region = AppMetadataCache.getAppInfo((String)appId).getCloudId().toLowerCase();
            this.queueName = (String)list.get(0);
        } else {
            this.region = (String)list.get(0);
            this.queueName = (String)list.get(1);
        }
    }
}

