/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.back;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.common.init.InitOutMessage;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hrmp.hric.bussiness.service.InitExecTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.back.ICallbackHandle;
import kd.hrmp.hric.bussiness.service.back.ResultCallbackListenerHandle;
import kd.hrmp.hric.bussiness.service.processing.ExecTaskCacheHandle;
import kd.hrmp.hric.bussiness.service.task.handle.callback.ChangeTaskStautsCallbackService;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.bean.TaskInfo;
import kd.hrmp.hric.common.exception.KDHricException;

public abstract class AbstractCallbackHandle
extends ResultCallbackListenerHandle
implements ICallbackHandle {
    private static Log LOG = LogFactory.getLog(AbstractCallbackHandle.class);
    protected final DynamicObject execTask;
    protected final InitOutParam initOutParam;
    protected String body;
    protected Long execTaskId;
    protected Long batchNumber;
    protected Map<Long, InitOutMessage> data;
    protected boolean success = true;
    protected String message;
    protected String midTableNumber;
    protected String entityNumber;
    protected Long startId;
    protected Long endId;
    protected QFilter qFilter;
    protected OperateEnum operate;
    protected TaskInfo taskInfo;
    protected boolean discard;
    private List<ExecTaskCacheHandle> execTaskCacheHandleList = Lists.newArrayList();
    private boolean doHandleOnly = false;

    public AbstractCallbackHandle(InitOutParam initOutParam, DynamicObject execTask) {
        this.execTask = execTask;
        this.initOutParam = initOutParam;
    }

    public AbstractCallbackHandle(InitOutParam initOutParam, DynamicObject execTask, boolean doHandleOnly) {
        this.execTask = execTask;
        this.initOutParam = initOutParam;
        this.doHandleOnly = doHandleOnly;
    }

    @Override
    public boolean handle() {
        this.parseResult();
        if (this.doHandleOnly) {
            return this.doHandle();
        }
        this.registerListener();
        LOG.info("taskid:{}", (Object)this.execTaskId);
        if (this.doHandle()) {
            LOG.info("taskid:{}, pre taskinfo", (Object)this.execTaskId);
            this.handleTaskStatus();
            LOG.info("taskid:{}, after taskinfo", (Object)this.execTaskId);
            return true;
        }
        return false;
    }

    protected void registerListener() {
        this.register(new ChangeTaskStautsCallbackService());
    }

    protected void handleTaskStatus() {
        this.execTaskCacheHandleList.add(this.finishTaskStatus(this.execTaskId));
        this.execTaskCacheHandleList.add(this.tryFinishParentTask());
    }

    protected ExecTaskCacheHandle finishTaskStatus(Long execTaskId) {
        return InitExecTaskServiceHelper.finishTaskStatus(execTaskId, this.discard);
    }

    protected ExecTaskCacheHandle tryFinishParentTask() {
        ExecTaskCacheHandle execTaskCacheHandle = InitExecTaskServiceHelper.tryFinishParentTask(this.execTaskId, this.execTask);
        if (execTaskCacheHandle.isParentExecTask()) {
            this.fireAfterParentExecTaskFinish(AbstractCallbackHandle.getAfterParentExecTaskFinishEvent(this.batchNumber, this.getPid(), this));
        }
        return execTaskCacheHandle;
    }

    private Long getPid() {
        Long pid = this.execTask.getLong("pid");
        if (Objects.isNull(pid) || pid.equals(0L)) {
            return this.execTaskId;
        }
        return pid;
    }

    public abstract boolean doHandle();

    protected String subStringLongText(String message) {
        if (message == null) {
            return null;
        }
        if (message.length() > 255) {
            return message.substring(0, 255);
        }
        return message;
    }

    private void parseResult() {
        this.execTaskId = this.initOutParam.getExecTaskId();
        this.batchNumber = this.initOutParam.getBatchNumber();
        this.operate = OperateEnum.getOperateEnumByOperateType((String)this.execTask.getString("operatetype"));
        this.data = this.initOutParam.getData();
        this.success = this.initOutParam.isSuccess();
        this.message = this.initOutParam.getMsg();
        try {
            this.taskInfo = (TaskInfo)JSONUtils.cast((String)this.execTask.getString("taskinfo"), TaskInfo.class);
        }
        catch (IOException e) {
            throw new KDHricException(e.getMessage());
        }
        this.qFilter = this.taskInfo.findQFilterObj();
        this.startId = this.taskInfo.getStartId();
        this.endId = this.taskInfo.getEndId();
        this.midTableNumber = this.taskInfo.getMidTableNumber();
        this.entityNumber = this.taskInfo.getEntityNumber();
    }

    @Override
    public List<ExecTaskCacheHandle> getExecTaskCacheHandleList() {
        return this.execTaskCacheHandleList;
    }

    public boolean isDiscard() {
        return this.discard;
    }
}

