/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.back;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.InitExecTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.back.DiscardCallbackHandle;
import kd.hrmp.hric.bussiness.service.back.ICallbackHandle;
import kd.hrmp.hric.bussiness.service.back.InitValidateCallbackHandle;
import kd.hrmp.hric.bussiness.service.back.ResultPageCallbackHandle;
import kd.hrmp.hric.bussiness.service.back.ResultStatusCallbackHandle;
import kd.hrmp.hric.bussiness.service.back.RollbackCallbackHandle;
import kd.hrmp.hric.common.OperateEnum;

public class CallbackHandleFactory {
    private static Log LOG = LogFactory.getLog(CallbackHandleFactory.class);

    public static ICallbackHandle getCallbackHandle(InitOutParam initOutParam) {
        DynamicObject execTask = InitExecTaskServiceHelper.getExecTaskById(initOutParam.getExecTaskId());
        String operateType = execTask.getString("operatetype");
        String discardTask = (String)initOutParam.getExtendMap().get("discardTask");
        if (Boolean.TRUE.toString().equalsIgnoreCase(discardTask)) {
            return new DiscardCallbackHandle(initOutParam, execTask);
        }
        if (HRStringUtils.equals((String)operateType, (String)OperateEnum.CHECK.getOperateType()) || HRStringUtils.equals((String)operateType, (String)OperateEnum.SYNC.getOperateType())) {
            return new ResultPageCallbackHandle(initOutParam, execTask);
        }
        if (HRStringUtils.equals((String)operateType, (String)OperateEnum.INITCHECK.getOperateType())) {
            return new InitValidateCallbackHandle(initOutParam, execTask);
        }
        if (HRStringUtils.equals((String)operateType, (String)OperateEnum.ROLLBACK.getOperateType())) {
            return new RollbackCallbackHandle(initOutParam, execTask);
        }
        return new ResultStatusCallbackHandle(initOutParam, execTask);
    }
}

