/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.back;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.back.AbstractCallbackHandle;
import kd.hrmp.hric.bussiness.service.back.ResultStatusCallbackHandle;

public class ResultPageCallbackHandle
extends AbstractCallbackHandle {
    private static Log LOG = LogFactory.getLog(ResultPageCallbackHandle.class);

    public ResultPageCallbackHandle(InitOutParam outParam, DynamicObject execTask) {
        super(outParam, execTask);
    }

    @Override
    public boolean doHandle() {
        if (this.success) {
            if (CollectionUtils.isEmpty((Map)this.data)) {
                LOG.warn("data is empty, handle data from exectask");
                return new ResultStatusCallbackHandle(this.initOutParam, this.execTask, true).handle();
            }
            this.handleResult();
        }
        return true;
    }

    private boolean handleResult() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(this.midTableNumber);
        ArrayList dyList = new ArrayList();
        List pkList = this.initOutParam.getData().keySet().stream().collect(Collectors.toList());
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query("initstatus, initerrormsg, initerrormsg_tag, hricbizid, hricmodifydate", new QFilter("id", "in", pkList).toArray());
        Map<Long, DynamicObject> dyMap = Stream.of(dynamicObjects).collect(Collectors.toMap(it -> it.getLong("id"), it -> it));
        this.initOutParam.getData().forEach((key, message) -> {
            DynamicObject dynamicObject = (DynamicObject)dyMap.get(key);
            dynamicObject.set("initstatus", (Object)(message.getSuccess() != false ? this.operate.getSuccessStatus() : this.operate.getErrorStatus()));
            dynamicObject.set("initerrormsg", (Object)this.subStringLongText(message.getMessage()));
            dynamicObject.set("initerrormsg_tag", (Object)message.getMessage());
            if (HRStringUtils.isNotEmpty((String)message.getPrimaryKey())) {
                dynamicObject.set("hricbizid", (Object)message.getPrimaryKey());
            }
            dyList.add(dynamicObject);
        });
        hrBaseServiceHelper.save(dyList.toArray(new DynamicObject[0]));
        return true;
    }
}

