/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.back;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hrmp.hric.bussiness.service.InitMidTableServiceHelper;
import kd.hrmp.hric.bussiness.service.back.AbstractCallbackHandle;
import kd.hrmp.hric.common.util.LogUtils;

public class ResultStatusCallbackHandle
extends AbstractCallbackHandle {
    private static Log LOG = LogFactory.getLog(ResultStatusCallbackHandle.class);
    private int count;
    private int pageCount;
    private static int PAGE_SIZE = 50000;

    public ResultStatusCallbackHandle(InitOutParam outParam, DynamicObject execTask) {
        super(outParam, execTask);
    }

    public ResultStatusCallbackHandle(InitOutParam outParam, DynamicObject execTask, boolean doHandleOnly) {
        super(outParam, execTask, doHandleOnly);
    }

    @Override
    public boolean doHandle() {
        if (this.success) {
            this.handleResult();
        }
        return true;
    }

    protected void handleResult() {
        this.initBackHandlePageInfo();
        for (int pageIndex = 0; pageIndex < this.pageCount; ++pageIndex) {
            DynamicObject[] dynamicObjectList = InitMidTableServiceHelper.queryPageCollection(this.midTableNumber, "initstatus, initerrormsg, hricmodifydate", this.getQFilters(), 0, PAGE_SIZE);
            LOG.info(ResManager.loadKDString((String)"\u83b7\u53d6\u7b2c{}\u7684\u6570\u636e\uff0c \u6570\u636e\u91cf\u4e3a{}\u6761", (String)"ResultStatusCallbackHandle_2", (String)"hrmp-hric-business", (Object[])new Object[0]), (Object)(++pageIndex), (Object)dynamicObjectList.length);
            this.setResponseData(dynamicObjectList);
            new HRBaseServiceHelper(this.midTableNumber).save(dynamicObjectList);
        }
    }

    protected void setResponseData(DynamicObject[] dynamicObjectList) {
        if (ArrayUtils.isEmpty((Object[])dynamicObjectList)) {
            return;
        }
        for (DynamicObject dy : dynamicObjectList) {
            dy.set("initstatus", (Object)this.operate.getSuccessStatus());
            dy.set("initerrormsg", (Object)"");
        }
    }

    protected QFilter[] getQFilters() {
        if (this.execTask.getLong("pid") > 0L) {
            QFilter idLimitQFilter = new QFilter("id", ">=", (Object)this.startId).and("id", "<=", (Object)this.endId);
            return new QFilter[]{this.qFilter, idLimitQFilter};
        }
        return this.qFilter.toArray();
    }

    public void initBackHandlePageInfo() {
        this.count = (Integer)LogUtils.printCostLog((String)ResManager.loadKDString((String)"\u5df2\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u7ed3\u679c\u603b\u6570\u3002", (String)"ResultStatusCallbackHandle_0", (String)"hrmp-hric-business", (Object[])new Object[0]), () -> InitMidTableServiceHelper.queryCount(this.midTableNumber, this.getQFilters()));
        this.pageCount = (int)Math.ceil((double)this.count / (double)PAGE_SIZE);
        if (LOG.isInfoEnabled()) {
            LOG.info(ResManager.loadKDString((String)"\u7ed3\u679c\u603b\u662f\u4e3a{}\uff0c\u5171\u5206{}\u9875\uff0c\u6bcf\u9875{}\u6761\u3002", (String)"ResultStatusCallbackHandle_1", (String)"hrmp-hric-business", (Object[])new Object[0]), new Object[]{this.count, this.pageCount, PAGE_SIZE});
        }
    }
}

