/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.datafix.impl;

import com.google.common.base.Joiner;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.IBasedataField;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.formater.FormatOptions;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.util.DBConfigUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataFixSceneEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataFixSqlGenEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataFixToolEntityService;
import kd.hrmp.hric.bussiness.service.datafix.IDataFixService;
import kd.hrmp.hric.bussiness.service.datafix.model.ColumnInfo;
import kd.hrmp.hric.bussiness.service.datafix.model.DataFixGenSqlScriptBo;
import kd.hrmp.hric.bussiness.service.datafix.model.RowData;
import kd.hrmp.hric.bussiness.service.datafix.model.SqlGenScript;
import kd.hrmp.hric.common.DataFixEnum;
import kd.hrmp.hric.common.DataFixSceneEnum;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.util.DateUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;

public class DataFixServiceImpl
implements IDataFixService {
    private static final Log LOG = LogFactory.getLog(DataFixServiceImpl.class);
    private static final Pattern TABLE_COLUMN_PATTERN = Pattern.compile("\\{([^\\}]+)\\}");
    private final IDataFixSceneEntityService dataFixSceneEntityService = ServiceFactory.getService(IDataFixSceneEntityService.class);
    private final IDataFixSqlGenEntityService dataFixSqlGenEntityService = ServiceFactory.getService(IDataFixSqlGenEntityService.class);
    private final IDataFixToolEntityService dataFixToolEntityService = ServiceFactory.getService(IDataFixToolEntityService.class);
    private final Map<String, IDataEntityProperty> dataFixToolProTypeMap = new HashMap<String, IDataEntityProperty>(16);
    private final List<String> insertIntoTableList = new ArrayList<String>(10);
    private final Date newDate = new Date();
    private final List<String> createBakTableSqlList = new ArrayList<String>(10);

    @Override
    public void genFixDataSql(DynamicObject dataFixDyn) {
        if (dataFixDyn == null) {
            return;
        }
        Long fixDataPkId = dataFixDyn.getLong("id");
        try {
            DynamicObject sceneDyn = this.getSceneDyn(dataFixDyn);
            DynamicObjectCollection fixDataEntryCol = this.getFixDataDynColByScene(dataFixDyn, sceneDyn);
            MainEntityType mainEntityType = this.getMainEntityType("hric_datafixtool");
            this.dataFixToolProTypeMap.putAll(mainEntityType.getAllFields());
            String sceneOpType = DataFixSceneEnum.getSceneOpTypeByNumber((String)sceneDyn.getString("number"));
            String fixVer = dataFixDyn.getString("bakver");
            DynamicObjectCollection sceneFixTempSqlDynCol = sceneDyn.getDynamicObjectCollection("fixentryentity");
            Boolean crossDb = false;
            for (DynamicObject sceneFixTempSqlDyn : sceneFixTempSqlDynCol) {
                if (!this.checkCrossDb(sceneFixTempSqlDyn.getString("relexedbroutekey"), sceneFixTempSqlDyn.getString("exedbroutekey")).booleanValue()) continue;
                crossDb = true;
            }
            DynamicObjectCollection globalRelDataDepDynCol = sceneDyn.getDynamicObjectCollection("overallentryentity");
            ArrayList<DataFixGenSqlScriptBo> tableSqlScriptVoList = new ArrayList<DataFixGenSqlScriptBo>(10);
            DataFixGenSqlScriptBo globalRelFixDataVo = new DataFixGenSqlScriptBo(fixDataPkId, fixVer, sceneOpType);
            globalRelFixDataVo.setCrossDb(crossDb);
            this.getGloableRelData(fixDataEntryCol, sceneOpType, globalRelDataDepDynCol, globalRelFixDataVo);
            LOG.info("overAllRelTable data,fixVer={},overAllRelTableModOpMap.size={},overAllRelTableDelOpMap.size={}", new Object[]{fixVer, globalRelFixDataVo.getGlobalRelTableModOpMap().size(), globalRelFixDataVo.getGlobalRelTableDelOpMap().size()});
            DynamicObject globalRelDataDyn = StringUtils.isNotEmpty((CharSequence)globalRelFixDataVo.getGlobalTempSql()) ? (DynamicObject)globalRelDataDepDynCol.get(0) : null;
            String pageFilterFields = "";
            if (globalRelDataDyn != null) {
                pageFilterFields = globalRelDataDyn.getString("afilterfield");
            }
            for (DynamicObject tempSqlDyn : sceneFixTempSqlDynCol) {
                String tableName = tempSqlDyn.getString("tablename");
                String dbRouteKey = tempSqlDyn.getString("exedbroutekey");
                DataFixGenSqlScriptBo dataFixGenSqlScriptBo = new DataFixGenSqlScriptBo(tableName, dbRouteKey, fixDataPkId, fixVer, sceneOpType);
                dataFixGenSqlScriptBo.setRelExeDbRouteKey(tempSqlDyn.getString("relexedbroutekey"));
                dataFixGenSqlScriptBo.setGlobalTempSql(globalRelFixDataVo.getGlobalTempSql());
                dataFixGenSqlScriptBo.getGlobalRelTableDelOpMap().putAll(globalRelFixDataVo.getGlobalRelTableDelOpMap());
                dataFixGenSqlScriptBo.getGlobalRelTableModOpMap().putAll(globalRelFixDataVo.getGlobalRelTableModOpMap());
                dataFixGenSqlScriptBo.setHasGlobalData(globalRelFixDataVo.isHasGlobalData());
                dataFixGenSqlScriptBo.setPageFilterFields(pageFilterFields);
                this.genSceneOpDataFixSql(dataFixGenSqlScriptBo, fixDataEntryCol, tempSqlDyn);
                tableSqlScriptVoList.add(dataFixGenSqlScriptBo);
            }
            this.saveDataFixSqlGenRec(dataFixDyn, sceneDyn, tableSqlScriptVoList, globalRelFixDataVo);
        }
        catch (Exception exception) {
            LOG.error("DataFixServiceImpl.genFixDataSql is exception,fixDataPkId={}", (Object)fixDataPkId, (Object)exception);
            String message = exception.getMessage();
            throw new KDHricException("genFixDataSql is exception,msg=" + message);
        }
    }

    private void getGloableRelData(DynamicObjectCollection fixDataEntryCol, String sceneOpType, DynamicObjectCollection globalRelDataDepDynCol, DataFixGenSqlScriptBo globalRelFixDataVo) {
        Map<String, Map<String, RowData>> globalRelTableModOpMap = globalRelFixDataVo.getGlobalRelTableModOpMap();
        Map<String, Object> globalRelTableDelOpMap = globalRelFixDataVo.getGlobalRelTableDelOpMap();
        if ("modify".equals(sceneOpType)) {
            Map<String, Map<String, RowData>> modGlobalDepDataMap = this.queryUpGlobalDepDataMap(globalRelDataDepDynCol, fixDataEntryCol, globalRelFixDataVo);
            if (globalRelFixDataVo.isCrossDb()) {
                globalRelFixDataVo.setHasGlobalData(false);
            } else if (!ObjectUtils.isEmpty(modGlobalDepDataMap)) {
                globalRelTableModOpMap.putAll(modGlobalDepDataMap);
            } else if (!CollectionUtils.isEmpty((Collection)globalRelDataDepDynCol)) {
                globalRelFixDataVo.setHasGlobalData(false);
            }
        } else {
            Map<String, Object> delGlobalDepDataMap = this.queryGlobalDepDataMap(globalRelDataDepDynCol, fixDataEntryCol, globalRelFixDataVo);
            if (globalRelFixDataVo.isCrossDb()) {
                globalRelFixDataVo.setHasGlobalData(false);
            } else if (!ObjectUtils.isEmpty(delGlobalDepDataMap)) {
                globalRelTableDelOpMap.putAll(delGlobalDepDataMap);
            } else if (!CollectionUtils.isEmpty((Collection)globalRelDataDepDynCol) && ObjectUtils.isEmpty(globalRelTableDelOpMap)) {
                globalRelFixDataVo.setHasGlobalData(false);
            }
        }
    }

    private void saveDataFixSqlGenRec(DynamicObject dataFixDyn, DynamicObject sceneDyn, List<DataFixGenSqlScriptBo> tableSqlScriptVoList, DataFixGenSqlScriptBo globalRelFixDataVo) throws SqlTranslateException {
        DynamicObject dataFixSqlGenDyn = this.dataFixSqlGenEntityService.generateEmptyDynamicObject();
        Long fixDataPkId = dataFixDyn.getLong("id");
        long currUserId = RequestContext.get().getCurrUserId();
        String sqlDesc = sceneDyn.getString("description");
        String noDataDesc = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6761\u4ef6\u65e0\u6cd5\u627e\u5230\u6570\u636e\uff01", (String)"DataFixServiceImpl_0", (String)"hrmp-hric-business", (Object[])new Object[0]);
        Boolean crossDb = false;
        for (DataFixGenSqlScriptBo dataFixGenSqlScriptBo : tableSqlScriptVoList) {
            if (!this.checkCrossDb(dataFixGenSqlScriptBo.getRelExeDbRouteKey(), dataFixGenSqlScriptBo.getDbRouteKey()).booleanValue()) continue;
            crossDb = true;
        }
        int seq = 0;
        for (DataFixGenSqlScriptBo dataFixGenSqlScriptBo : tableSqlScriptVoList) {
            DynamicObject dataFixToolDyn = this.dataFixToolEntityService.generateEmptyDynamicObject();
            dataFixToolDyn.set("id", (Object)fixDataPkId);
            dataFixSqlGenDyn.set("datefixtoolid", (Object)dataFixToolDyn);
            dataFixSqlGenDyn.set("relquerysql", (Object)globalRelFixDataVo.getSelectSql());
            dataFixSqlGenDyn.set("crossdb", (Object)crossDb);
            dataFixSqlGenDyn.set("hasglobaldata", (Object)globalRelFixDataVo.isHasGlobalData());
            dataFixSqlGenDyn.set("scenename", (Object)sceneDyn.getString("name"));
            dataFixSqlGenDyn.set("number", (Object)dataFixDyn.getString("number"));
            dataFixSqlGenDyn.set("creator", (Object)currUserId);
            dataFixSqlGenDyn.set("dataversion", (Object)dataFixGenSqlScriptBo.getFixVersion());
            dataFixSqlGenDyn.set("description", (Object)sqlDesc);
            dataFixSqlGenDyn.set("nodatadesc", (Object)(!globalRelFixDataVo.isHasGlobalData() ? noDataDesc : ""));
            DynamicObjectCollection sqlEntryCol = dataFixSqlGenDyn.getDynamicObjectCollection("entryentity");
            DynamicObjectType sqlEntryType = sqlEntryCol.getDynamicObjectType();
            List<String> dataFixSqlList = dataFixGenSqlScriptBo.getDataFixSqlList();
            List<String> dataBakSqlList = dataFixGenSqlScriptBo.getDataBakSqlList();
            String tableName = dataFixGenSqlScriptBo.getTableName();
            String bakWhereSql = dataFixGenSqlScriptBo.getBakWhereSql();
            String querySql = " SELECT * FROM " + tableName + " WHERE " + bakWhereSql;
            DynamicObject item = new DynamicObject(sqlEntryType);
            item.set("tablename", (Object)dataFixGenSqlScriptBo.getTableName());
            item.set("seq", (Object)seq++);
            item.set("dbroutekey", (Object)dataFixGenSqlScriptBo.getDbRouteKey());
            String sqlStr = Joiner.on((String)"\r\n").join(dataFixSqlList);
            String sqlBakStr = Joiner.on((String)"\r\n").join(dataBakSqlList);
            if (globalRelFixDataVo.isHasGlobalData()) {
                sqlStr = TransUtil.translate((String)sqlStr, (int)dataFixGenSqlScriptBo.getDbType(), (FormatOptions)new FormatOptions());
            }
            if (!sqlStr.endsWith(";")) {
                sqlStr = sqlStr + ";";
            }
            HricDynamicObjectUtils.setBigText((DynamicObject)item, (String)"exesql", (String)sqlStr);
            HricDynamicObjectUtils.setBigText((DynamicObject)item, (String)"baksql", (String)sqlBakStr);
            HricDynamicObjectUtils.setBigText((DynamicObject)item, (String)"querysql", (String)querySql);
            item.set("relexedbroutekey", (Object)dataFixGenSqlScriptBo.getRelExeDbRouteKey());
            sqlEntryCol.add((Object)item);
        }
        this.dataFixSqlGenEntityService.save(dataFixSqlGenDyn);
    }

    private DynamicObject getSceneDyn(DynamicObject dataFixDyn) {
        QFilter qFilter = new QFilter("number", "=", (Object)dataFixDyn.getString("number"));
        DynamicObject dataFixTool = this.dataFixToolEntityService.queryOne("fixscene", qFilter.toArray());
        long scenePkId = dataFixTool.getLong("fixscene.id");
        DynamicObject[] dataFixSceneDynArr = this.dataFixSceneEntityService.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "=", (Object)scenePkId)});
        return dataFixSceneDynArr[0];
    }

    private List<String> genSceneOpDataFixSql(DataFixGenSqlScriptBo dataFixGenSqlScriptBo, DynamicObjectCollection fixDataEntryCol, DynamicObject tempSqlDyn) throws SqlTranslateException {
        ArrayList<String> dataFixSqlList = new ArrayList<String>(10);
        String fixWhereTempSql = tempSqlDyn.getString("fixrwheresql");
        String tableName = tempSqlDyn.getString("tablename");
        String exeSqlTempSql = HricDynamicObjectUtils.getBigText((DynamicObject)tempSqlDyn, (String)"exesql");
        String dataQueryWhereSql = this.getDataQueryWhereSql(dataFixGenSqlScriptBo, fixDataEntryCol, fixWhereTempSql);
        if ("modify".equals(dataFixGenSqlScriptBo.getSceneOpType()) && dataFixGenSqlScriptBo.isHasGlobalData()) {
            for (DynamicObject dataDyn : fixDataEntryCol) {
                String dataExeSql = this.getUpFixDataSql(dataFixGenSqlScriptBo, exeSqlTempSql, dataDyn);
                String dataFixWhereSql = this.getUpFixDataSql(dataFixGenSqlScriptBo, fixWhereTempSql, dataDyn);
                dataFixSqlList.add(dataExeSql + " WHERE " + dataFixWhereSql + ";" + "\r\n");
            }
        } else if ("delete".equals(dataFixGenSqlScriptBo.getSceneOpType()) && dataFixGenSqlScriptBo.isHasGlobalData()) {
            String dataExeSql = "DELETE FROM " + tableName + " WHERE " + dataQueryWhereSql + ";" + "\r\n";
            dataFixSqlList.add(dataExeSql);
        } else {
            dataFixSqlList.add(exeSqlTempSql + " WHERE " + fixWhereTempSql + ";" + "\r\n");
        }
        if (dataFixGenSqlScriptBo.isHasGlobalData()) {
            dataFixGenSqlScriptBo.setBakWhereSql(dataQueryWhereSql);
        } else {
            dataFixGenSqlScriptBo.setBakWhereSql(fixWhereTempSql);
        }
        String createBakTableSql = this.genBakCreateTableSql(dataFixGenSqlScriptBo);
        StringBuilder bakExecSb = new StringBuilder();
        if (!this.createBakTableSqlList.contains(createBakTableSql)) {
            bakExecSb.append(createBakTableSql).append("\r\n");
        }
        this.createBakTableSqlList.add(createBakTableSql);
        StringBuilder bakSelectIdSqlSb = new StringBuilder();
        bakSelectIdSqlSb.append(" SELECT FID FROM ").append(tableName).append(" WHERE ").append(dataFixGenSqlScriptBo.getBakWhereSql()).append(";");
        String bakTranslateSql = dataFixGenSqlScriptBo.isHasGlobalData() ? TransUtil.translate((String)bakSelectIdSqlSb.toString(), (int)dataFixGenSqlScriptBo.getDbType(), (FormatOptions)new FormatOptions()) : bakSelectIdSqlSb.toString();
        bakTranslateSql = " SELECT * FROM " + bakTranslateSql.substring(16);
        DynamicObject dataFixSceneObj = (DynamicObject)tempSqlDyn.getParent();
        if (!this.insertIntoTableList.contains("INSERT INTO " + dataFixGenSqlScriptBo.getBakTableName())) {
            bakExecSb.append("INSERT INTO ");
            bakExecSb.append(dataFixGenSqlScriptBo.getBakTableName());
            bakExecSb.append(" ").append(bakTranslateSql);
        } else {
            String bakWhereSql = bakTranslateSql.substring(bakTranslateSql.indexOf(" WHERE ") + 6);
            bakExecSb.append("OR").append(bakWhereSql);
        }
        if (!bakTranslateSql.contains(";")) {
            bakExecSb.append(";");
        }
        if (DataFixEnum.MODIFY_EFFECT_DATE.getNumber().equals(dataFixSceneObj.getString("number"))) {
            this.insertIntoTableList.add("INSERT INTO " + dataFixGenSqlScriptBo.getBakTableName());
        }
        dataFixGenSqlScriptBo.getDataBakSqlList().add(bakExecSb.toString());
        dataFixGenSqlScriptBo.getDataFixSqlList().addAll(dataFixSqlList);
        return dataFixSqlList;
    }

    private String getUpFixDataSql(DataFixGenSqlScriptBo dataFixGenSqlScriptBo, String templateSql, DynamicObject dataDyn) {
        Matcher matcher = TABLE_COLUMN_PATTERN.matcher(templateSql);
        String sql = templateSql;
        while (matcher.find()) {
            String groupReplace;
            String group = matcher.group(1);
            if (StringUtils.equals((CharSequence)"now", (CharSequence)group)) {
                groupReplace = "{ts'" + DateUtils.date2String((Date)this.newDate, (String)"yyyy-MM-dd HH:mm:ss") + "'}";
            } else {
                Set<Object> columnParamSet = this.getOpParamValSet(dataFixGenSqlScriptBo, null, dataDyn, group);
                groupReplace = Joiner.on((String)",").join(columnParamSet);
            }
            if (group.contains("+")) {
                sql = sql.replaceAll("\\+", "");
                group = group.replaceAll("\\+", "");
            }
            sql = sql.replaceAll("\\{" + group + "\\}", groupReplace);
        }
        return sql;
    }

    private Object getColumnVal(RowData rowData, String columnName) {
        if (rowData == null) {
            return null;
        }
        if (columnName.equals(rowData.getPkProName())) {
            return rowData.getPkIdVal();
        }
        List<ColumnInfo> columnInfoList = rowData.getColumnInfoVoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            if (!columnName.equals(columnInfo.getColumnName())) continue;
            return columnInfo.getColumnVal();
        }
        return null;
    }

    private DynamicObjectCollection getFixDataDynColByScene(DynamicObject dataFixDyn, DynamicObject sceneDyn) {
        String sceneNumber = sceneDyn.getString("number");
        return dataFixDyn.getDynamicObjectCollection(DataFixSceneEnum.getEntryIdentifyByNumber((String)sceneNumber));
    }

    private Map<String, Object> queryGlobalDepDataMap(DynamicObjectCollection depEntryDynCol, DynamicObjectCollection dataDynCol, DataFixGenSqlScriptBo globalRelFixDataVo) {
        HashMap<String, Object> tableColumnMap = new HashMap<String, Object>(10);
        if (depEntryDynCol == null) {
            return tableColumnMap;
        }
        String sceneOpType = globalRelFixDataVo.getSceneOpType();
        String fixVersion = globalRelFixDataVo.getFixVersion();
        Long fixId = globalRelFixDataVo.getFixId();
        for (DynamicObject globalDepEntryDyn : depEntryDynCol) {
            this.setGlobalTempSql(globalDepEntryDyn, globalRelFixDataVo);
            String relTableName = globalDepEntryDyn.getString("areltable");
            String relDbRouteKey = globalDepEntryDyn.getString("adbroutekey");
            DataFixGenSqlScriptBo dataFixGenSqlScriptBo = new DataFixGenSqlScriptBo(relTableName, relDbRouteKey, fixId, fixVersion, sceneOpType);
            String whereSql = globalDepEntryDyn.getString("awheresql");
            String relFields = globalDepEntryDyn.getString("arelfields");
            String complexRelTable = globalDepEntryDyn.getString("acomplexrel");
            whereSql = this.getDataQueryWhereSql(dataFixGenSqlScriptBo, dataDynCol, whereSql);
            StringBuilder selectProperties = new StringBuilder(relFields);
            String filterField = globalDepEntryDyn.getString("afilterfield");
            String tableName = dataFixGenSqlScriptBo.getTableName();
            List<RowData> rowDataList = this.queryTableDataList(tableName, complexRelTable, DBRoute.of((String)dataFixGenSqlScriptBo.getDbRouteKey()), selectProperties, whereSql);
            if (CollectionUtils.isEmpty(rowDataList)) {
                StringBuilder sqlStringBuilder = new StringBuilder();
                sqlStringBuilder.append("SELECT ").append((CharSequence)selectProperties).append(" FROM ").append(dataFixGenSqlScriptBo.getTableName()).append(" WHERE ").append(globalDepEntryDyn.getString("awheresql")).append(";");
                globalRelFixDataVo.setSelectSql(sqlStringBuilder);
            }
            if ("modify".equals(sceneOpType)) {
                tableColumnMap.put(tableName, this.getFixTableUpRelDataMap(filterField, rowDataList));
                continue;
            }
            if (CollectionUtils.isEmpty(rowDataList)) continue;
            tableColumnMap.put(tableName, rowDataList);
        }
        return tableColumnMap;
    }

    private Map<String, Map<String, RowData>> queryUpGlobalDepDataMap(DynamicObjectCollection globalRelDataDepDynCol, DynamicObjectCollection dataDynCol, DataFixGenSqlScriptBo globalRelFixDataVo) {
        HashMap<String, Map<String, RowData>> tableColumnMap = new HashMap<String, Map<String, RowData>>(10);
        if (globalRelDataDepDynCol == null || globalRelDataDepDynCol.size() < 1) {
            return tableColumnMap;
        }
        String sceneOpType = globalRelFixDataVo.getSceneOpType();
        String fixVersion = globalRelFixDataVo.getFixVersion();
        Long fixId = globalRelFixDataVo.getFixId();
        for (DynamicObject globalDepEntryDyn : globalRelDataDepDynCol) {
            String[] fieldArr;
            this.setGlobalTempSql(globalDepEntryDyn, globalRelFixDataVo);
            String relTableName = globalDepEntryDyn.getString("areltable");
            String relDbRouteKey = globalDepEntryDyn.getString("adbroutekey");
            String pageFilterFields = globalDepEntryDyn.getString("afilterfield");
            DataFixGenSqlScriptBo dataFixGenSqlScriptBo = new DataFixGenSqlScriptBo(relTableName, relDbRouteKey, fixId, fixVersion, sceneOpType);
            String relFields = globalDepEntryDyn.getString("arelfields");
            String whereSql = globalDepEntryDyn.getString("awheresql");
            String complexRelTable = globalDepEntryDyn.getString("acomplexrel");
            dataFixGenSqlScriptBo.setPageFilterFields(pageFilterFields);
            whereSql = this.getDataQueryWhereSql(dataFixGenSqlScriptBo, dataDynCol, whereSql);
            StringBuilder selectProperties = new StringBuilder(relFields);
            List<RowData> rowDataList = this.queryTableDataList(dataFixGenSqlScriptBo.getTableName(), complexRelTable, DBRoute.of((String)dataFixGenSqlScriptBo.getDbRouteKey()), selectProperties, whereSql);
            if (CollectionUtils.isEmpty(rowDataList)) {
                StringBuilder sqlStringBuilder = new StringBuilder();
                sqlStringBuilder.append("SELECT ").append((CharSequence)selectProperties).append(" FROM ").append(dataFixGenSqlScriptBo.getTableName()).append(" WHERE ").append(globalDepEntryDyn.getString("awheresql")).append(";");
                globalRelFixDataVo.setSelectSql(sqlStringBuilder);
            }
            ArrayList<String> columnNameList = new ArrayList<String>(10);
            for (String field : fieldArr = pageFilterFields.split(",")) {
                String[] columnVsPageFieldArr = field.split("-");
                columnNameList.add(columnVsPageFieldArr[0]);
            }
            HashMap<String, RowData> columnMap = new HashMap<String, RowData>(10);
            for (RowData rowData : rowDataList) {
                StringBuilder filterKeySb = new StringBuilder();
                for (String columnName : columnNameList) {
                    Object columnVal = this.getColumnVal(rowData, columnName);
                    if (columnVal == null || columnVal instanceof Long && (Long)columnVal == 0L) continue;
                    filterKeySb.append(columnVal);
                }
                columnMap.put(filterKeySb.toString(), rowData);
            }
            if (ObjectUtils.isEmpty(columnMap)) continue;
            tableColumnMap.put(dataFixGenSqlScriptBo.getTableName(), columnMap);
        }
        return tableColumnMap;
    }

    private void setGlobalTempSql(DynamicObject globalDepEntryDyn, DataFixGenSqlScriptBo globalRelFixDataVo) {
        String relTableName = globalDepEntryDyn.getString("areltable");
        String complexRelTable = globalDepEntryDyn.getString("acomplexrel");
        String relFields = globalDepEntryDyn.getString("arelfields");
        String whereSql = globalDepEntryDyn.getString("awheresql");
        String tableName = StringUtils.isNotEmpty((CharSequence)complexRelTable) ? complexRelTable : relTableName;
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ").append(relFields).append(" FROM ").append(tableName).append(" WHERE ").append(whereSql).append(";").append("\r\n");
        globalRelFixDataVo.setGlobalTempSql(sqlBuilder.toString());
    }

    private Map<String, RowData> getFixTableUpRelDataMap(String filterField, List<RowData> rowDataList) {
        String[] filterFieldArr = filterField.split(",");
        HashMap<String, RowData> tableUpDataMap = new HashMap<String, RowData>(16);
        for (RowData rowData : rowDataList) {
            String upFilterFiledValKey = this.getUpFilterFiledValKey(filterFieldArr, rowData);
            tableUpDataMap.put(upFilterFiledValKey, rowData);
        }
        return tableUpDataMap;
    }

    private String getUpFilterFiledValKey(String[] filterFieldArr, RowData rowData) {
        List<ColumnInfo> columnInfoList = rowData.getColumnInfoVoList();
        StringBuilder upFilterFiledValSb = new StringBuilder();
        for (String filterF : filterFieldArr) {
            Object columnFieldVal = this.getColumnFieldVal(columnInfoList, filterF);
            if (columnFieldVal == null) continue;
            upFilterFiledValSb.append(columnFieldVal);
        }
        return upFilterFiledValSb.toString();
    }

    private Object getColumnFieldVal(List<ColumnInfo> columnInfoList, String filterF) {
        for (ColumnInfo columnInfo : columnInfoList) {
            if (!filterF.equals(columnInfo.getColumnName())) continue;
            return columnInfo.getColumnVal();
        }
        return null;
    }

    private String getDataQueryWhereSql(DataFixGenSqlScriptBo dataFixGenSqlScriptBo, DynamicObjectCollection fixDataEntryCol, String whereSql) {
        Matcher matcher = TABLE_COLUMN_PATTERN.matcher(whereSql);
        while (matcher.find()) {
            String group = matcher.group(1);
            ArrayList<Object> columnParamList = new ArrayList<Object>(10);
            columnParamList.addAll(this.getOpParamValSet(dataFixGenSqlScriptBo, fixDataEntryCol, null, group));
            if (group.contains("+")) {
                whereSql = whereSql.replaceAll("\\+", "");
                group = group.replaceAll("\\+", "");
            }
            whereSql = whereSql.replaceAll("\\{" + group + "\\}", Joiner.on((String)",").join(columnParamList));
        }
        return whereSql;
    }

    private Set<Object> getOpParamValSet(DataFixGenSqlScriptBo dataFixGenSqlScriptBo, DynamicObjectCollection fixDataEntryCol, DynamicObject dataDyn, String matcherGroup) {
        String[] fieldArr;
        String proName;
        HashSet<Object> columnParamSet = new HashSet<Object>(16);
        String[] tableProArr = matcherGroup.split("\\.");
        String baseQueryPro = null;
        String tableName = tableProArr[0];
        if (tableProArr.length == 3) {
            proName = tableProArr[1];
            fieldArr = tableProArr[2].split("#");
            baseQueryPro = proName + "." + fieldArr[0];
        } else {
            fieldArr = tableProArr[1].split("#");
            proName = fieldArr[0];
        }
        String proType = this.getProType(fieldArr);
        if (StringUtils.isNotEmpty((CharSequence)tableName)) {
            if ("modify".equals(dataFixGenSqlScriptBo.getSceneOpType())) {
                String pageFilterFields = dataFixGenSqlScriptBo.getPageFilterFields();
                Map<String, RowData> fieldsRowDataMap = dataFixGenSqlScriptBo.getGlobalRelTableModOpMap().get(tableName);
                String[] pageFilterFieldArr = pageFilterFields.split(",");
                if (dataDyn != null) {
                    this.addColumnParam(dataDyn, columnParamSet, proName, proType, fieldsRowDataMap, pageFilterFieldArr);
                } else {
                    for (DynamicObject fixDyn : fixDataEntryCol) {
                        this.addColumnParam(fixDyn, columnParamSet, proName, proType, fieldsRowDataMap, pageFilterFieldArr);
                    }
                }
            } else {
                List tableRowDataList = (List)dataFixGenSqlScriptBo.getGlobalRelTableDelOpMap().get(tableName);
                ArrayList proValueList = new ArrayList(10);
                if (!CollectionUtils.isEmpty((Collection)tableRowDataList)) {
                    tableRowDataList.stream().forEach(rowData -> {
                        List<ColumnInfo> columnInfoList = rowData.getColumnInfoVoList();
                        String finalProName = proName;
                        proValueList.addAll(columnInfoList.stream().filter(vo -> vo.getColumnName().equals(finalProName)).map(ColumnInfo::getColumnVal).collect(Collectors.toList()));
                    });
                }
                if (!CollectionUtils.isEmpty(proValueList)) {
                    proValueList.stream().forEach(paramObj -> {
                        Object paramValObj = this.getSqlParamVal(proType, paramObj);
                        this.addColumnParamSet(columnParamSet, paramValObj);
                    });
                }
            }
        } else if (fixDataEntryCol != null) {
            for (DynamicObject dataFixDyn : fixDataEntryCol) {
                Object dataFixParamObjVal = this.getDataFixParamObjVal(proName, baseQueryPro, proType, dataFixDyn);
                dataFixParamObjVal = this.addDayDate(fieldArr, proType, dataFixParamObjVal);
                this.addColumnParamSet(columnParamSet, this.getSqlParamVal(proType, dataFixParamObjVal));
            }
        } else if (dataDyn != null) {
            Object dataFixParamObjVal = this.getDataFixParamObjVal(proName, baseQueryPro, proType, dataDyn);
            dataFixParamObjVal = this.addDayDate(fieldArr, proType, dataFixParamObjVal);
            this.addColumnParamSet(columnParamSet, this.getSqlParamVal(proType, dataFixParamObjVal));
        }
        return columnParamSet;
    }

    private Object addDayDate(String[] fieldArr, String proType, Object dataFixParamObjVal) {
        if ("Date".equals(proType) && fieldArr[1].contains("+")) {
            String dayDateArr = fieldArr[1];
            String addDayCountStr = dayDateArr.split("\\+")[1];
            if (dataFixParamObjVal == null) {
                return null;
            }
            dataFixParamObjVal = HRDateTimeUtils.addDay((Date)((Date)dataFixParamObjVal), (long)Integer.parseInt(addDayCountStr));
        }
        return dataFixParamObjVal;
    }

    private String getProType(String[] fieldArr) {
        String proType;
        if (!fieldArr[1].contains("+")) {
            proType = fieldArr[1];
        } else {
            String dayDateArr = fieldArr[1];
            proType = dayDateArr.split("\\+")[0];
        }
        return proType;
    }

    private void addColumnParam(DynamicObject dataDyn, Set<Object> columnParamSet, String proName, String proType, Map<String, RowData> fieldsRowDataMap, String[] pageFilterFieldArr) {
        RowData upFixDataRow = this.getUpFixDataRow(dataDyn, fieldsRowDataMap, pageFilterFieldArr);
        Object columnVal = this.getColumnVal(upFixDataRow, proName);
        Object sqlParamVal = this.getSqlParamVal(proType, columnVal);
        this.addColumnParamSet(columnParamSet, sqlParamVal);
    }

    private void addColumnParamSet(Set<Object> columnParamSet, Object dataFixParamObjVal) {
        if (dataFixParamObjVal != null && columnParamSet != null) {
            columnParamSet.add(dataFixParamObjVal);
        }
    }

    private RowData getUpFixDataRow(DynamicObject dataDyn, Map<String, RowData> fieldsRowDataMap, String[] pageFilterFieldArr) {
        if (fieldsRowDataMap == null) {
            return null;
        }
        StringBuilder pageFilterKeySb = new StringBuilder();
        for (String pageFilterF : pageFilterFieldArr) {
            String[] filterFieldArr = pageFilterF.split("-");
            String[] pageTypeArr = filterFieldArr[1].split("#");
            String dynProName = pageTypeArr[0];
            String[] dynProArr = dynProName.split("\\.");
            Object dataFixParamObjVal = this.getDataFixParamObjVal(dynProArr[0], dynProName, pageTypeArr[1], dataDyn);
            if (dataFixParamObjVal == null) continue;
            pageFilterKeySb.append(dataFixParamObjVal);
        }
        return fieldsRowDataMap.get(pageFilterKeySb.toString());
    }

    private Object getDataFixParamObjVal(String proName, String baseQueryPro, String proType, DynamicObject dataFixDyn) {
        if (!this.dataFixToolProTypeMap.containsKey(proName)) {
            return null;
        }
        IDataEntityProperty iDataEntityProperty = this.dataFixToolProTypeMap.get(proName);
        Object paramsObj = iDataEntityProperty instanceof IBasedataField ? dataFixDyn.get(baseQueryPro) : dataFixDyn.get(proName);
        return paramsObj;
    }

    private Object getSqlParamVal(String proType, Object paramObj) {
        Object param = null;
        if (proType.equals("Date")) {
            if (paramObj == null) {
                paramObj = new Date();
            }
            param = "{ts'" + DateUtils.date2String((Date)((Date)paramObj), (String)"yyyy-MM-dd HH:mm:ss") + "'}";
        } else if (proType.equals("String")) {
            if (paramObj == null) {
                param = "' '";
                return param;
            }
            param = "'" + paramObj + "'";
        } else if (proType.equals("Long")) {
            if (paramObj == null) {
                paramObj = 0L;
                return paramObj;
            }
            param = paramObj;
        }
        return param;
    }

    public MainEntityType getMainEntityType(String entityNumber) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (mainType instanceof QueryEntityType) {
            return mainType;
        }
        return mainType;
    }

    public List<RowData> queryTableDataList(String relTableName, String complexRelTable, DBRoute dbRoute, StringBuilder selectProperties, String whereSql) {
        List primaryKeys = DB.getPrimaryKeys((DBRoute)dbRoute, (String)relTableName);
        if (CollectionUtils.isEmpty((Collection)primaryKeys)) {
            return new ArrayList<RowData>(10);
        }
        String primaryKey = ((String)primaryKeys.get(0)).toUpperCase();
        if (!selectProperties.toString().contains(primaryKey)) {
            selectProperties.append(",").append(primaryKey);
        }
        String tableName = StringUtils.isNotEmpty((CharSequence)complexRelTable) ? complexRelTable : relTableName;
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT ", new Object[0]).append(selectProperties.toString(), new Object[0]).append(" FROM ", new Object[0]).append(tableName, new Object[0]).append(" WHERE ", new Object[0]).append(whereSql, new Object[0]).append(";", new Object[0]);
        ResultSetHandler action = rs -> {
            ArrayList<RowData> list = new ArrayList<RowData>(10);
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            int fieldCount = resultSetMetaData.getColumnCount();
            ArrayList<String> columnNameList = new ArrayList<String>(fieldCount);
            for (int i = 1; i <= fieldCount; ++i) {
                columnNameList.add(resultSetMetaData.getColumnName(i));
            }
            while (rs.next()) {
                RowData rowData = new RowData();
                for (String columnName : columnNameList) {
                    ColumnInfo columnInfo = new ColumnInfo();
                    Object columnVal = rs.getObject(columnName);
                    if (columnName.equals(primaryKey)) {
                        rowData.setPkProName(columnName).setPkIdVal(columnVal);
                    }
                    columnInfo.setColumnName(columnName).setColumnVal(columnVal);
                    rowData.getColumnInfoVoList().add(columnInfo);
                }
                list.add(rowData);
            }
            return list;
        };
        return (List)DB.query((DBRoute)dbRoute, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
    }

    @Override
    public SqlGenScript getExeSqlStr(Long dataFixPkId) {
        DynamicObject dataFixSqlGenDyn;
        DynamicObject[] dataFixSqlGenDynArr = this.dataFixSqlGenEntityService.loadDynamicObjectArray(new QFilter[]{new QFilter("datefixtoolid.id", "=", (Object)dataFixPkId)});
        if (dataFixSqlGenDynArr == null || dataFixSqlGenDynArr.length < 1) {
            QFilter dataFixFilter = new QFilter("id", "=", (Object)dataFixPkId);
            Object[] dataFixToolDynArr = this.dataFixToolEntityService.loadDynamicObjectArray(dataFixFilter.toArray());
            if (ObjectUtils.isEmpty((Object[])dataFixToolDynArr)) {
                return null;
            }
            LOG.info("genFixDataSql start,dataFixPkId={}", (Object)dataFixPkId);
            long startTime = System.currentTimeMillis();
            this.genFixDataSql((DynamicObject)dataFixToolDynArr[0]);
            LOG.info("genFixDataSql end,dataFixPkId={},cost={}ms", (Object)dataFixPkId, (Object)(System.currentTimeMillis() - startTime));
            dataFixSqlGenDynArr = this.dataFixSqlGenEntityService.loadDynamicObjectArray(new QFilter[]{new QFilter("datefixtoolid.id", "=", (Object)dataFixPkId)});
            if (dataFixSqlGenDynArr == null || dataFixSqlGenDynArr.length == 0) {
                return null;
            }
            dataFixSqlGenDyn = dataFixSqlGenDynArr[0];
        } else {
            dataFixSqlGenDyn = dataFixSqlGenDynArr[0];
        }
        HashSet<String> dbRouteKeySet = new HashSet<String>(16);
        String sceneName = dataFixSqlGenDyn.getString("scenename");
        String dataVersion = dataFixSqlGenDyn.getString("dataversion");
        DynamicObjectCollection dynCol = dataFixSqlGenDyn.getDynamicObjectCollection("entryentity");
        String[] descriptionArr = dataFixSqlGenDyn.getString("description").split("\u3002");
        StringBuilder sqlStrSb = new StringBuilder();
        sqlStrSb.append("/**").append("\r\n").append("  ").append(ResManager.loadKDString((String)"\u63d0\u793a\uff1a", (String)"DataFixServiceImpl_7", (String)"hrmp-hric-business", (Object[])new Object[0])).append("\r\n");
        for (String description : descriptionArr) {
            sqlStrSb.append("  ").append(description).append("\r\n");
        }
        sqlStrSb.append(" */").append("\r\n");
        sqlStrSb.append("\r\n").append("\r\n");
        if (StringUtils.isNotBlank((CharSequence)dataFixSqlGenDyn.getString("relquerysql"))) {
            String title = ResManager.loadKDString((String)"--- \u67e5\u8be2\u811a\u672c\u5982\u4e0b\uff1a", (String)"DataFixServiceImpl_4", (String)"hrmp-hric-business", (Object[])new Object[0]);
            sqlStrSb.append(title).append("\r\n");
            sqlStrSb.append(dataFixSqlGenDyn.getString("relquerysql")).append("\r\n").append("\r\n");
        }
        sqlStrSb.append(ResManager.loadKDString((String)"--- \u5907\u4efd\u811a\u672c\u5982\u4e0b\uff1a", (String)"DataFixServiceImpl_0", (String)"hrmp-hric-business", (Object[])new Object[0])).append("\r\n");
        this.getDownloadSql(dbRouteKeySet, dynCol, sqlStrSb, "baksql");
        String noticeMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u5907\u4efd\u6570\u636e\uff0c\u518d\u8fdb\u884c\u6570\u636e\u4fee\u590d\u3002", (String)"DataFixServiceImpl_1", (String)"hrmp-hric-business", (Object[])new Object[0]);
        sqlStrSb.append("\r\n").append("\r\n").append("\r\n");
        sqlStrSb.append("/**").append("\r\n").append("EMPTY").append(noticeMsg).append("\r\n").append(" */").append("\r\n");
        sqlStrSb.append(ResManager.loadKDString((String)"--- \u6267\u884c\u811a\u672c\u5982\u4e0b\uff1a", (String)"DataFixServiceImpl_2", (String)"hrmp-hric-business", (Object[])new Object[0])).append("\r\n");
        this.getDownloadSql(dbRouteKeySet, dynCol, sqlStrSb, "exesql");
        SqlGenScript sqlGenScript = new SqlGenScript(dataFixPkId, sceneName, dataVersion, sqlStrSb.toString());
        sqlGenScript.setCrossDb(dataFixSqlGenDyn.getBoolean("crossdb"));
        sqlGenScript.setHasGlobalData(dataFixSqlGenDyn.getBoolean("hasglobaldata"));
        sqlGenScript.setNoDataDesc(dataFixSqlGenDyn.getString("nodatadesc"));
        return sqlGenScript;
    }

    private void getDownloadSql(Set<String> dbRouteKeySet, DynamicObjectCollection dynCol, StringBuilder sqlStrSb, String proName) {
        for (DynamicObject dyn : dynCol) {
            String exeSql;
            String dbRouteKey = dyn.getString("dbroutekey");
            if (!dbRouteKeySet.contains(dbRouteKey)) {
                sqlStrSb.append("\r\n");
                sqlStrSb.append("---------------------dbRouteKey:").append(dbRouteKey).append("\r\n");
            }
            if ((exeSql = HricDynamicObjectUtils.getBigText((DynamicObject)dyn, (String)proName)).length() > 2 && "OR".equals(exeSql.substring(0, 2))) {
                sqlStrSb.delete(sqlStrSb.length() - 3, sqlStrSb.length());
                sqlStrSb.append(" ").append(exeSql).append("\r\n");
            } else {
                sqlStrSb.append(exeSql).append("\r\n");
            }
            dbRouteKeySet.add(dbRouteKey);
        }
    }

    @Override
    public String genBakCreateTableSql(DataFixGenSqlScriptBo dataFixGenSqlScriptBo) {
        StringBuilder sqlSb = new StringBuilder();
        if (DBType.Oracle.getValue() == dataFixGenSqlScriptBo.getDbType()) {
            sqlSb.append("CREATE TABLE ").append(dataFixGenSqlScriptBo.getBakTableName()).append(" AS SELECT * FROM ").append(dataFixGenSqlScriptBo.getTableName()).append(" WHERE 1 = 0;");
        } else if (DBType.PostgreSQL.getValue() == dataFixGenSqlScriptBo.getDbType()) {
            sqlSb.append("CREATE TABLE ").append(dataFixGenSqlScriptBo.getBakTableName()).append(" (LIKE ").append(dataFixGenSqlScriptBo.getTableName()).append(" INCLUDING ALL);");
        } else if (DBType.MySQL.getValue() == dataFixGenSqlScriptBo.getDbType() || DBType.GaussDB.getValue() == dataFixGenSqlScriptBo.getDbType()) {
            sqlSb.append("CREATE TABLE ").append(dataFixGenSqlScriptBo.getBakTableName()).append(" LIKE ").append(dataFixGenSqlScriptBo.getTableName()).append(";");
        } else if (DBType.SQLServer.getValue() == dataFixGenSqlScriptBo.getDbType()) {
            sqlSb.append("CREATE TABLE ").append(dataFixGenSqlScriptBo.getBakTableName()).append(" AS SELECT * FROM ").append(dataFixGenSqlScriptBo.getTableName()).append(" WHERE 1 = 0;");
        }
        return sqlSb.toString();
    }

    private Boolean checkCrossDb(String relRouteKey, String routeKey) {
        DBConfigUtil dbConfigUtil = new DBConfigUtil();
        if (!StringUtils.isEmpty((CharSequence)relRouteKey)) {
            String relRouteSchema = dbConfigUtil.getDBConfigSharingId(relRouteKey);
            String routeSchema = dbConfigUtil.getDBConfigSharingId(routeKey);
            if (!StringUtils.equals((CharSequence)routeSchema, (CharSequence)relRouteSchema)) {
                return true;
            }
        }
        return false;
    }
}

