/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.datafix.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hrmp.hric.bussiness.service.datafix.model.RowData;

public class DataFixBo {
    private String tableName;
    private String bakTableName;
    private String dbRouteKey;
    private String repairVersion;
    private List<Map<String, List<Object>>> filterProVsValMapList = new ArrayList<Map<String, List<Object>>>(10);
    private String columns;
    private DBRoute dbRoute;
    private Boolean isRetryOp = false;
    private Boolean isBakSuccess = false;
    private Boolean isGenRepairSqlSuccess = false;
    private String pkColumnName;
    private Long fixId;
    private Long sceneId;
    private Map<String, FieldInfo> columnMap = new HashMap<String, FieldInfo>(16);
    private Map<String, List<RowData>> tableColumnDataMapList = new HashMap<String, List<RowData>>(16);
    private List<String> dataFixSqlList = new ArrayList<String>(10);
    private List<String> dataBakSqlList = new ArrayList<String>(10);
    private Boolean isExistsBakTable = false;

    public DataFixBo(String tableName, String dbRouteKey, String repairVersion, Long fixId) {
        this.tableName = tableName;
        this.dbRouteKey = dbRouteKey;
        this.repairVersion = repairVersion;
        this.fixId = fixId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getBakTableName() {
        if (StringUtils.isEmpty((String)this.bakTableName)) {
            this.bakTableName = this.tableName + "_" + this.repairVersion;
        }
        return this.bakTableName;
    }

    public void setBakTableName(String bakTableName) {
        this.bakTableName = bakTableName;
    }

    public String getRepairVersion() {
        return this.repairVersion;
    }

    public void setRepairVersion(String repairVersion) {
        this.repairVersion = repairVersion;
    }

    public Boolean getRetryOp() {
        return this.isRetryOp;
    }

    public void setRetryOp(Boolean retryOp) {
        this.isRetryOp = retryOp;
    }

    public DBRoute getDbRoute() {
        if (this.dbRoute == null) {
            this.dbRoute = DBRoute.of((String)this.dbRouteKey);
        }
        return this.dbRoute;
    }

    public List<Map<String, List<Object>>> getFilterProVsValMapList() {
        return this.filterProVsValMapList;
    }

    public String getPkColumnName() {
        if (StringUtils.isEmpty((String)this.pkColumnName)) {
            this.pkColumnName = (String)DB.getPrimaryKeys((DBRoute)this.getDbRoute(), (String)this.tableName).get(0);
        }
        return this.pkColumnName;
    }

    public Boolean getBakSuccess() {
        return this.isBakSuccess;
    }

    public void setBakSuccess(Boolean bakSuccess) {
        this.isBakSuccess = bakSuccess;
    }

    public String getColumns() {
        if (StringUtils.isEmpty((String)this.columns)) {
            this.columns = String.join((CharSequence)",", DB.getColumnNames((DBRoute)this.getDbRoute(), (String)this.tableName));
        }
        return this.columns;
    }

    public Boolean getGenRepairSqlSuccess() {
        return this.isGenRepairSqlSuccess;
    }

    public void setGenRepairSqlSuccess(Boolean genRepairSqlSuccess) {
        this.isGenRepairSqlSuccess = genRepairSqlSuccess;
    }

    public Long getFixId() {
        return this.fixId;
    }

    public void setFixId(Long fixId) {
        this.fixId = fixId;
    }

    public Long getSceneId() {
        return this.sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public FieldInfo getColumnInfoByName(String columnName) {
        if (this.columnMap.size() == 0) {
            List fieldInfo = DB.getFieldInfo((DBRoute)this.getDbRoute(), (String)this.tableName);
            if (CollectionUtils.isEmpty((Collection)fieldInfo)) {
                return null;
            }
            this.columnMap = fieldInfo.stream().collect(Collectors.toMap(FieldInfo::getFieldName, col -> col));
        }
        return this.columnMap.get(columnName);
    }

    public Map<String, List<RowData>> getTableColumnDataMapList() {
        return this.tableColumnDataMapList;
    }

    public List<String> getDataFixSqlList() {
        return this.dataFixSqlList;
    }

    public Boolean getExistsBakTable() {
        return this.isExistsBakTable;
    }

    public void setExistsBakTable(Boolean existsBakTable) {
        this.isExistsBakTable = existsBakTable;
    }

    public List<String> getDataBakSqlList() {
        return this.dataBakSqlList;
    }
}

