/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitInParam;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.bussiness.service.InitExecTaskService;
import kd.hrmp.hric.bussiness.service.InitExecTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitValidateServiceHelper;
import kd.hrmp.hric.bussiness.service.MicConfigServiceHelper;
import kd.hrmp.hric.bussiness.service.factory.ThreadPoolFactory;
import kd.hrmp.hric.bussiness.service.task.exec.AutoGenerateExecTask;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.PredicateContainer;
import kd.hrmp.hric.common.bean.TaskInfo;
import kd.hrmp.hric.common.bean.WriteServiceInfo;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;

public class InitExecTaskServiceImpl
implements InitExecTaskService {
    private static Log LOG = LogFactory.getLog(InitExecTaskServiceImpl.class);
    private static final Set<String> PAGE_TASK_SET = ImmutableSet.of((Object)OperateEnum.CHECK.getOperateType(), (Object)OperateEnum.SYNC.getOperateType());
    private static final String INIT_CHECK_TASK = OperateEnum.INITCHECK.getOperateType();
    private static final HRBaseServiceHelper EXEC_TASK_HELPER = new HRBaseServiceHelper("hric_exectask");
    private boolean updateRetryTimes = true;

    @Override
    public boolean retry(List<DynamicObject> taskDyList) {
        return this.retry(taskDyList, true);
    }

    @Override
    public boolean retry(List<DynamicObject> taskDyList, boolean updateRetryTimes) {
        this.updateRetryTimes = updateRetryTimes;
        if (CollectionUtils.isEmpty(taskDyList)) {
            return false;
        }
        DynamicObject parentTask = this.findTotalTask(taskDyList);
        boolean retryParentTask = this.tryParentTaskRetryForDistributeTask(parentTask, taskDyList);
        if (retryParentTask) {
            return true;
        }
        TaskInfo taskInfo = this.parseTaskInfo(parentTask);
        String operateType = parentTask.getString("operatetype");
        if (INIT_CHECK_TASK.equals(operateType)) {
            InitValidateServiceHelper.executeExecTask(parentTask.getLong("batchnumber"), taskInfo, taskDyList);
            return true;
        }
        this.doStartTask(taskDyList, taskInfo, parentTask);
        return true;
    }

    private boolean tryParentTaskRetryForDistributeTask(DynamicObject parentTask, List<DynamicObject> taskDyList) {
        PredicateContainer predicateContainer = PredicateContainer.getInstance();
        predicateContainer.append(task -> this.updateRetryTimes);
        predicateContainer.append(task -> task.getLong("pid") == 0L);
        predicateContainer.append(task -> PAGE_TASK_SET.contains(task.getString("operatetype")));
        predicateContainer.append(task -> Objects.nonNull(taskDyList) && taskDyList.size() == 1);
        predicateContainer.append(task -> !InitExecTaskServiceHelper.isExistSubExecTask(parentTask.getLong("id")));
        if (predicateContainer.allMatch((Object)parentTask)) {
            DynamicObject pTask = InitExecTaskServiceHelper.getExecTaskById(parentTask.getLong("id"));
            ThreadPoolFactory.getDistributeTaskExecutor().submit(new AutoGenerateExecTask(pTask));
            long retryTimes = pTask.getLong("retrytime");
            pTask.set("taskstatus", (Object)"A");
            HricDynamicObjectUtils.clearBigText((DynamicObject)pTask, (String)"result");
            pTask.set("retrytime", (Object)(++retryTimes));
            pTask.set("lastretrytime", (Object)new Date());
            InitExecTaskServiceHelper.save(pTask);
            return true;
        }
        return false;
    }

    @Override
    public TaskInfo parseTaskInfo(DynamicObject execTask) {
        try {
            TaskInfo taskInfo = (TaskInfo)JSONUtils.cast((String)execTask.getString("taskinfo"), TaskInfo.class);
            return taskInfo;
        }
        catch (IOException e) {
            throw new KDHricException(e.getMessage());
        }
    }

    private DynamicObject findTotalTask(List<DynamicObject> taskDyList) {
        for (DynamicObject task : taskDyList) {
            if (task.getLong("pid") != 0L) continue;
            return task;
        }
        Long pid = taskDyList.get(0).getLong("pid");
        QFilter qFilter = new QFilter("id", "=", (Object)pid);
        Object[] pTasks = this.queryExecTaskByIdList(qFilter);
        if (HRArrayUtils.isEmpty((Object[])pTasks)) {
            return new DynamicObject();
        }
        return pTasks[0];
    }

    private void doStartTask(List<DynamicObject> taskList, TaskInfo taskInfo, DynamicObject totalTask) {
        WriteServiceInfo writeServiceInfo = MicConfigServiceHelper.getWriteServiceInfo(taskInfo.getEntityNumber());
        MessagePublisher pub = MQFactory.get().createSimplePublisher(writeServiceInfo.getRegion(), writeServiceInfo.getQueueName());
        TXHandle required = TX.required();
        try {
            OperateEnum operate = OperateEnum.getOperateEnumByOperateType((String)totalTask.getString("operatetype"));
            ArrayList retryList = Lists.newArrayList();
            for (int i = 0; i < taskList.size(); ++i) {
                String midTableIds;
                boolean skip;
                DynamicObject task = taskList.get(i);
                long pid = task.getLong("pid");
                boolean bl = skip = pid == 0L && (OperateEnum.CHECK == operate || OperateEnum.SYNC == operate);
                if (skip) continue;
                long retryTimes = task.getLong("retrytime");
                task.set("taskstatus", (Object)"A");
                HricDynamicObjectUtils.clearBigText((DynamicObject)task, (String)"result");
                task.set("retrytime", (Object)(++retryTimes));
                task.set("lastretrytime", (Object)new Date());
                retryList.add(task);
                long id = task.getLong("id");
                InitInParam initInParam = new InitInParam();
                initInParam.setExecTaskId(Long.valueOf(id));
                initInParam.setEntityNumber(taskInfo.getEntityNumber());
                initInParam.setBatchNumber(Long.valueOf(totalTask.getLong("batchnumber")));
                initInParam.setMethod(operate.getMethod());
                initInParam.setHandleClassName(writeServiceInfo.getHandleClassName());
                initInParam.setOther((Map)Maps.newHashMap());
                if (operate == OperateEnum.ROLLBACK && HRStringUtils.isNotEmpty((String)(midTableIds = totalTask.getString("midtableids")))) {
                    HashMap<String, Boolean> otherMap = new HashMap<String, Boolean>();
                    otherMap.put("isSelected", true);
                    initInParam.setOther(otherMap);
                }
                initInParam.getOther().put("hric$subTaskInitBatchMap", taskInfo.getTaskMapping());
                initInParam.getOther().put("common$skip.biz.validate", BaseConfigServiceHelper.isSkipBizValidate());
                pub.publishInDbTranscation(AppMetadataCache.getAppInfo((String)"hric").getDbRoute(), (Object)JSONUtils.toString((Object)initInParam));
            }
            if (this.updateRetryTimes) {
                EXEC_TASK_HELPER.save(retryList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception ex) {
            required.markRollback();
            LOG.error((Throwable)ex);
            throw new KDHricException(ResManager.loadKDString((String)"\u4fdd\u5b58\u4efb\u52a1\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"InitExecTaskServiceImpl_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        finally {
            required.close();
            pub.close();
        }
    }

    @Override
    public Long getLastestTaskId(QFilter[] qFilters) {
        DynamicObject execTask = EXEC_TASK_HELPER.queryOne("id, pid", qFilters, "id desc");
        if (Objects.isNull(execTask)) {
            return null;
        }
        long pid = execTask.getLong("pid");
        long id = execTask.getLong("id");
        if (pid > 0L) {
            return pid;
        }
        return id;
    }

    @Override
    public DynamicObject[] queryExecTaskByIdList(List<Long> idList) {
        QFilter idFilter = new QFilter("id", "in", idList);
        return this.queryExecTaskByIdList(idFilter);
    }

    @Override
    public DynamicObject[] queryExecTaskByIdList(QFilter qFilter) {
        return EXEC_TASK_HELPER.query("id, batchnumber, taskstatus, taskinfo, operatetype, pid, taskstarttime, retrytime, lastretrytime, midtableids, result, result_tag", qFilter.toArray());
    }

    @Override
    public void discardExecTask(List<DynamicObject> preHandleList) {
        MessagePublisher pub = MQFactory.get().createSimplePublisher("hrmp", "hric_init_callback_queue");
        try (TXHandle txHandle = TX.required();){
            for (DynamicObject preHandle : preHandleList) {
                InitOutParam initOutParam = new InitOutParam();
                initOutParam.setExecTaskId(Long.valueOf(preHandle.getLong("id")));
                initOutParam.setBatchNumber(Long.valueOf(preHandle.getLong("batchnumber")));
                initOutParam.addExtendInfo("discardTask", (Object)Boolean.TRUE.toString());
                pub.publishInDbTranscation(AppMetadataCache.getAppInfo((String)"hric").getDbRoute(), (Object)JSONUtils.toString((Object)initOutParam));
            }
        }
    }

    @Override
    public Long getCurrentBatchTotalCount(Long execTaskId) {
        if (execTaskId == null || execTaskId == 0L) {
            return null;
        }
        Long id = this.getParentExecTaskId(execTaskId);
        if (Objects.nonNull(id)) {
            return this.getCountByExecTaskId(id);
        }
        return null;
    }

    private Long getCountByExecTaskId(Long execTaskId) {
        DynamicObject dy = EXEC_TASK_HELPER.queryOne("count", new QFilter("id", "=", (Object)execTaskId).toArray());
        return Optional.of(dy).map(it -> it.getLong("count")).orElseGet(() -> null);
    }

    private Long getParentExecTaskId(Long execTaskId) {
        DynamicObject dy = EXEC_TASK_HELPER.queryOne("pid", new QFilter("id", "=", (Object)execTaskId).toArray());
        Long pid = Optional.ofNullable(dy).map(it -> it.getLong("pid")).orElseGet(() -> null);
        if (Objects.isNull(pid)) {
            return null;
        }
        if (pid == 0L) {
            return execTaskId;
        }
        return pid;
    }
}

