/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataClearEntityService;
import kd.hrmp.hric.bussiness.domain.init.IInitTemplateDomainService;
import kd.hrmp.hric.bussiness.domain.init.IMidTableDomainService;
import kd.hrmp.hric.bussiness.service.IAsyncTaskService;
import kd.hrmp.hric.bussiness.service.InitTemplateServiceHelper;
import kd.hrmp.hric.bussiness.service.MidTableAutoGenerateExecTaskServiceHelper;
import kd.hrmp.hric.common.constants.msg.LogMsgEnum;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.util.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;

public class MidTableGenerateTaskServiceImpl
implements IAsyncTaskService {
    private static Log LOG = LogFactory.getLog(MidTableGenerateTaskServiceImpl.class);
    private IMidTableDomainService iInitMidTableDomainService = ServiceFactory.getService(IMidTableDomainService.class);
    private IDataClearEntityService iDataClearEntityService = ServiceFactory.getService(IDataClearEntityService.class);
    private IInitTemplateDomainService iInitTemplateDomainService = ServiceFactory.getService(IInitTemplateDomainService.class);

    public void doGenerate(long id) {
        if (this.iDataClearEntityService.isMetadataClear()) {
            LOG.info(LogMsgEnum.DATA_CLEAR_METADATA_CLEAR.getMsg());
            throw new KDHricException(LogMsgEnum.DATA_CLEAR_METADATA_CLEAR.getMsg());
        }
        DynamicObject[] dynamicObjects = MidTableAutoGenerateExecTaskServiceHelper.getNeedGenerateMiddleTableInfo(Lists.newArrayList((Object[])new Long[]{id}));
        DynamicObject dynamicObject = dynamicObjects[0];
        List<String> errorMsgList = this.iInitMidTableDomainService.generate(dynamicObject);
        if (CollectionUtils.isNotEmpty(errorMsgList)) {
            LOG.warn(ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6210\u7f13\u5b58\u8868\u3002\u539f\u56e0\uff1a\u201c{}\u201d\u3002", (String)"MidTableAutoGenerateExecTask_1", (String)"hrmp-hric-business", (Object[])new Object[0]), errorMsgList);
            throw new KDHricException(Joiner.on((String)",").join(errorMsgList));
        }
        new InitTemplateServiceHelper().generateInitImportTemplate(dynamicObject);
        dynamicObject.set("generatetabletime", (Object)new Date());
        dynamicObject.set("modifytime", dynamicObject.get("generatetabletime"));
        new HRBaseServiceHelper("hric_initinducttp").saveOne(dynamicObject);
        if (dynamicObject.getBoolean("ispublish")) {
            this.iInitTemplateDomainService.publishOpenApiDyn((Set<Long>)ImmutableSet.of((Object)dynamicObject.getLong("id")));
        }
    }

    @Override
    public boolean exec(Map<String, Object> paramMap) {
        this.doGenerate(ConvertUtils.toLong((Object)paramMap.get("templateId")));
        return true;
    }
}

