/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.loop;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.hric.bussiness.service.loop.LinkedNode;
import kd.hrmp.hric.bussiness.service.loop.Node;
import org.apache.commons.lang3.StringUtils;

public class GraphLoopNodeCheck {
    private static Log LOG = LogFactory.getLog(GraphLoopNodeCheck.class);

    public static Map<String, List<Node>> findLoopTopNodeMap(List<? extends LinkedNode> list) {
        MutableGraph<String> graph = GraphLoopNodeCheck.buildGraph(list);
        MutableGraph graphCopy = Graphs.copyOf(graph);
        Queue<String> loopQueue = GraphLoopNodeCheck.getLoopNode(graph);
        HashMap nodeMap = Maps.newHashMap();
        GraphLoopNodeCheck.addTreeNodeList(loopQueue, (Graph<String>)graphCopy, nodeMap);
        LOG.info("node map info : {}", (Object)nodeMap);
        return nodeMap;
    }

    private static Queue<String> getLoopNode(MutableGraph<String> graph) {
        LinkedList loopQueue = Lists.newLinkedList();
        LinkedList visited = Lists.newLinkedList();
        LinkedList topQueue = Lists.newLinkedList();
        LinkedList nodeQueue = Lists.newLinkedList();
        nodeQueue.addAll(graph.nodes());
        while (!nodeQueue.isEmpty()) {
            String node = (String)nodeQueue.poll();
            if (graph.inDegree((Object)node) == 0) {
                graph.removeNode((Object)node);
                topQueue.offer(node);
                continue;
            }
            nodeQueue.offer(node);
            if (!visited.contains(node)) {
                visited.offer(node);
                continue;
            }
            nodeQueue.remove(node);
            graph.removeNode((Object)node);
            loopQueue.add(node);
        }
        return loopQueue;
    }

    public static Set<Node> findLoopNode(List<? extends LinkedNode> list) {
        HashSet nodeSet = Sets.newHashSet();
        ArrayList nodeList = Lists.newArrayList();
        Map<String, List<Node>> loopTopNodeMap = GraphLoopNodeCheck.findLoopTopNodeMap(list);
        loopTopNodeMap.forEach((key, value) -> {
            Map nodeMap = value.stream().collect(Collectors.toMap(Node::getId, Function.identity()));
            for (int index = 0; index < value.size(); ++index) {
                Node node = (Node)value.get(index);
                node.setPreNode((LinkedNode)nodeMap.get(node.getParentId()));
            }
            for (Node node : value) {
                HashSet subNodeSet;
                ArrayList subNodeList;
                if (!GraphLoopNodeCheck.findLoopNodeByLinkedNode(node, subNodeList = Lists.newArrayList(), subNodeSet = Sets.newHashSet(), nodeSet)) continue;
                nodeList.addAll(subNodeList);
                nodeSet.addAll(subNodeList);
            }
        });
        LOG.info("loop node info: {}", (Object)nodeList);
        return nodeSet;
    }

    private static boolean findLoopNodeByLinkedNode(LinkedNode node, List<Node> subNodeList, Set<Node> subNodeSet, Set<Node> nodeSet) {
        if (nodeSet.contains(node) || Objects.isNull(node)) {
            return false;
        }
        if (subNodeSet.contains(node)) {
            return true;
        }
        subNodeList.add((Node)node);
        subNodeSet.add((Node)node);
        return GraphLoopNodeCheck.findLoopNodeByLinkedNode(node.getPreNode(), subNodeList, subNodeSet, nodeSet);
    }

    private static void addTreeNodeList(Queue<String> loopQueue, Graph<String> graphCopy, Map<String, List<Node>> nodeMap) {
        while (!loopQueue.isEmpty()) {
            String node = loopQueue.poll();
            ArrayList nodeList = Lists.newArrayList();
            GraphLoopNodeCheck.addLinkedNodeList(node, graphCopy, nodeList, Sets.newHashSet());
            nodeMap.put(node, nodeList);
        }
    }

    private static boolean addLinkedNodeList(String node, Graph<String> graphCopy, List<Node> list, Set<String> nodeSet) {
        if (nodeSet.contains(node)) {
            return true;
        }
        Set successors = graphCopy.successors((Object)node);
        if (!successors.isEmpty()) {
            for (String successor : successors) {
                nodeSet.add(node);
                if (!GraphLoopNodeCheck.addLinkedNodeList(successor, graphCopy, list, nodeSet)) continue;
                list.add(new Node(node, successor));
                return true;
            }
        }
        return false;
    }

    private static MutableGraph<String> buildGraph(List<? extends LinkedNode> list) {
        MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(true).build();
        list.forEach(it -> {
            if (StringUtils.isNotEmpty((CharSequence)it.getParentId())) {
                graph.putEdge((Object)it.getParentId(), (Object)it.getId());
            }
        });
        return graph;
    }
}

