/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.mq;

import java.io.IOException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.InitExecTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.back.CallbackHandleFactory;
import kd.hrmp.hric.bussiness.service.back.ICallbackHandle;
import kd.hrmp.hric.common.util.HricCacheUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;

public class InitResultCallbackConsumer
implements MessageConsumer {
    private static Log LOG = LogFactory.getLog(InitResultCallbackConsumer.class);

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        InitOutParam initOutParam = this.parseBody(body);
        if (initOutParam == null) {
            LOG.error("parseBody Error, discard message, messageId:{}, body:{}", body);
            acker.discard(messageId);
            return;
        }
        LOG.info("init_processing_message, messageId:{}, resend:{}, execTaskId:{}", new Object[]{messageId, resend, initOutParam.getExecTaskId()});
        try (DLock dLock = DLock.create((String)this.getDLockKey(initOutParam));){
            dLock.lock();
            if (!this.doHandle(initOutParam, acker, messageId, body)) {
                LOG.warn("discard messageId : {}", (Object)messageId);
                acker.discard(messageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doHandle(InitOutParam initOutParam, MessageAcker acker, String messageId, Object body) {
        if (!initOutParam.isSuccess()) {
            this.handleBizException(initOutParam, this.getBizSubAreaName(initOutParam));
            return true;
        }
        if (!this.saveRtnMsg(initOutParam, body)) {
            return true;
        }
        ICallbackHandle callbackHandle = CallbackHandleFactory.getCallbackHandle(initOutParam);
        boolean success = true;
        TXHandle required = TX.required();
        try {
            boolean bl = callbackHandle.handle();
            return bl;
        }
        catch (Throwable ex) {
            LOG.error("handle callback error, messageId: {}", (Object)messageId, (Object)ex);
            success = false;
            required.markRollback();
        }
        finally {
            required.close();
            if (success) {
                callbackHandle.getExecTaskCacheHandleList().forEach(execTaskCacheInfo -> execTaskCacheInfo.refreshCache());
            }
        }
        return false;
    }

    private String getBizSubAreaName(InitOutParam initOutParam) {
        Long batchNumber = initOutParam.getBatchNumber();
        DynamicObject task = InitTaskServiceHelper.getTask(batchNumber);
        if (task == null) {
            return "";
        }
        DynamicObject implItemRel = task.getDynamicObject("implitemrel");
        if (implItemRel == null) {
            return "";
        }
        DynamicObject bizSubArea = implItemRel.getDynamicObject("bizsubarea");
        if (bizSubArea == null) {
            return "";
        }
        return bizSubArea.getLocaleString("name").getLocaleValue();
    }

    private boolean saveRtnMsg(InitOutParam initOutParam, Object body) {
        try {
            Long batchNumber = InitExecTaskServiceHelper.saveRtnMsg(initOutParam.getExecTaskId(), body);
            HricCacheUtils.remove((String)("transaction_detail_sign" + batchNumber));
        }
        catch (Exception ex) {
            initOutParam.getExtendMap().put("errorMsg", ex.getMessage());
            this.handleBizException(initOutParam, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4e2d\u5fc3", (String)"InitResultCallbackConsumer_1", (String)"hrmp-hric-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void handleBizException(InitOutParam initOutParam, String bizAreaName) {
        LOG.warn(ResManager.loadKDString((String)"\u4e1a\u52a1\u4fa7\u5f02\u5e38\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u201c{}\u201d\u3002", (String)"InitResultCallbackConsumer_0", (String)"hrmp-hric-business", (Object[])new Object[0]), initOutParam.getExtendMap().get("errorMsg"));
        DynamicObject task = new HRBaseServiceHelper("hric_exectask").queryOne("id, taskstatus, result, result_tag, batchnumber,errorsource", new QFilter("id", "=", (Object)initOutParam.getExecTaskId()).toArray());
        HricDynamicObjectUtils.setBigText((DynamicObject)task, (String)"result", (String)this.getErrorMsg(initOutParam));
        task.set("taskstatus", (Object)"G");
        HricCacheUtils.put((String)("transaction_detail_sign" + task.getLong("batchnumber")), (Object)0L);
        task.set("errorsource", (Object)bizAreaName);
        new HRBaseServiceHelper("hric_exectask").save(new DynamicObject[]{task});
    }

    private String getErrorMsg(InitOutParam initOutParam) {
        StringBuilder sb = new StringBuilder("traceId:");
        sb.append(RequestContext.get().getTraceId()).append('\n');
        sb.append((String)initOutParam.getExtendMap().get("errorMsg"));
        return sb.toString();
    }

    protected String getDLockKey(InitOutParam initOutParam) {
        return CacheKeyUtil.getAcctId() + "init_task_handle_callback_" + initOutParam.getBatchNumber();
    }

    private InitOutParam parseBody(Object body) {
        try {
            String content = (String)body;
            if (HRStringUtils.isNotEmpty((String)content)) {
                if (content.length() > 200) {
                    LOG.info("message_body_{}", (Object)content.substring(0, 200));
                } else {
                    LOG.info("message_body_{}", (Object)content);
                }
            }
            return (InitOutParam)JSONUtils.cast((String)content, InitOutParam.class);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
            return null;
        }
    }
}

