/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.processing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.InitExecTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.processing.IProcessingService;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.bean.vo.TaskProcessingVO;

public abstract class AbstractProcessingCacheService
implements IProcessingService {
    private static Log LOG = LogFactory.getLog(AbstractProcessingCacheService.class);
    private DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private static final String TASK_INFO = "taskinfo";
    private static final String FINISH_COUNT = "finishcount";
    private static final String TASK_PROCESSING_KEY = "_appcache_task_processing_";
    private static final Set<OperateEnum> PAGE_OPERATE_SET = ImmutableSet.of((Object)OperateEnum.INITCHECK, (Object)OperateEnum.CHECK, (Object)OperateEnum.SYNC);

    @Override
    public TaskProcessingVO get(long taskId) {
        if (taskId == 0L) {
            return TaskProcessingVO.getInstance();
        }
        return this.getProcessingInfoFromCache(taskId);
    }

    @Override
    public void clearCache(long taskId) {
        LOG.info("clear_cache_start: {}", (Object)taskId);
        try (DLock dLock = DLock.create((String)AbstractProcessingCacheService.getKey(taskId, TASK_INFO));){
            dLock.lock();
            this.cache.remove(AbstractProcessingCacheService.getKey(taskId, TASK_INFO));
            this.cache.remove(AbstractProcessingCacheService.getKey(taskId, FINISH_COUNT));
        }
    }

    @Override
    public void refreshFinishCountInCache(long taskId, long count) {
        String finishCountStr = (String)this.cache.get(AbstractProcessingCacheService.getKey(taskId, FINISH_COUNT));
        long totalCount = 0L;
        if (HRStringUtils.isEmpty((String)finishCountStr)) {
            TaskProcessingVO taskProcessingVO = this.getProcessingInfoFromCache(taskId);
            totalCount = taskProcessingVO.getFinishCount();
            this.cache.put(AbstractProcessingCacheService.getKey(taskId, FINISH_COUNT), (Object)String.valueOf(totalCount));
            LOG.info("update cache from db, taskId: {}, count: {}, totalCount: {}", new Object[]{taskId, count, totalCount});
        } else {
            totalCount = this.cache.incrBy(AbstractProcessingCacheService.getKey(taskId, FINISH_COUNT), (int)count);
            LOG.info("update cache , taskId: {}, count: {}, totalCount: {}", new Object[]{taskId, count, totalCount});
        }
        this.cache.expireAfter(AbstractProcessingCacheService.getKey(taskId, FINISH_COUNT), 100);
    }

    private TaskProcessingVO getProcessingInfoFromCache(long taskId) {
        String taskInfoStr = (String)this.cache.get(AbstractProcessingCacheService.getKey(taskId, TASK_INFO));
        if (HRStringUtils.isEmpty((String)taskInfoStr)) {
            taskInfoStr = this.getTaskInfo(taskId);
            if (HRStringUtils.isEmpty((String)taskInfoStr)) {
                LOG.info(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\u3002", (String)"AbstractProcessingCacheService_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
                return TaskProcessingVO.getInstance();
            }
            try (DLock dLock = DLock.create((String)AbstractProcessingCacheService.getKey(taskId, TASK_INFO));){
                if (dLock.tryLock()) {
                    LOG.info("put cache success, taskId: {} ", (Object)taskId);
                    this.cache.put(AbstractProcessingCacheService.getKey(taskId, TASK_INFO), (Object)taskInfoStr);
                    this.cache.expireAfter(AbstractProcessingCacheService.getKey(taskId, TASK_INFO), 100);
                }
            }
        }
        Map<String, String> taskInfoMap = this.parseTask(taskInfoStr);
        long finishCount = this.getFinishCount(taskId, taskInfoMap);
        Long totalCount = Long.valueOf(taskInfoMap.get("count"));
        OperateEnum operateEnum = OperateEnum.getOperateEnumByOperateType((String)taskInfoMap.get("operatetype"));
        return TaskProcessingVO.getInstance((Long)totalCount, (Long)finishCount, (OperateEnum)operateEnum);
    }

    protected Long getFinishCount(long taskId, Map<String, String> taskInfoMap) {
        String finishCountStr = (String)this.cache.get(AbstractProcessingCacheService.getKey(taskId, FINISH_COUNT));
        OperateEnum operateEnum = OperateEnum.getOperateEnumByOperateType((String)taskInfoMap.get("operatetype"));
        if (HRStringUtils.isEmpty((String)finishCountStr)) {
            if (PAGE_OPERATE_SET.contains(operateEnum)) {
                Long pid = Long.valueOf(taskInfoMap.get("pid"));
                return InitExecTaskServiceHelper.getFinishCountByPid(pid);
            }
            return 0L;
        }
        return Long.valueOf(finishCountStr);
    }

    protected Map<String, String> parseTask(String taskInfoStr) {
        try {
            return (Map)HRJSONUtils.cast((String)taskInfoStr, Map.class);
        }
        catch (IOException ex) {
            LOG.error("json convert error", (Throwable)ex);
            return Maps.newHashMap();
        }
    }

    protected abstract String getTaskInfo(long var1);

    private static String getKey(long taskId, String key) {
        return CacheKeyUtil.getAcctId() + "." + TASK_PROCESSING_KEY + key + "_" + taskId;
    }
}

