/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.processing;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.DiExecTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.processing.WrapperProcessingService;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.bean.vo.TaskProcessingVO;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.util.ConvertUtils;

public class IscbProcessingServiceImpl
extends WrapperProcessingService {
    private static final String STATE = "state";
    private static Log LOG = LogFactory.getLog(IscbProcessingServiceImpl.class);
    private static List<String> SERVICEPROCESS_ENDING = ImmutableList.of((Object)"Failed", (Object)"Complete", (Object)"Terminated", (Object)"Ignored");

    @Override
    public TaskProcessingVO get(long taskId) {
        TaskProcessingVO vo = Optional.ofNullable(this.processingService).map(it -> it.get(taskId)).orElseGet(() -> TaskProcessingVO.getInstance());
        if (!Objects.isNull(vo) && vo.isProcessing()) {
            return vo;
        }
        DynamicObject dyc = DiExecTaskServiceHelper.getExecTaskByInitTaskId(taskId);
        if (Objects.isNull(dyc)) {
            return TaskProcessingVO.getInstance();
        }
        String diType = dyc.getString("ditype");
        String diNumber = dyc.getString("dinumber");
        if (HRStringUtils.equals((String)diType, (String)"isc_data_copy_trigger")) {
            return this.handleStartupScheme(diNumber);
        }
        if (HRStringUtils.equals((String)diType, (String)"isc_service_flow")) {
            return this.handleServiceFlow(diNumber);
        }
        return TaskProcessingVO.getInstance();
    }

    private TaskProcessingVO handleStartupScheme(String diNumber) {
        Map executeResult = (Map)HRMServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"getExecutionState", (Object[])new Object[]{diNumber});
        long totalCount = this.handleCount(executeResult.get("total_count"));
        long successCount = this.handleCount(executeResult.get("success_count"));
        long failedCount = this.handleCount(executeResult.get("failed_count"));
        long ignoredCount = this.handleCount(executeResult.get("ignored_count"));
        long finishCount = failedCount + ignoredCount + successCount;
        String state = (String)executeResult.get(STATE);
        return TaskProcessingVO.getInstance((Long)totalCount, (Long)finishCount, (OperateEnum)OperateEnum.SOURCESYSDI, (String)state, (String)"isc_data_copy_trigger");
    }

    private TaskProcessingVO handleServiceFlow(String diNumber) {
        try {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"getState", (Object[])new Object[]{Long.parseLong(diNumber)});
            String status = (String)result.get(STATE);
            if (SERVICEPROCESS_ENDING.contains(status)) {
                return TaskProcessingVO.getInstance((Long)AppConstants.LONG_ONE, (Long)AppConstants.LONG_ONE, (OperateEnum)OperateEnum.SOURCESYSDI, (String)status, (String)"isc_service_flow");
            }
            return TaskProcessingVO.getInstance((Long)AppConstants.LONG_ONE, (Long)0L, (OperateEnum)OperateEnum.SOURCESYSDI, (String)status, (String)"isc_service_flow");
        }
        catch (Exception e) {
            LOG.error("[HRIC]ServiceFlow execution exception,case:", (Throwable)e);
            return TaskProcessingVO.getInstance((Long)AppConstants.LONG_ONE, (Long)AppConstants.LONG_ONE, (OperateEnum)OperateEnum.SOURCESYSDI, (String)"Failed", (String)"isc_service_flow");
        }
    }

    private long handleCount(Object count) {
        Long l = ConvertUtils.toLong((Object)count);
        if (l <= 0L) {
            return 0L;
        }
        return l;
    }
}

