/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.processing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hrmp.hric.bussiness.service.processing.ITaskService;

public class MQTaskServiceImpl
implements ITaskService {
    private static Log LOG = LogFactory.getLog(MQTaskServiceImpl.class);
    private static final List<String> PROCESSING_STATUS = ImmutableList.of((Object)"A", (Object)"G");
    private long taskId;
    private DynamicObject dynamicObject;

    public MQTaskServiceImpl(long taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getTaskInfo() {
        this.initTask();
        if (Objects.isNull(this.dynamicObject)) {
            return null;
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("operatetype", this.dynamicObject.getString("operatetype"));
        paramMap.put("pid", this.dynamicObject.getString("id"));
        paramMap.put("count", this.dynamicObject.getString("count"));
        try {
            return HRJSONUtils.toString((Object)paramMap);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
            return null;
        }
    }

    private void initTask() {
        QFilter batchNumberFilter = new QFilter("batchnumber", "=", (Object)this.taskId);
        QFilter statusFilter = new QFilter("taskstatus", "in", PROCESSING_STATUS);
        QFilter pidFilter = new QFilter("pid", "=", (Object)0L);
        this.dynamicObject = new HRBaseServiceHelper("hric_exectask").loadDynamicObject(batchNumberFilter.and(statusFilter).and(pidFilter));
    }

    @Override
    public String getFinishCount() {
        this.initTask();
        if (Objects.isNull(this.dynamicObject)) {
            return null;
        }
        QFilter qFilter = new QFilter("pid", "=", (Object)this.dynamicObject.getLong("id"));
        Object[] dys = new HRBaseServiceHelper("hric_exectask").query("count", qFilter.toArray());
        long count = 0L;
        if (!HRArrayUtils.isEmpty((Object[])dys)) {
            for (Object dy : dys) {
                count += dy.getLong("count");
            }
        }
        return String.valueOf(count);
    }
}

