/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.processing;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IExecTaskEntityService;
import kd.hrmp.hric.bussiness.service.InitMidTableServiceHelper;
import kd.hrmp.hric.bussiness.service.impl.InitExecTaskServiceImpl;
import kd.hrmp.hric.bussiness.service.processing.IOperateResultService;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.bean.TaskInfo;
import kd.hrmp.hric.common.bean.vo.OperateResultCountVO;
import kd.hrmp.hric.common.util.ConvertUtils;

public class OperateResultServiceImpl
implements IOperateResultService {
    private long currentTotalCount;
    private long currentSuccessCount;
    private long currentFailCount;
    private long currentDiscardCount;
    private long totalSuccessCount;
    private OperateEnum operateEnum;
    private String midTableNumber;
    private long taskId;
    private DynamicObject execTask;
    private TaskInfo taskInfo;
    private IExecTaskEntityService iExecTaskEntityService = ServiceFactory.getService(IExecTaskEntityService.class);

    @Override
    public OperateResultCountVO getOperateResult(long taskId) {
        return this.buildOperateResultCountVO(taskId);
    }

    private OperateResultCountVO buildOperateResultCountVO(long taskId) {
        this.init(taskId);
        this.setTotalSuccessCount();
        this.setCurrentOperateCount();
        return new OperateResultCountVO(this.currentTotalCount, this.currentSuccessCount, this.currentFailCount, this.currentDiscardCount, this.totalSuccessCount, this.operateEnum, this.taskInfo);
    }

    private void init(long taskId) {
        this.taskId = taskId;
        this.execTask = this.iExecTaskEntityService.getInitExecTaskByTaskId(taskId);
        this.currentTotalCount = this.execTask.getInt("count");
        this.operateEnum = OperateEnum.getOperateEnumByOperateType((String)this.execTask.getString("operatetype"));
        this.taskInfo = new InitExecTaskServiceImpl().parseTaskInfo(this.execTask);
        this.midTableNumber = this.taskInfo.getMidTableNumber();
    }

    private void setCurrentOperateCount() {
        QFilter groupByFilter = new QFilter("hrictaskid", "=", (Object)this.taskId);
        String midTableIds = this.execTask.getString("midtableids");
        if (this.operateEnum == OperateEnum.ROLLBACK && HRStringUtils.isNotEmpty((String)midTableIds)) {
            Set midTableIdSet = ConvertUtils.convertIdStringToLongSet((String)midTableIds, (String)",");
            groupByFilter.and(new QFilter("id", "in", (Object)midTableIdSet));
        } else {
            groupByFilter.and(new QFilter("id", ">=", (Object)this.taskInfo.getStartId())).and(new QFilter("id", "<=", (Object)this.taskInfo.getEndId()));
        }
        HashSet statusList = Sets.newHashSet((Object[])new String[]{this.operateEnum.getSuccessStatus(), this.operateEnum.getErrorStatus()});
        statusList.addAll(this.operateEnum.getHandleStatusList());
        groupByFilter.and(new QFilter("initstatus", "in", (Object)statusList));
        Map<String, Long> countResult = InitMidTableServiceHelper.queryCountGroupByStatus(this.midTableNumber, groupByFilter);
        this.currentSuccessCount = Optional.ofNullable(countResult.get(this.operateEnum.getSuccessStatus())).orElseGet(() -> 0L);
        this.currentFailCount = Optional.ofNullable(countResult.get(this.operateEnum.getErrorStatus())).orElseGet(() -> 0L);
        this.currentDiscardCount = this.operateEnum.getHandleStatusList().stream().mapToLong(currentStatus -> Optional.ofNullable(countResult.get(currentStatus)).orElse(0L)).sum();
        this.rollbackHandle(midTableIds);
    }

    private void rollbackHandle(String midTableIds) {
        if (this.operateEnum == OperateEnum.ROLLBACK) {
            if ("C".equals(this.execTask.getString("taskstatus"))) {
                this.currentFailCount = this.currentDiscardCount;
                this.currentDiscardCount = 0L;
                if (HRStringUtils.isEmpty((String)midTableIds)) {
                    this.currentSuccessCount = this.currentTotalCount - this.currentFailCount;
                }
            } else if ("H".equals(this.execTask.getString("taskstatus"))) {
                this.currentFailCount = 0L;
                this.currentDiscardCount = this.currentTotalCount;
                this.currentSuccessCount = 0L;
            }
        }
    }

    private void setTotalSuccessCount() {
        QFilter totalFilter = new QFilter("hrictaskid", "=", (Object)this.taskId);
        QFilter totalSuccessFilter = totalFilter.and(new QFilter("initstatus", "=", (Object)this.operateEnum.getSuccessStatus()));
        this.totalSuccessCount = InitMidTableServiceHelper.queryCount(this.midTableNumber, totalSuccessFilter.toArray());
    }
}

