/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.task.async;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.ComboProp;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.bussiness.service.ICallbackTaskService;
import kd.hrmp.hric.bussiness.service.InitDataStatisticsServiceHelper;
import kd.hrmp.hric.bussiness.service.InitExecTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskCountServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.MessageSendServiceHelper;
import kd.hrmp.hric.bussiness.service.processing.ProcessingServiceFactory;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.bean.InitMessageInfo;
import kd.hrmp.hric.common.bean.vo.OperateResultCountVO;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.DateUtils;

public class MiddleTableOperationCallBackServiceImpl
implements ICallbackTaskService {
    private String MESSAGE_TAG = ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb!", (String)"MiddleTableOperationCallBackServiceImpl_0", (String)"hrmp-hric-business", (Object[])new Object[0]);

    @Override
    public void exec(Long callbackInfoId, Map<String, Object> paramMap) {
        this.execOpInfo(ConvertUtils.toLong((Object)paramMap.get("taskId")));
    }

    @Override
    public void execExp(Long callbackInfoId, Map<String, Object> paramMap) {
        this.execOpInfo(ConvertUtils.toLong((Object)paramMap.get("taskId")));
    }

    private void execOpInfo(long taskId) {
        OperateResultCountVO operateResultCountVO = ProcessingServiceFactory.getOperateResultService().getOperateResult(taskId);
        String type = operateResultCountVO.getOperateEnum().getOperateType();
        if (HRStringUtils.equals((String)type, (String)OperateEnum.INITCHECK.getOperateType()) || HRStringUtils.equals((String)type, (String)OperateEnum.CHECK.getOperateType()) || HRStringUtils.equals((String)type, (String)OperateEnum.SYNC.getOperateType())) {
            this.saveOrUpdateTaskOpCount(operateResultCountVO, taskId);
            if (!HRStringUtils.equals((String)type, (String)OperateEnum.INITCHECK.getOperateType())) {
                this.saveOrUpdateDataStatistics(operateResultCountVO, taskId);
                this.checkCostTimeAndSendMessage(operateResultCountVO, taskId);
            }
        }
        if (HRStringUtils.equals((String)type, (String)OperateEnum.ROLLBACK.getOperateType())) {
            this.saveOrUpdateTaskOpCount(taskId);
        }
    }

    private void saveOrUpdateTaskOpCount(OperateResultCountVO operateResultCountVO, long taskId) {
        DynamicObject taskOpCountObj = InitTaskCountServiceHelper.getByTaskId(taskId);
        if (HRObjectUtils.isEmpty((Object)taskOpCountObj)) {
            taskOpCountObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_taskopcount"));
            taskOpCountObj.set("inittaskid", (Object)taskId);
            taskOpCountObj.set(this.getCurrentOp(operateResultCountVO), (Object)1);
        } else {
            taskOpCountObj.set(this.getCurrentOp(operateResultCountVO), (Object)(taskOpCountObj.getInt(this.getCurrentOp(operateResultCountVO)) + 1));
        }
        InitTaskCountServiceHelper.saveOne(taskOpCountObj);
    }

    private String getCurrentOp(OperateResultCountVO operateResultCountVO) {
        boolean flag;
        String result = "";
        String opType = operateResultCountVO.getOperateEnum().getBtnKey();
        boolean bl = flag = operateResultCountVO.getCurrentTotalCount() == operateResultCountVO.getCurrentSuccessCount();
        if (HRStringUtils.equals((String)opType, (String)OperateEnum.INITCHECK.getBtnKey()) && flag) {
            result = "initchecksucccount";
        } else if (HRStringUtils.equals((String)opType, (String)OperateEnum.INITCHECK.getBtnKey()) && !flag) {
            result = "initcheckfailcount";
        } else if (HRStringUtils.equals((String)opType, (String)OperateEnum.CHECK.getBtnKey()) && flag) {
            result = "bizchecksucccount";
        } else if (HRStringUtils.equals((String)opType, (String)OperateEnum.CHECK.getBtnKey()) && !flag) {
            result = "bizcheckfailcount";
        } else if (HRStringUtils.equals((String)opType, (String)OperateEnum.SYNC.getBtnKey()) && flag) {
            result = "syncdatasucccount";
        } else if (HRStringUtils.equals((String)opType, (String)OperateEnum.SYNC.getBtnKey()) && !flag) {
            result = "syncdatafailcount";
        }
        return result;
    }

    private void saveOrUpdateDataStatistics(OperateResultCountVO operateResultCountVO, long taskId) {
        DynamicObject execTask = InitExecTaskServiceHelper.getInitExecTaskByTaskId(taskId);
        Date startTime = execTask.getDate("taskstarttime");
        Date endTime = Optional.ofNullable(execTask.getDate("lastretrytime")).orElseGet(() -> execTask.getDate("taskendtime"));
        if (null == endTime) {
            endTime = new Date();
        }
        long min = DateUtils.getSubMilliSecond((Date)startTime, (Date)endTime) > 0L ? DateUtils.getSubMilliSecond((Date)startTime, (Date)endTime) : 0L;
        BigDecimal resultMin = new BigDecimal(min).divide(new BigDecimal(1000), 3, 4);
        DynamicObject dataStatistics = InitDataStatisticsServiceHelper.getByTaskId(taskId);
        if (HRObjectUtils.isEmpty((Object)dataStatistics)) {
            dataStatistics = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_datastatistics"));
            DynamicObject task = InitTaskServiceHelper.getTask(taskId);
            dataStatistics.set("inittaskid", (Object)taskId);
            dataStatistics.set("entityobjscope", (Object)Optional.ofNullable(task.getDynamicObject("implitemrel").getDynamicObject("entityobjscope").getString("number")).orElseGet(() -> null));
            dataStatistics.set("amount", (Object)(HRStringUtils.equals((String)operateResultCountVO.getOperateEnum().getBtnKey(), (String)OperateEnum.SYNC.getBtnKey()) ? operateResultCountVO.getCurrentSuccessCount() : 0L));
            dataStatistics.set(HRStringUtils.equals((String)operateResultCountVO.getOperateEnum().getBtnKey(), (String)OperateEnum.SYNC.getBtnKey()) ? "synchronizedatatime" : "businesschecktime", (Object)resultMin);
        } else {
            dataStatistics.set("amount", (Object)(HRStringUtils.equals((String)operateResultCountVO.getOperateEnum().getBtnKey(), (String)OperateEnum.SYNC.getBtnKey()) ? dataStatistics.getLong("amount") + operateResultCountVO.getCurrentSuccessCount() : dataStatistics.getLong("amount")));
            dataStatistics.set(HRStringUtils.equals((String)operateResultCountVO.getOperateEnum().getBtnKey(), (String)OperateEnum.SYNC.getBtnKey()) ? "synchronizedatatime" : "businesschecktime", (Object)(HRStringUtils.equals((String)operateResultCountVO.getOperateEnum().getBtnKey(), (String)OperateEnum.SYNC.getBtnKey()) ? Optional.ofNullable(dataStatistics.getBigDecimal("synchronizedatatime")).orElseGet(() -> new BigDecimal(0L)).add(resultMin) : Optional.ofNullable(dataStatistics.getBigDecimal("businesschecktime")).orElseGet(() -> new BigDecimal(0L)).add(resultMin)));
        }
        InitDataStatisticsServiceHelper.saveOne(dataStatistics);
    }

    private void checkCostTimeAndSendMessage(OperateResultCountVO operateResultCountVO, long taskId) {
        long min;
        BigDecimal resultMin;
        DynamicObject execTask = InitExecTaskServiceHelper.getInitExecTaskByTaskId(taskId);
        DynamicObject task = InitTaskServiceHelper.getTask(taskId);
        Date startTime = execTask.getDate("taskstarttime");
        Date endTime = Optional.ofNullable(execTask.getDate("lastretrytime")).orElseGet(() -> execTask.getDate("taskendtime"));
        if (endTime == null) {
            endTime = new Date();
        }
        if ((resultMin = new BigDecimal(min = DateUtils.getSubMilliSecond((Date)startTime, (Date)endTime).longValue()).divide(new BigDecimal(60000), 0, 1)).compareTo(new BigDecimal(BaseConfigServiceHelper.get("max.cost.time"))) >= 0) {
            ArrayList<InitMessageInfo> infoList = new ArrayList<InitMessageInfo>(AppConstants.LIST_SIZE);
            String opType = ((ComboProp)execTask.getDynamicObjectType().getProperty("operatetype")).getItemByName(execTask.getString("operatetype"));
            InitMessageInfo info = MessageSendServiceHelper.buildTaskMessage(task, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4efb\u52a1\u64cd\u4f5c\u5b8c\u6210\u63d0\u9192", (String)"MiddleTableOperationCallBackServiceImpl_1", (String)"hrmp-hric-business", (Object[])new Object[0]), this.MESSAGE_TAG, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u5728%1$s\u8fdb\u884c\u7684%2$s\u64cd\u4f5c\u5df2\u7ecf\u5b8c\u6210\uff0c\u5171\u8017\u65f6%3$s\u5206\u949f\uff0c\u8bf7\u524d\u53bb\u7ee7\u7eed\u5904\u7406; \u672c\u6b21\u64cd\u4f5c%4$s\u6210\u529f%5$s\u6761\uff0c%6$s\u5931\u8d25%7$s\u6761\u3002", (String)"MiddleTableOperationCallBackServiceImpl_2", (String)"hrmp-hric-business", (Object[])new Object[0]), task.getString("name"), opType, new BigDecimal(min).divide(new BigDecimal(60000), 0, 4), opType, operateResultCountVO.getCurrentSuccessCount(), opType, operateResultCountVO.getCurrentFailCount()));
            info.addMessageChannel("mcenter");
            infoList.add(info);
            MessageSendServiceHelper.saveMessage(infoList);
            AsyncTaskServiceHelper.startJob();
        }
    }

    private void saveOrUpdateTaskOpCount(long taskId) {
        DynamicObject taskOpCountObj = InitTaskCountServiceHelper.getByTaskId(taskId);
        if (HRObjectUtils.isEmpty((Object)taskOpCountObj)) {
            taskOpCountObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_taskopcount"));
            taskOpCountObj.set("inittaskid", (Object)taskId);
            taskOpCountObj.set("rollbackcount", (Object)1);
        } else {
            taskOpCountObj.set("rollbackcount", (Object)(taskOpCountObj.getInt("rollbackcount") + 1));
        }
        InitTaskCountServiceHelper.saveOne(taskOpCountObj);
        DynamicObject dataStatistics = InitDataStatisticsServiceHelper.getByTaskId(taskId);
        if (!HRObjectUtils.isEmpty((Object)dataStatistics)) {
            dataStatistics.set("amount", (Object)0L);
            dataStatistics.set("synchronizedatatime", (Object)0L);
            dataStatistics.set("businesschecktime", (Object)0L);
            InitDataStatisticsServiceHelper.saveOne(dataStatistics);
        }
    }
}

