/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.task.distribute;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.InitMidTableServiceHelper;
import kd.hrmp.hric.bussiness.service.impl.InitExecTaskServiceImpl;
import kd.hrmp.hric.common.bean.TaskInfo;
import kd.hrmp.hric.common.exception.KDHricException;

public class DistributeExecTaskService {
    private static Log LOG = LogFactory.getLog(DistributeExecTaskService.class);
    private Set<String> billHeadBizKeySet;
    private Set<String> billEntryBizKeySet;
    private String businessKey;
    private Set<String> groupByKeySet;
    private String entityCode;
    private TaskInfo parentTaskInfo;
    private DynamicObject pTask;

    public DistributeExecTaskService(TaskInfo parentTaskInfo, DynamicObject pTask) {
        this.entityCode = parentTaskInfo.getEntityNumber();
        this.businessKey = parentTaskInfo.getBussinessKey();
        this.groupByKeySet = this.parseGroupByKey(parentTaskInfo.getGroupByKey());
        this.pTask = pTask;
        this.parentTaskInfo = parentTaskInfo;
        this.init();
    }

    private Set<String> parseGroupByKey(String groupByKey) {
        if (HRStringUtils.isNotEmpty((String)groupByKey)) {
            return Splitter.on((String)"|").trimResults().splitToStream((CharSequence)groupByKey).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }

    private void init() {
        this.parentTaskInfo = new InitExecTaskServiceImpl().parseTaskInfo(this.pTask);
        this.billHeadBizKeySet = InitMidTableServiceHelper.getBillHeadNumberAlias(this.parentTaskInfo.getMidTableNumber());
        Set businessKeySet = Splitter.on((String)"|").splitToStream((CharSequence)this.businessKey).collect(Collectors.toSet());
        this.billEntryBizKeySet = Sets.difference(businessKeySet, this.billHeadBizKeySet);
    }

    public void addOnOrDistributeTask(List<DynamicObject> actualPageList, DynamicObject[] dynamicObjects, DynamicObject pTask, List<DynamicObject> taskList, boolean lastPage) {
        if (this.billEntryBizKeySet.isEmpty() && this.groupByKeySet.isEmpty()) {
            Stream.of(dynamicObjects).forEach(dy -> actualPageList.add((DynamicObject)dy));
            this.appendTask(actualPageList, pTask, taskList);
        } else if (actualPageList.isEmpty()) {
            Stream.of(dynamicObjects).forEach(dy -> actualPageList.add((DynamicObject)dy));
            if (lastPage) {
                this.appendTask(actualPageList, pTask, taskList);
            }
        } else {
            DynamicObject lastest = actualPageList.get(actualPageList.size() - 1);
            for (DynamicObject dy2 : dynamicObjects) {
                if (this.isInOneGroupEqual(lastest, dy2)) {
                    actualPageList.add(dy2);
                    continue;
                }
                if (actualPageList.size() >= this.parentTaskInfo.getPageSize()) {
                    this.appendTask(actualPageList, pTask, taskList);
                }
                actualPageList.add(dy2);
                lastest = dy2;
            }
            if (lastPage && actualPageList.size() > 0) {
                this.appendTask(actualPageList, pTask, taskList);
            }
        }
    }

    private boolean isInOneGroupEqual(DynamicObject lastest, DynamicObject dy) {
        if (lastest == null) {
            return true;
        }
        if (!this.groupByKeySet.isEmpty()) {
            return this.checkAllFieldEqual(lastest, dy, this.groupByKeySet);
        }
        return this.checkAllFieldEqual(lastest, dy, this.billHeadBizKeySet);
    }

    private boolean checkAllFieldEqual(DynamicObject lastest, DynamicObject dy, Set<String> groupByKeySet) {
        for (String key : groupByKeySet) {
            if (this.checkFieldEqual(lastest, dy, key)) continue;
            return false;
        }
        return true;
    }

    private boolean checkFieldEqual(DynamicObject lastest, DynamicObject dy, String key) {
        Object value = dy.get(key);
        Object lastestValue = lastest.get(key);
        if (value == null && lastestValue == null) {
            return true;
        }
        return Objects.equals(value, lastestValue);
    }

    public void appendTask(long startId, long endId, int count, DynamicObject pTask, List<DynamicObject> taskList) {
        taskList.add(this.buildTask(count, startId, endId, pTask));
    }

    private void appendTask(List<DynamicObject> actualPageList, DynamicObject pTask, List<DynamicObject> taskList) {
        Long startId = actualPageList.get(0).getLong("id");
        Long endId = actualPageList.get(actualPageList.size() - 1).getLong("id");
        DynamicObject task = this.buildTask(actualPageList.size(), startId, endId, pTask);
        taskList.add(task);
        actualPageList.clear();
    }

    public DynamicObject buildTask(int count, long startId, long endId, DynamicObject pTask) {
        DynamicObject dy = new HRBaseServiceHelper("hric_exectask").generateEmptyDynamicObject();
        dy.set("id", (Object)ORM.create().genLongId(dy.getDataEntityType()));
        dy.set("number", (Object)String.valueOf(dy.get("id")));
        dy.set("batchnumber", (Object)pTask.getLong("batchnumber"));
        dy.set("count", (Object)count);
        dy.set("pid", (Object)pTask.getLong("id"));
        dy.set("taskstatus", (Object)"A");
        dy.set("operatetype", pTask.get("operatetype"));
        dy.set("taskstarttime", (Object)new Date());
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setBussinessKey(this.parentTaskInfo.getBussinessKey());
        taskInfo.setStartId(Long.valueOf(startId));
        taskInfo.setEndId(Long.valueOf(endId));
        taskInfo.setQfilter(this.parentTaskInfo.getQfilter());
        taskInfo.setMidTableNumber(this.parentTaskInfo.getMidTableNumber());
        taskInfo.setEntityNumber(this.parentTaskInfo.getEntityNumber());
        try {
            dy.set("taskinfo", (Object)JSONUtils.toString((Object)taskInfo));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            throw new KDHricException(ResManager.loadKDString((String)"\u6784\u5efa\u4efb\u52a1\u5f02\u5e38", (String)"DistributeExecTaskService_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        return dy;
    }
}

