/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.task.exec;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.bussiness.service.InitExecTaskService;
import kd.hrmp.hric.bussiness.service.InitExecTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitMidTableServiceHelper;
import kd.hrmp.hric.bussiness.service.impl.InitExecTaskServiceImpl;
import kd.hrmp.hric.bussiness.service.task.distribute.DistributeExecTaskService;
import kd.hrmp.hric.common.bean.TaskInfo;
import kd.hrmp.hric.common.util.LogUtils;

public class AutoGenerateExecTask
implements Runnable {
    private static Log LOG = LogFactory.getLog(AutoGenerateExecTask.class);
    private DynamicObject execTask;
    private InitExecTaskService initExecTaskService = new InitExecTaskServiceImpl();
    private TaskInfo taskInfo;
    private String businessKeyQuery;
    private Integer normalPageSize = 50000;
    private Integer coarseningPageSize;
    private boolean lastCoarseningPage = false;

    public AutoGenerateExecTask(DynamicObject execTask) {
        this.execTask = execTask;
        try {
            Integer globalPageSize = Integer.parseInt(BaseConfigServiceHelper.get("global.default.pagesize"));
            this.normalPageSize = globalPageSize / 2;
        }
        catch (Exception ex) {
            LOG.error("read global page size fail", (Throwable)ex);
        }
    }

    public void distributeTask() {
        if (this.checkDone()) {
            return;
        }
        this.taskInfo = this.initExecTaskService.parseTaskInfo(this.execTask);
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>();
        ArrayList actualPageList = Lists.newArrayList();
        DistributeExecTaskService distributeExecTaskService = new DistributeExecTaskService(this.taskInfo, this.execTask);
        long count = this.execTask.getLong("count");
        this.initCoarseningPageSize();
        long pageCount = (int)Math.ceil((double)count / (double)this.coarseningPageSize.intValue());
        int index = 0;
        while ((long)index < pageCount) {
            int pageIndex = index;
            String msg = ResManager.loadKDString((String)"\u5206\u9875\u83b7\u53d6\u7f13\u5b58\u8868{0}\u6570\u636e,[pageIndex:{1},CoarseningPageSize:{2}]", (String)"AutoGenerateExecTask_0", (String)"hrmp-hric-business", (Object[])new Object[]{this.taskInfo.getMidTableNumber(), pageIndex, this.coarseningPageSize});
            DynamicObject[] dynamicObjects = (DynamicObject[])LogUtils.printCostLog((String)msg, () -> InitMidTableServiceHelper.queryPageCollection(this.taskInfo.getMidTableNumber(), this.getBussinessKeyQuery(), this.taskInfo.findQFilterObj().toArray(), pageIndex, this.coarseningPageSize));
            this.lastCoarseningPage = (long)pageIndex == pageCount - 1L;
            this.distributePage(taskList, actualPageList, distributeExecTaskService, dynamicObjects);
            ++index;
        }
        new HRBaseServiceHelper("hric_exectask").save(taskList.toArray(new DynamicObject[0]));
        this.initExecTaskService.retry(taskList, false);
    }

    private boolean checkDone() {
        return InitExecTaskServiceHelper.isExistSubExecTask(this.execTask.getLong("id"));
    }

    private void distributePage(List<DynamicObject> taskList, List<DynamicObject> actualPageList, DistributeExecTaskService distributeExecTaskService, DynamicObject[] dynamicObjects) {
        if (!HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            int index = 0;
            while (index < dynamicObjects.length) {
                Integer remainIndex = dynamicObjects.length - index;
                Integer subDySize = remainIndex < this.taskInfo.getPageSize() ? remainIndex : this.taskInfo.getPageSize();
                DynamicObject[] subDynamicObjects = new DynamicObject[subDySize.intValue()];
                System.arraycopy(dynamicObjects, index, subDynamicObjects, 0, subDynamicObjects.length);
                distributeExecTaskService.addOnOrDistributeTask(actualPageList, subDynamicObjects, this.execTask, taskList, this.lastCoarseningPage && (index += subDySize.intValue()) == dynamicObjects.length);
            }
        }
    }

    private void initCoarseningPageSize() {
        int mayPageCount = (int)Math.ceil((double)this.normalPageSize.intValue() / (double)this.taskInfo.getPageSize().intValue());
        this.coarseningPageSize = mayPageCount * this.taskInfo.getPageSize();
    }

    private String getBussinessKeyQuery() {
        if (HRStringUtils.isEmpty((String)this.businessKeyQuery)) {
            List bussinessKeyList = Splitter.on((String)"|").trimResults().omitEmptyStrings().splitToList((CharSequence)this.taskInfo.getBussinessKey());
            HashSet set = Sets.newHashSet((Iterable)bussinessKeyList);
            if (!HRStringUtils.isEmpty((String)this.taskInfo.getGroupByKey())) {
                List groupByKeyList = Splitter.on((String)"|").trimResults().omitEmptyStrings().splitToList((CharSequence)this.taskInfo.getGroupByKey());
                set.addAll(groupByKeyList);
            }
            this.businessKeyQuery = Joiner.on((String)",").join((Iterable)set);
        }
        return this.businessKeyQuery;
    }

    @Override
    public void run() {
        try (DLock dLock = DLock.createReentrant((String)("hric_exectask/distribute/" + this.execTask.getLong("id")));){
            if (dLock.tryLock()) {
                this.distributeTask();
            } else {
                LOG.warn("task is processing, no need process again");
            }
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
    }
}

