/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.task.exec;

import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.bussiness.service.ICallbackTaskService;
import kd.hrmp.hric.bussiness.service.InitExecTaskCallbackServiceHelper;
import kd.hrmp.hric.common.bean.bo.ExecTaskCallbackBo;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.exception.code.HRICErrorEnum;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;

public class ExecTaskCallbackService {
    private static Log LOG = LogFactory.getLog(ExecTaskCallbackService.class);

    public void changeStatusToSuccess(DynamicObject[] dynamicObjects) {
        this.changeStatus(dynamicObjects, "3");
    }

    public void changeStatusToExp(DynamicObject[] dynamicObjects) {
        this.changeStatus(dynamicObjects, "5");
    }

    public void changeStatus(DynamicObject[] dynamicObjects, String status) {
        for (DynamicObject dy : dynamicObjects) {
            dy.set("status", (Object)status);
        }
        this.save(dynamicObjects);
    }

    public static ExecTaskCallbackService getInstance() {
        return ExecTaskCallbackServiceHolder.SERVICE;
    }

    public void save(DynamicObject dynamicObject) {
        InitExecTaskCallbackServiceHelper.save(dynamicObject);
    }

    public void save(DynamicObject[] dynamicObjects) {
        InitExecTaskCallbackServiceHelper.save(dynamicObjects);
    }

    public ExecTaskCallbackBo convertDynamicObjectToBo(DynamicObject dynamicObject) {
        ExecTaskCallbackBo execTaskCallbackBo = new ExecTaskCallbackBo();
        execTaskCallbackBo.setId(Long.valueOf(dynamicObject.getLong("id")));
        execTaskCallbackBo.setNumber(dynamicObject.getString("number"));
        execTaskCallbackBo.setOperateKey(dynamicObject.getString("operatekey"));
        execTaskCallbackBo.setParamStr(dynamicObject.getString("param"));
        execTaskCallbackBo.setRefClassNumber(dynamicObject.getString("refclassnumber"));
        this.addRefClassName(execTaskCallbackBo);
        return execTaskCallbackBo;
    }

    private void addRefClassName(ExecTaskCallbackBo execTaskCallbackBo) {
        String refClassNumber = execTaskCallbackBo.getRefClassNumber();
        if (Objects.isNull(refClassNumber)) {
            throw new KDHricException(HRICErrorEnum.CALLBACK_REF_NUMBER_EMPTY, new Object[0]);
        }
        execTaskCallbackBo.setRefClassName(BaseConfigServiceHelper.get(refClassNumber));
    }

    public DynamicObject convertBoToDynamicObject(ExecTaskCallbackBo execTaskCallbackBo) {
        DynamicObject dynamicObject = InitExecTaskCallbackServiceHelper.generateEmptyObject();
        dynamicObject.set("number", (Object)execTaskCallbackBo.getNumber());
        dynamicObject.set("operatekey", (Object)execTaskCallbackBo.getOperateKey());
        dynamicObject.set("status", (Object)execTaskCallbackBo.getStatus());
        dynamicObject.set("refclassnumber", (Object)execTaskCallbackBo.getRefClassNumber());
        dynamicObject.set("param", (Object)execTaskCallbackBo.getParamStr());
        HricDynamicObjectUtils.setBigText((DynamicObject)dynamicObject, (String)"otherparam", (String)execTaskCallbackBo.getOtherParamStr());
        return dynamicObject;
    }

    public DynamicObject queryBasicDynamicObject(Long id) {
        return InitExecTaskCallbackServiceHelper.queryBasicInfo(id);
    }

    public Map<String, Object> queryOtherParam(Long id) {
        DynamicObject dynamicObject = InitExecTaskCallbackServiceHelper.queryOtherParam(id);
        if (dynamicObject == null) {
            return null;
        }
        ExecTaskCallbackBo execTaskCallbackBo = new ExecTaskCallbackBo();
        execTaskCallbackBo.setOtherParamStr(HricDynamicObjectUtils.getBigText((DynamicObject)dynamicObject, (String)"otherparam"));
        return execTaskCallbackBo.getOtherParam();
    }

    public void invokeCallbackService(Long id) {
        this.invokeCallbackService(this.queryBasicDynamicObject(id));
    }

    public void invokeCallbackService(DynamicObject dynamicObject) {
        this.invokeCallbackService(this.convertDynamicObjectToBo(dynamicObject));
    }

    public void invokeCallbackExpService(DynamicObject dynamicObject) {
        this.invokeCallbackExpService(this.convertDynamicObjectToBo(dynamicObject));
    }

    public void invokeCallbackServiceAndChangeStatus(DynamicObject dynamicObject) {
        this.invokeCallbackService(this.convertDynamicObjectToBo(dynamicObject));
        this.changeStatusToSuccess(new DynamicObject[]{dynamicObject});
    }

    public void invokeCallbackService(ExecTaskCallbackBo callbackBo) {
        ICallbackTaskService callbackTaskService = (ICallbackTaskService)TypesContainer.createInstance((String)callbackBo.getRefClassName());
        callbackTaskService.exec(callbackBo.getId(), callbackBo.getBasicParam());
    }

    public void invokeCallbackExpService(ExecTaskCallbackBo callbackBo) {
        ICallbackTaskService callbackTaskService = (ICallbackTaskService)TypesContainer.createInstance((String)callbackBo.getRefClassName());
        callbackTaskService.execExp(callbackBo.getId(), callbackBo.getBasicParam());
    }

    private static class ExecTaskCallbackServiceHolder {
        private static final ExecTaskCallbackService SERVICE = new ExecTaskCallbackService();

        private ExecTaskCallbackServiceHolder() {
        }
    }
}

