/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.task.exec;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.ext.IInitMetadataEntityService;
import kd.hrmp.hric.bussiness.domain.init.IAsyncTaskDomainService;
import kd.hrmp.hric.bussiness.domain.init.IInitTemplateDomainService;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.bo.MetadataBo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.util.MetadataUtils;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.MidTableAutoGenerateExecTaskServiceHelper;
import kd.hrmp.hric.bussiness.task.InitAsyncTask;
import kd.hrmp.hric.common.constants.AsyncTaskSceneConstants;
import kd.hrmp.hric.common.util.DateUtils;

public class MidTableAutoGenerateExecTask {
    private static Log LOG = LogFactory.getLog(MidTableAutoGenerateExecTask.class);
    private IInitMetadataEntityService initMetadataService = ServiceFactory.getService(IInitMetadataEntityService.class);
    private IInitTemplateDomainService initTemplateService = ServiceFactory.getService(IInitTemplateDomainService.class);
    private IAsyncTaskDomainService initAsyncTaskDomainService = ServiceFactory.getService(IAsyncTaskDomainService.class);
    private List<Long> needGenMidTableIdList = Lists.newArrayList();
    private boolean single;
    private boolean allGenerate;
    private Map<String, Date> entityLastestModifyTimeMap = Maps.newHashMap();
    private Date templateModifyDate;
    private Map<String, MetadataBo> metadataBoMap = Maps.newHashMap();
    private Map<Long, String> templateIdMidTableMapping = Maps.newHashMap();
    private Map<String, String> templateGenerateKeyMap;
    private Map<String, String> latestGenerateKeyMap;
    private StringBuilder errorBuilder = new StringBuilder();
    private String operateType = ResManager.loadKDString((String)"\u5b9a\u65f6\u4efb\u52a1", (String)"MidTableAutoGenerateExecTask_2", (String)"hrmp-hric-business", (Object[])new Object[0]);

    public MidTableAutoGenerateExecTask() {
    }

    public MidTableAutoGenerateExecTask(boolean allGenerate) {
        this.allGenerate = allGenerate;
    }

    public MidTableAutoGenerateExecTask(Long id) {
        this.single = true;
        this.operateType = ResManager.loadKDString((String)"\u5feb\u901f\u5904\u7406", (String)"MidTableAutoGenerateExecTask_3", (String)"hrmp-hric-business", (Object[])new Object[0]);
        this.needGenMidTableIdList.add(id);
    }

    public void generate() {
        try (DLock dLock = DLock.create((String)"hrmp.hric.MidTableAutoGenerateExecTask");){
            dLock.lock();
            this.init();
            this.doGenerate();
        }
    }

    private void doGenerate() {
        if (this.needGenMidTableIdList.isEmpty()) {
            LOG.info(ResManager.loadKDString((String)"\u65e0\u9700\u91cd\u65b0\u751f\u6210\u7f13\u5b58\u8868\u3002", (String)"MidTableAutoGenerateExecTask_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        ArrayList dynamicObjectList = Lists.newArrayListWithExpectedSize((int)this.needGenMidTableIdList.size());
        for (Long id : this.needGenMidTableIdList) {
            String generateKey = this.templateGenerateKeyMap.get(this.templateIdMidTableMapping.get(id));
            DynamicObject dynamicObject = AsyncTaskServiceHelper.createTask((Map<String, Object>)ImmutableMap.of((Object)"templateId", (Object)id, (Object)"generateKey", (Object)generateKey), this.templateIdMidTableMapping.get(id), this.operateType, AsyncTaskSceneConstants.SCENE_MIDTABLE_GENERATE);
            dynamicObjectList.add(dynamicObject);
        }
        AsyncTaskServiceHelper.save(dynamicObjectList);
        for (DynamicObject dy : dynamicObjectList) {
            new InitAsyncTask().execute(null, (Map<String, Object>)ImmutableMap.of((Object)"asyncTaskId", (Object)dy.getLong("id")));
        }
    }

    private void init() {
        if (this.isSingle()) {
            DynamicObject[] midTableNumberArr;
            for (DynamicObject dy : midTableNumberArr = MidTableAutoGenerateExecTaskServiceHelper.getMidTableField(this.needGenMidTableIdList)) {
                this.templateIdMidTableMapping.put(dy.getLong("id"), dy.getString("intermediatetable"));
            }
            this.initTemplateGenerateKey(midTableNumberArr);
            return;
        }
        LOG.info("all generate: {}", (Object)this.allGenerate);
        DynamicObject[] dyArr = MidTableAutoGenerateExecTaskServiceHelper.getAllTemplateJudgeInfo();
        if (!this.allGenerate) {
            this.doNeedGenInit(dyArr);
        }
        this.initCommonInfo(dyArr);
        for (DynamicObject dynamicObject : dyArr) {
            if (!this.needGen(dynamicObject)) continue;
            this.needGenMidTableIdList.add(dynamicObject.getLong("id"));
            this.templateIdMidTableMapping.put(dynamicObject.getLong("id"), dynamicObject.getString("intermediatetable"));
        }
    }

    private void initCommonInfo(DynamicObject[] dyArr) {
        this.initMidTableMetadata(dyArr);
        this.initTemplateGenerateKey(dyArr);
    }

    private void doNeedGenInit(DynamicObject[] dyArr) {
        this.initEntityLastestModifyTime(dyArr);
        this.initTemplateModifyDate();
        this.latestGenerateKeyMap = this.initAsyncTaskDomainService.getLastestGenerateKey();
    }

    private void initTemplateGenerateKey(DynamicObject[] dyArr) {
        List<Long> templateIdList = Stream.of(dyArr).map(it -> it.getLong("id")).collect(Collectors.toList());
        this.templateGenerateKeyMap = this.initTemplateService.getGenerateFieldTemplateKey(templateIdList);
    }

    private void initMidTableMetadata(DynamicObject[] dyArr) {
        Set<String> midTableNumberSet = Stream.of(dyArr).map(it -> it.getString("intermediatetable")).filter(Objects::nonNull).collect(Collectors.toSet());
        this.metadataBoMap = this.initMetadataService.getMetadataBoMap(midTableNumberSet);
    }

    private void initTemplateModifyDate() {
        String tempExtMetadata = this.initMetadataService.getExtMetaObject("hric_initmidtpl");
        LOG.info("tempExtMetadata: {}", (Object)tempExtMetadata);
        AbstractMetadata abstractMetadata = this.initMetadataService.loadMeta(tempExtMetadata);
        this.templateModifyDate = Optional.ofNullable(abstractMetadata).map(AbstractMetadata::getModifyDate).orElseGet(() -> new Date());
        LOG.info("templateModifyDate: {}", (Object)this.templateModifyDate);
    }

    private void initEntityLastestModifyTime(DynamicObject[] dyArr) {
        Set<String> entityNumberSet = Stream.of(dyArr).map(it -> this.getEntityNumberByTempDyc((DynamicObject)it)).filter(Objects::nonNull).collect(Collectors.toSet());
        entityNumberSet.add("hric_initmidtpl");
        this.entityLastestModifyTimeMap = this.initMetadataService.getMetadataLastestModifyTime(entityNumberSet);
    }

    private boolean needGen(DynamicObject dynamicObject) {
        if (this.allGenerate) {
            return true;
        }
        String midTableNumber = dynamicObject.getString("intermediatetable");
        if (!MetadataUtils.checkNumber(midTableNumber)) {
            LOG.info("midtable: {}, not generate", (Object)midTableNumber);
            return true;
        }
        String number = this.getEntityNumberByTempDyc(dynamicObject);
        if (HRStringUtils.isEmpty((String)number)) {
            LOG.warn("midtable: ignore empty number, template number = {}", (Object)dynamicObject.getString("number"));
            return false;
        }
        Date modifyDate = this.entityLastestModifyTimeMap.get(number);
        Date date = Optional.ofNullable(this.metadataBoMap.get(midTableNumber)).map(it -> it.getModifyDate()).orElse(DateUtils.MIN_DATE_TIME);
        if (!Objects.isNull(modifyDate) && date.compareTo(modifyDate) < 0) {
            LOG.info("midtable: {}, version old", (Object)dynamicObject.getString("intermediatetable"));
            return true;
        }
        if (!Objects.isNull(this.templateModifyDate) && date.before(HRDateTimeUtils.addHour((Date)this.templateModifyDate, (long)12L))) {
            LOG.info("midtable: {}, template changed, need regenerate, midtable generate time:{}", (Object)midTableNumber, (Object)date);
            return true;
        }
        if (!this.templateGenerateKeyMap.getOrDefault(midTableNumber, "").equals(this.latestGenerateKeyMap.get(midTableNumber))) {
            LOG.info("midtable: {}, generate key changed, need regenerate", (Object)midTableNumber);
            return true;
        }
        return false;
    }

    private String getEntityNumberByTempDyc(DynamicObject dynamicObject) {
        return Optional.ofNullable(dynamicObject).filter(Objects::nonNull).map(it -> it.getDynamicObject("entityobjscope")).filter(Objects::nonNull).map(it -> it.getString("number")).orElseGet(() -> null);
    }

    public boolean isSingle() {
        return this.single;
    }
}

