/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.task.handle;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitInParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.bussiness.service.InitMidTableServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTemplateServiceHelper;
import kd.hrmp.hric.bussiness.service.MicConfigServiceHelper;
import kd.hrmp.hric.bussiness.service.task.exec.ExecTaskCallbackService;
import kd.hrmp.hric.bussiness.service.task.handle.MidTableHandleInfo;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.bean.TaskInfo;
import kd.hrmp.hric.common.bean.WriteServiceInfo;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.util.LogUtils;

public abstract class AbstractInitHandle {
    private static final String DEFAULT_HANDLE_CLASS_NAME = "kd.hr.hbp.business.init.CommonInitDomainDataByOpServiceImpl";
    private static Log LOG = LogFactory.getLog(AbstractInitHandle.class);
    private MidTableHandleInfo handleInfo;
    private String entityCode;
    private DynamicObject entityConfig;
    private DynamicObject appConfig;
    private DynamicObject initTemplateDynamicObject;
    private String bussinessKey;
    private String groupByKey;
    private String bussinessKeyQuery;
    private String groupByKeyQuery;
    private String region;
    private String queueName;
    private String handleClassName;
    private int count;
    protected boolean handleSuccess = true;

    public AbstractInitHandle(MidTableHandleInfo handleInfo) {
        this.handleInfo = handleInfo;
    }

    protected void init() {
        LOG.info("1. init template info");
        this.initTemplateDynamicObject = InitTemplateServiceHelper.getInitTemplateByMidNumber(this.getMidTableNumber());
        this.entityCode = Optional.ofNullable(this.initTemplateDynamicObject).map(it -> it.getDynamicObject("entityobjscope")).map(it -> it.getString("number")).orElseGet(() -> "");
        if (HRStringUtils.isEmpty((String)this.entityCode)) {
            throw new KDHricException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5bfc\u5165\u6a21\u677f\u7684\u5173\u8054\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"AbstractInitHandle_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        LOG.info("2. init micro config info");
        this.initMicConfigDynamicObject();
        this.initTemplateKey();
        this.initRequestInfo();
        LOG.info("3. init end");
    }

    protected void initRequestInfo() {
        WriteServiceInfo writeServiceInfo = MicConfigServiceHelper.getWriteServiceInfo(this.entityCode);
        this.region = writeServiceInfo.getRegion();
        this.queueName = writeServiceInfo.getQueueName();
        this.handleClassName = writeServiceInfo.getHandleClassName();
    }

    protected String getNeedHandleDesc() {
        return "";
    }

    private void initMicConfigDynamicObject() {
        this.entityConfig = MicConfigServiceHelper.getMicConfigByEntityCode(this.entityCode);
        this.appConfig = MicConfigServiceHelper.getMicConfigByAppId(EntityMetadataCache.getDataEntityType((String)this.entityCode).getAppId());
    }

    public boolean handle() {
        this.init();
        if (LOG.isInfoEnabled()) {
            LOG.info(ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u64cd\u4f5c\uff0c\u7f13\u5b58\u8868\u7f16\u7801\u4e3a{}\uff0c\u4efb\u52a1Id\u4e3a{}\u3002", (String)"AbstractInitHandle_1", (String)"hrmp-hric-business", (Object[])new Object[0]), new Object[]{this.getHandleDesc(), this.getMidTableNumber(), this.getTaskId()});
        }
        this.count = (Integer)LogUtils.printCostLog((String)ResManager.loadKDString((String)"\u5df2\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u7ed3\u679c\u603b\u6570\u3002", (String)"AbstractInitHandle_2", (String)"hrmp-hric-business", (Object[])new Object[0]), () -> InitMidTableServiceHelper.queryCount(this.getMidTableNumber(), this.getQFilters()));
        this.doHandle();
        return this.handleSuccess;
    }

    protected void startTask(List<DynamicObject> taskList) {
        this.doStartTask(taskList);
    }

    private void doStartTask(List<DynamicObject> taskList) {
        MessagePublisher pub = MQFactory.get().createSimplePublisher(this.getRegion(), this.getQueueName());
        TXHandle required = TX.required();
        try {
            new HRBaseServiceHelper("hric_exectask").save(taskList.toArray(new DynamicObject[0]));
            this.saveOtherInfo(taskList);
            OperateEnum operate = OperateEnum.getOperateEnumByOperateType((String)this.getOperateType());
            for (int i = 0; i < taskList.size(); ++i) {
                boolean skip;
                boolean bl = skip = i == 0 && (OperateEnum.CHECK == operate || OperateEnum.SYNC == operate);
                if (skip) continue;
                DynamicObject execTask = taskList.get(i);
                InitInParam initInParam = this.getInitInParam(operate, execTask);
                pub.publishInDbTranscation(AppMetadataCache.getAppInfo((String)"hric").getDbRoute(), (Object)JSONUtils.toString((Object)initInParam));
            }
        }
        catch (Exception ex) {
            required.markRollback();
            LOG.error((Throwable)ex);
            throw new KDHricException(ResManager.loadKDString((String)"\u4fdd\u5b58\u4efb\u52a1\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AbstractInitHandle_3", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        finally {
            required.close();
            pub.close();
        }
    }

    protected InitInParam getInitInParam(OperateEnum operate, DynamicObject execTask) {
        long id = execTask.getLong("id");
        InitInParam initInParam = new InitInParam();
        initInParam.setExecTaskId(Long.valueOf(id));
        initInParam.setEntityNumber(this.getEntityCode());
        initInParam.setBatchNumber(Long.valueOf(this.getTaskId()));
        initInParam.setMethod(operate.getMethod());
        initInParam.setHandleClassName(this.getHandleClassName());
        initInParam.setOther((Map)Maps.newHashMap());
        initInParam.getOther().put("hric$subTaskInitBatchMap", this.handleInfo.getEntityTaskIdMapping());
        initInParam.getOther().put("common$skip.biz.validate", BaseConfigServiceHelper.isSkipBizValidate());
        return initInParam;
    }

    protected String getRegion() {
        return this.region;
    }

    protected String getQueueName() {
        return this.queueName;
    }

    private String getHandleClassName() {
        return this.handleClassName;
    }

    public DynamicObject buildTask(int count, long startId, long endId, QFilter qFilter, long pid, Integer pageSize) {
        DynamicObject dy = new HRBaseServiceHelper("hric_exectask").generateEmptyDynamicObject();
        dy.set("id", (Object)ORM.create().genLongId(dy.getDataEntityType()));
        dy.set("number", (Object)String.valueOf(dy.get("id")));
        dy.set("batchnumber", (Object)this.getTaskId());
        dy.set("count", (Object)count);
        dy.set("pid", (Object)pid);
        dy.set("taskstatus", (Object)"A");
        dy.set("operatetype", (Object)this.getOperateType());
        dy.set("taskstarttime", (Object)new Date());
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setBussinessKey(this.getBussinessKey());
        taskInfo.setGroupByKey(this.getGroupByKey());
        taskInfo.setStartId(Long.valueOf(startId));
        taskInfo.setEndId(Long.valueOf(endId));
        taskInfo.setQfilter(qFilter.toSerializedString());
        taskInfo.setMidTableNumber(this.getMidTableNumber());
        taskInfo.setEntityNumber(this.getEntityCode());
        taskInfo.setTaskMapping(this.handleInfo.getEntityTaskIdMapping());
        taskInfo.setPageSize(pageSize);
        try {
            dy.set("taskinfo", (Object)JSONUtils.toString((Object)taskInfo));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            throw new KDHricException(ResManager.loadKDString((String)"\u6784\u5efa\u4efb\u52a1\u5f02\u5e38", (String)"AbstractInitHandle_4", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        return dy;
    }

    public String getBussinessKey() {
        return this.bussinessKey;
    }

    public String getGroupByKey() {
        return this.groupByKey;
    }

    public String getBussinessKeyQuery() {
        return this.bussinessKeyQuery;
    }

    public String getBussinessKeyAndGroupByKeyQuery() {
        return this.bussinessKeyQuery + "," + this.groupByKeyQuery;
    }

    private void initTemplateKey() {
        String uniqueKey = this.getInitTemplateDynamicObject().getString("uniquestring");
        Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings();
        ArrayList numberList = Lists.newArrayList((Iterable)splitter.splitToList((CharSequence)uniqueKey));
        Collections.sort(numberList);
        this.bussinessKey = Joiner.on((String)"|").skipNulls().join((Iterable)numberList);
        this.bussinessKeyQuery = Joiner.on((String)",").skipNulls().join((Iterable)numberList);
        String groupByKeyStr = this.getInitTemplateDynamicObject().getString("groupfield");
        ArrayList groupByKeyList = Lists.newArrayList((Iterable)splitter.splitToList((CharSequence)groupByKeyStr));
        Collections.sort(groupByKeyList);
        this.groupByKey = Joiner.on((String)"|").skipNulls().join((Iterable)groupByKeyList);
        this.groupByKeyQuery = Joiner.on((String)",").skipNulls().join((Iterable)groupByKeyList);
    }

    protected abstract String getOperateType();

    protected abstract String getHandleDesc();

    protected QFilter getQFilter() {
        return new QFilter("hrictaskid", "=", (Object)this.getTaskId()).and(this.getNormalStatusQFilter());
    }

    protected QFilter[] getQFilters() {
        return this.getQFilter().toArray();
    }

    protected QFilter getNormalStatusQFilter() {
        return new QFilter("initstatus", "in", this.handleInfo.getHandleStatusList());
    }

    protected void saveOtherInfo(List<DynamicObject> taskList) {
        this.saveCallbackInfo(taskList.get(0));
    }

    protected void saveCallbackInfo(DynamicObject dynamicObject) {
        DynamicObject callbackObject = this.getHandleInfo().getCallbackObject();
        if (Objects.isNull(callbackObject)) {
            return;
        }
        callbackObject.set("id", dynamicObject != null ? dynamicObject.get("id") : Long.valueOf(ID.genLongId()));
        ExecTaskCallbackService.getInstance().save(callbackObject);
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    protected abstract void doHandle();

    public String getMidTableNumber() {
        return this.handleInfo.getMidTableNumber();
    }

    public long getTaskId() {
        return this.handleInfo.getTaskId();
    }

    public DynamicObject getEntityConfig() {
        return this.entityConfig;
    }

    public DynamicObject getInitTemplateDynamicObject() {
        return this.initTemplateDynamicObject;
    }

    public MidTableHandleInfo getHandleInfo() {
        return this.handleInfo;
    }

    public int getCount() {
        return this.count;
    }

    protected DynamicObject getMicConfig() {
        if (!Objects.isNull(this.entityConfig)) {
            return this.entityConfig;
        }
        return this.appConfig;
    }
}

