/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.task.handle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hrmp.hric.bussiness.service.InitExecTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.task.handle.AbstractInitHandle;
import kd.hrmp.hric.bussiness.service.task.handle.MidTableHandleInfo;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.util.QFilterUtils;

public abstract class AbstractInitPageHandle
extends AbstractInitHandle {
    private static final Log LOG = LogFactory.getLog(AbstractInitPageHandle.class);
    private static final int INIT_DEFAULT_SIZE = 1000;
    private int pageSize = 1000;
    private int pageIndex = 0;
    private long startId;
    private long endId;

    public AbstractInitPageHandle(MidTableHandleInfo handleInfo) {
        super(handleInfo);
    }

    @Override
    protected void doHandle() {
        int count = this.getCount();
        long pageCount = (int)Math.ceil((double)count / (double)this.pageSize);
        if (LOG.isInfoEnabled()) {
            LOG.info(ResManager.loadKDString((String)"\u7ed3\u679c\u603b\u662f\u4e3a{}\uff0c\u5171\u5206{}\u9875\uff0c\u6bcf\u9875{}\u6761\u3002", (String)"AbstractInitPageHandle_0", (String)"hrmp-hric-business", (Object[])new Object[0]), new Object[]{count, pageCount, this.pageSize});
        }
        if (count == 0) {
            throw new KDHricException(ResManager.loadKDString((String)"\u6682\u65e0{0}\u6570\u636e\u3002", (String)"AbstractInitPageHandle_1", (String)"hrmp-hric-business", (Object[])new Object[]{this.getNeedHandleDesc()}));
        }
        this.initStartAndEndId();
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>();
        DynamicObject pTask = this.buildTask(count, this.startId, this.endId, this.getQFilter(), 0L, this.pageSize);
        taskList.add(pTask);
        ArrayList actualPageList = Lists.newArrayList();
        this.distributeTaskSync(pageCount, taskList, pTask, actualPageList);
        this.startTask(taskList);
        this.distributeTaskAsync(pTask);
    }

    protected void initStartAndEndId() {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.getMidTableNumber());
        String qFilterSql = QFilterUtils.getFilterSql((QFilter)this.getQFilter(), (String)this.getMidTableNumber());
        Map<String, Long> resultMap = InitExecTaskServiceHelper.getStartExecTaskId(entityType.getAlias(), qFilterSql);
        this.startId = resultMap.get("startId");
        this.endId = resultMap.get("endId");
    }

    protected void distributeTaskAsync(DynamicObject pTask) {
    }

    protected void distributeTaskSync(long pageCount, List<DynamicObject> taskList, DynamicObject pTask, List<DynamicObject> actualPageList) {
    }

    @Override
    protected void init() {
        super.init();
        this.pageSize = this.getMicConfig().getInt("batchamountadj") == 0 ? (this.getMicConfig().getInt("batchamount") == 0 ? 1000 : this.getMicConfig().getInt("batchamount")) : this.getMicConfig().getInt("batchamountadj");
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }
}

