/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.task.handle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import kd.hrmp.hric.bussiness.service.task.handle.AbstractInitHandle;
import kd.hrmp.hric.bussiness.service.task.handle.ChangeSuccessStatusHandle;
import kd.hrmp.hric.bussiness.service.task.handle.ChangeValidatedStatusHandle;
import kd.hrmp.hric.bussiness.service.task.handle.MidTableHandleInfo;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.exception.code.HRICErrorEnum;

public class HandleFactory {
    public static Map<OperateEnum, Function<MidTableHandleInfo, AbstractInitHandle>> INIT_HANDLE_MAP = ImmutableMap.of((Object)OperateEnum.VERIFY, info -> new ChangeValidatedStatusHandle((MidTableHandleInfo)info), (Object)OperateEnum.FINISH, info -> new ChangeSuccessStatusHandle((MidTableHandleInfo)info));

    public static AbstractInitHandle getInitHandle(MidTableHandleInfo midTableHandleInfo) {
        return Optional.ofNullable(INIT_HANDLE_MAP.get(midTableHandleInfo.getOperateEnum())).map(it -> (AbstractInitHandle)it.apply(midTableHandleInfo)).orElseThrow(() -> new KDHricException(HRICErrorEnum.PARAM_ERROR, new Object[0]));
    }
}

