/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.task.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hrmp.hric.bussiness.service.InitMidTableServiceHelper;
import kd.hrmp.hric.bussiness.service.InitValidateServiceHelper;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;

public class InitValidateThread
implements Runnable {
    private static final Log LOG = LogFactory.getLog(InitValidateThread.class);
    private InitValidateServiceHelper initValidateServiceHelper;
    private DynamicObject execTask;

    public InitValidateThread(DynamicObject execTask, InitValidateServiceHelper initValidateServiceHelper) {
        this.execTask = execTask;
        this.initValidateServiceHelper = initValidateServiceHelper;
    }

    @Override
    public void run() {
        this.startTask(this.execTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTask(DynamicObject execTask) {
        LOG.info(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6821\u9a8c\u7ebf\u7a0b\uff08\u4e8b\u52a1Id\uff1a{}\uff09\u542f\u52a8", (String)"InitValidateThread_0", (String)"hrmp-hric-business", (Object[])new Object[0]), (Object)execTask.getLong("id"));
        TXHandle required = TX.required();
        Long execTaskId = execTask.getLong("id");
        MessagePublisher pub = MQFactory.get().createSimplePublisher("hrmp", "hric_init_callback_queue");
        try {
            long pidId = execTask.getLong("pid");
            if (pidId == 0L) {
                return;
            }
            DynamicObject[] dys = this.getDynamicObjects(execTask, this.initValidateServiceHelper.getMidTableNumber());
            this.initValidateServiceHelper.handleData(execTaskId, dys);
            InitOutParam initOutParam = new InitOutParam();
            initOutParam.setExecTaskId(execTaskId);
            initOutParam.setBatchNumber(this.initValidateServiceHelper.getTaskID());
            pub.publishInDbTranscation(AppMetadataCache.getAppInfo((String)"hric").getDbRoute(), (Object)JSONUtils.toString((Object)initOutParam));
        }
        catch (Exception ex) {
            required.markRollback();
            LOG.error((Throwable)ex);
            this.handleException(execTaskId, pub, ex);
        }
        finally {
            required.close();
            pub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Long execTaskId, MessagePublisher pub, Exception ex) {
        InitOutParam initOutParam = new InitOutParam();
        initOutParam.setExecTaskId(execTaskId);
        initOutParam.setBatchNumber(this.initValidateServiceHelper.getTaskID());
        initOutParam.setSuccess(false);
        initOutParam.addExtendInfo("errorMsg", (Object)ex.getMessage());
        try (TXHandle req = TX.requiresNew();){
            pub.publishInDbTranscation(AppMetadataCache.getAppInfo((String)"hric").getDbRoute(), (Object)JSONUtils.toString((Object)initOutParam));
        }
    }

    private DynamicObject[] getDynamicObjects(DynamicObject execTask, String midTableNumber) {
        JSONObject jsonObject = JSON.parseObject((String)execTask.getString("taskinfo"));
        QFilter qFilter = QFilter.fromSerializedString((String)jsonObject.getString("qfilter"));
        Long endId = jsonObject.getLong("endId");
        Long startId = jsonObject.getLong("startId");
        QFilter[] filters = new QFilter[]{qFilter.and(new QFilter("id", ">=", (Object)startId)).and("id", "<=", (Object)endId)};
        LOG.info("InitValidate: middle table field\uff1a [{}]", (Object)HricDynamicObjectUtils.getFieldByPage((String)midTableNumber));
        return InitMidTableServiceHelper.queryPageCollection(midTableNumber, filters);
    }
}

