/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.task.handle;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.id.ID;
import kd.hrmp.hric.bussiness.service.task.exec.ExecTaskCallbackService;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.bean.bo.ExecTaskCallbackBo;

public class MidTableHandleInfo
implements Serializable {
    private static final long serialVersionUID = -1677847007848509831L;
    public static final String SUB_TASK_INVOKE = "subTaskInvoke";
    private long taskId;
    private String midTableNumber;
    @Deprecated
    private boolean retry;
    private List<String> handleStatusList;
    private ExecTaskCallbackBo execTaskCallbackBo;
    private transient DynamicObject callbackObject;
    private List<MidTableHandleInfo> subTaskHandleInfoList;
    private OperateEnum operateEnum;
    private List<Long> selectedIdList;
    private Map<String, Long> entityTaskIdMapping = Maps.newHashMap();

    public MidTableHandleInfo() {
    }

    public MidTableHandleInfo(long taskId, String midTableNumber, boolean retry) {
        this.taskId = taskId;
        this.midTableNumber = midTableNumber;
        this.retry = retry;
    }

    public MidTableHandleInfo(long taskId, String midTableNumber, ExecTaskCallbackBo execTaskCallbackBo) {
        this(taskId, midTableNumber, false);
        if (Objects.nonNull(execTaskCallbackBo)) {
            this.execTaskCallbackBo = execTaskCallbackBo;
            this.callbackObject = ExecTaskCallbackService.getInstance().convertBoToDynamicObject(execTaskCallbackBo);
        }
    }

    public MidTableHandleInfo(long taskId, String midTableNumber, ExecTaskCallbackBo execTaskCallbackBo, List<Long> selectedIdList) {
        this(taskId, midTableNumber, execTaskCallbackBo);
        this.selectedIdList = selectedIdList;
    }

    public MidTableHandleInfo(long taskId, ExecTaskCallbackBo execTaskCallbackBo, List<MidTableHandleInfo> subTaskHandleInfoList, OperateEnum operateEnum) {
        this.taskId = taskId;
        if (Objects.nonNull(execTaskCallbackBo)) {
            this.execTaskCallbackBo = execTaskCallbackBo;
            this.callbackObject = ExecTaskCallbackService.getInstance().convertBoToDynamicObject(execTaskCallbackBo);
        }
        this.operateEnum = operateEnum;
        this.subTaskHandleInfoList = subTaskHandleInfoList;
        this.initSubTaskHandleInfo();
        if (this.hasSubTask()) {
            this.initCurrentTaskAsFirstSubTask(subTaskHandleInfoList.get(0));
        }
    }

    private final void initCurrentTaskAsFirstSubTask(MidTableHandleInfo midTableHandleInfo) {
        this.taskId = midTableHandleInfo.getTaskId();
        this.midTableNumber = midTableHandleInfo.getMidTableNumber();
        this.execTaskCallbackBo = midTableHandleInfo.getExecTaskCallbackBo();
        this.callbackObject = midTableHandleInfo.getCallbackObject();
    }

    private final void initSubTaskHandleInfo() {
        for (int index = 0; index < this.subTaskHandleInfoList.size(); ++index) {
            ExecTaskCallbackBo callbackBo = null;
            callbackBo = index + 1 == this.subTaskHandleInfoList.size() ? this.execTaskCallbackBo : this.buildExecTaskCallbackBo(index);
            this.subTaskHandleInfoList.get((int)index).execTaskCallbackBo = callbackBo;
        }
        if (this.subTaskHandleInfoList.size() > 1) {
            MidTableHandleInfo firstMidTableHandleInfo = this.subTaskHandleInfoList.get(0);
            firstMidTableHandleInfo.setEntityTaskIdMapping(this.entityTaskIdMapping);
            firstMidTableHandleInfo.getExecTaskCallbackBo().setOtherParam((Map)ImmutableMap.of((Object)"subTaskHandleInfoList", (Object)SerializationUtils.serializeToBase64(this.subTaskHandleInfoList)));
            firstMidTableHandleInfo.reInit(this.operateEnum);
        }
    }

    public void reInit(OperateEnum operateEnum) {
        this.operateEnum = operateEnum;
        if (Objects.nonNull(this.execTaskCallbackBo)) {
            this.callbackObject = ExecTaskCallbackService.getInstance().convertBoToDynamicObject(this.execTaskCallbackBo);
        }
    }

    private ExecTaskCallbackBo buildExecTaskCallbackBo(int index) {
        return new ExecTaskCallbackBo(ID.genStringId(), SUB_TASK_INVOKE, "exectask.callback.class.subtaskexec", (Map)ImmutableMap.of((Object)"index", (Object)index, (Object)"operate", (Object)this.operateEnum.toString()));
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public String getMidTableNumber() {
        return this.midTableNumber;
    }

    public void setMidTableNumber(String midTableNumber) {
        this.midTableNumber = midTableNumber;
    }

    @Deprecated
    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public List<String> getHandleStatusList() {
        return this.handleStatusList;
    }

    public void setHandleStatusList(List<String> handleStatusList) {
        this.handleStatusList = handleStatusList;
    }

    public DynamicObject getCallbackObject() {
        return this.callbackObject;
    }

    public ExecTaskCallbackBo getExecTaskCallbackBo() {
        return this.execTaskCallbackBo;
    }

    public List<Long> getSelectedIdList() {
        return this.selectedIdList;
    }

    private final boolean hasSubTask() {
        return this.subTaskHandleInfoList != null && this.subTaskHandleInfoList.size() > 0;
    }

    public OperateEnum getOperateEnum() {
        return this.operateEnum;
    }

    public List<MidTableHandleInfo> getSubTaskHandleInfoList() {
        return this.subTaskHandleInfoList;
    }

    public void setEntityTaskIdMapping(Map<String, Long> entityTaskIdMapping) {
        this.entityTaskIdMapping = entityTaskIdMapping;
    }

    public Map<String, Long> getEntityTaskIdMapping() {
        return this.entityTaskIdMapping;
    }
}

