/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.service.task.handle;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.init.InitInParam;
import kd.hrmp.hric.bussiness.service.task.handle.AbstractChangeStatusHandle;
import kd.hrmp.hric.bussiness.service.task.handle.MidTableHandleInfo;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.util.ConvertUtils;

public class RollbackInitDataHandle
extends AbstractChangeStatusHandle {
    private static final Log LOG = LogFactory.getLog(RollbackInitDataHandle.class);

    public RollbackInitDataHandle(MidTableHandleInfo handleInfo) {
        super(handleInfo);
        handleInfo.setHandleStatusList(OperateEnum.ROLLBACK.getHandleStatusList());
    }

    @Override
    protected String getNeedHandleDesc() {
        return ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u548c\u66f4\u65b0\u4e3a\u5df2\u9a8c\u8bc1\u6210\u529f", (String)"RollbackInitDataHandle_0", (String)"hrmp-hric-business", (Object[])new Object[0]);
    }

    @Override
    protected String getOperateType() {
        return OperateEnum.ROLLBACK.getOperateType();
    }

    @Override
    protected String getHandleDesc() {
        return ResManager.loadKDString((String)"\u6570\u636e\u56de\u6eda", (String)"RollbackInitDataHandle_1", (String)"hrmp-hric-business", (Object[])new Object[0]);
    }

    @Override
    protected void handleNoDataCase() {
        throw new KDHricException(ResManager.loadKDString((String)"\u6682\u65e0{0}\u7684\u6570\u636e\u3002", (String)"RollbackInitDataHandle_2", (String)"hrmp-hric-business", (Object[])new Object[]{this.getNeedHandleDesc()}));
    }

    @Override
    public DynamicObject buildTask(int count, long startId, long endId, QFilter qFilter, long pid, Integer pageSize) {
        DynamicObject execTask = super.buildTask(count, startId, endId, qFilter, pid, pageSize);
        List<Long> selectedIdList = this.getHandleInfo().getSelectedIdList();
        if (!CollectionUtils.isEmpty(selectedIdList)) {
            execTask.set("midtableids", (Object)ConvertUtils.convertLongIdSetToString(selectedIdList, (String)","));
        }
        return execTask;
    }

    @Override
    protected InitInParam getInitInParam(OperateEnum operate, DynamicObject execTask) {
        InitInParam initInParam = super.getInitInParam(operate, execTask);
        List<Long> selectedIdList = this.getHandleInfo().getSelectedIdList();
        if (!CollectionUtils.isEmpty(selectedIdList)) {
            HashMap<String, Boolean> otherMap = new HashMap<String, Boolean>();
            otherMap.put("isSelected", true);
            initInParam.setOther(otherMap);
        }
        return initInParam;
    }

    @Override
    protected QFilter[] getQFilters() {
        QFilter qFilter = super.getQFilter().copy();
        this.andRollbackSelectQFilter(qFilter);
        return qFilter.toArray();
    }

    private void andRollbackSelectQFilter(QFilter qFilter) {
        List<Long> selectedIdList = this.getHandleInfo().getSelectedIdList();
        if (!CollectionUtils.isEmpty(selectedIdList)) {
            qFilter.and(new QFilter("id", "in", selectedIdList));
        }
    }
}

