/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hrmp.hric.bussiness.service.AsyncTaskSceneServiceHelper;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.IAsyncTaskService;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.AsyncTaskSceneConstants;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;
import kd.hrmp.hric.common.util.LogUtils;

public class InitAsyncTask
extends AbstractTask {
    private static Log LOG = LogFactory.getLog(InitAsyncTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info(ResManager.loadKDString((String)"\u5f02\u6b65\u4efb\u52a1\u6267\u884c\u5f00\u59cb", (String)"InitAsyncTask_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
        boolean isBatch = map.containsKey("isBatch");
        boolean isAuto = map.containsKey("isAuto");
        DynamicObject asyncTaskScene = AsyncTaskSceneServiceHelper.get(AsyncTaskSceneConstants.SCENE_MESSAGE_NOTICE);
        ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(AppConstants.LIST_SIZE);
        if (isBatch) {
            tasks.addAll(Arrays.asList(AsyncTaskServiceHelper.getExecuteTasks(asyncTaskScene.getInt("autoretrytimes"))));
        } else {
            Long asyncTaskId = ConvertUtils.toLong((Object)map.get("asyncTaskId"));
            tasks.add(AsyncTaskServiceHelper.get(asyncTaskId));
        }
        for (DynamicObject dynamicObject : tasks) {
            dynamicObject.set("status", (Object)"15");
            if (isAuto) {
                dynamicObject.set("retrytimes", (Object)(Optional.ofNullable(dynamicObject.getInt("retrytimes")).orElseGet(() -> 0) + 1));
            }
            this.executeTask(dynamicObject);
        }
        LOG.info(ResManager.loadKDString((String)"\u5f02\u6b65\u4efb\u52a1\u6267\u884c\u5f00\u59cb\u7ed3\u675f", (String)"InitAsyncTask_1", (String)"hrmp-hric-business", (Object[])new Object[0]));
    }

    private void executeTask(DynamicObject dynamicObject) {
        AsyncTaskServiceHelper.save(dynamicObject);
        try {
            DynamicObject task = dynamicObject.getDynamicObject("tasktype");
            String className = task.getString("handleclass");
            IAsyncTaskService taskService = (IAsyncTaskService)TypesContainer.createInstance((String)className);
            taskService.exec(this.getParamMap(dynamicObject));
            dynamicObject.set("status", (Object)"20");
            HricDynamicObjectUtils.clearBigText((DynamicObject)dynamicObject, (String)"errormsg");
        }
        catch (Throwable th) {
            LOG.error(th);
            dynamicObject.set("status", (Object)"30");
            HricDynamicObjectUtils.setBigText((DynamicObject)dynamicObject, (String)"errormsg", (String)LogUtils.getStackTraceString((Throwable)th));
        }
        dynamicObject.set("endtime", (Object)new Date());
        AsyncTaskServiceHelper.save(dynamicObject);
    }

    private Map<String, Object> getParamMap(DynamicObject dynamicObject) throws IOException {
        String paramStr = dynamicObject.getString("params_tag");
        return (Map)HRJSONUtils.cast((String)paramStr, Map.class);
    }
}

