/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.task;

import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataClearEntityService;
import kd.hrmp.hric.bussiness.service.task.exec.MidTableAutoGenerateExecTask;
import kd.hrmp.hric.common.constants.msg.LogMsgEnum;

public class MidTableAutoGenerateTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(MidTableAutoGenerateTask.class);
    private IDataClearEntityService iDataClearEntityService = ServiceFactory.getService(IDataClearEntityService.class);
    private static final String ALL_GENERATE = "all_generate";
    private static final String NEED_GENERATE_TEMPLATE_ID = "need_generate_template_id";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (this.iDataClearEntityService.isMetadataClear()) {
            LOG.info(LogMsgEnum.DATA_CLEAR_METADATA_CLEAR.getMsg());
            return;
        }
        LOG.info("midtable generate task start");
        boolean allGenerate = Boolean.parseBoolean((String)map.get(ALL_GENERATE));
        Long id = this.parseNeedGenerateId(map);
        long startTime = System.currentTimeMillis();
        if (Objects.nonNull(id)) {
            new MidTableAutoGenerateExecTask(id).generate();
        } else {
            new MidTableAutoGenerateExecTask(allGenerate).generate();
        }
        LOG.info("task end, cost time {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private Long parseNeedGenerateId(Map<String, Object> map) {
        String idStr = (String)map.get(NEED_GENERATE_TEMPLATE_ID);
        if (HRStringUtils.isNotEmpty((String)idStr)) {
            try {
                return Long.valueOf(idStr);
            }
            catch (Exception ex) {
                LOG.error("parse id error, idStr : {}", (Object)idStr);
            }
        }
        return null;
    }
}

