/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.bussiness.service.MessageSendServiceHelper;
import kd.hrmp.hric.common.InitMessageInfoBuilder;
import kd.hrmp.hric.common.bean.InitMessageInfo;
import kd.hrmp.hric.common.util.DateUtils;

public class PlanDateTipsTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(PlanDateTipsTask.class);
    private String MESSAGE_TITLE = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8ba1\u5212\u5373\u5c06\u5230\u671f", (String)"PlanDateTipsTask_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_TITLE_TWO = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8ba1\u5212\u8d85\u671f\u63d0\u9192", (String)"PlanDateTipsTask_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_TAG = ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb!", (String)"PlanDateTipsTask_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_CONTENT_ONE = ResManager.loadKDString((String)"\u60a8\u8d1f\u8d23\u7684%1$s\u5373\u5c06\u5230\u671f\uff0c\u5230\u671f\u65e5%2$s\uff0c\u8bf7\u8ddf\u8fdb\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6\u3002", (String)"PlanDateTipsTask_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_CONTENT_TWO = ResManager.loadKDString((String)"\u60a8\u8d1f\u8d23\u7684%1$s\u5df2\u8d85\u671f%2$s\u65e5\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u4efb\u52a1\u8fdb\u5ea6\u3002", (String)"PlanDateTipsTask_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("task start: {}", (Object)((Object)((Object)this)).getClass().getName());
        long startTime = System.currentTimeMillis();
        DynamicObject[] plans = InitPlanServiceHelper.getRemindPlan(Integer.parseInt((String)map.get("near_day")), Integer.parseInt((String)map.get("extended_day")));
        ArrayList<InitMessageInfo> infoListDueTo = new ArrayList<InitMessageInfo>();
        ArrayList<InitMessageInfo> infoListBefore = new ArrayList<InitMessageInfo>();
        Arrays.asList(plans).forEach(plan -> {
            if (!HRStringUtils.equals((String)DateUtils.date2OnlyString((Date)plan.getDate("enddate")), (String)DateUtils.date2OnlyString((Date)DateUtils.getNowDateZero()))) {
                this.buildInfo((DynamicObject)plan, (List<InitMessageInfo>)infoListDueTo, (List<InitMessageInfo>)infoListBefore);
            }
        });
        if (!CollectionUtils.isEmpty(infoListDueTo)) {
            MessageSendServiceHelper.saveMessage(infoListDueTo);
        }
        if (!CollectionUtils.isEmpty(infoListBefore)) {
            MessageSendServiceHelper.saveMessage(infoListBefore);
        }
        AsyncTaskServiceHelper.startJob();
        LOG.info("task end, cost time {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void buildInfo(DynamicObject plan, List<InitMessageInfo> infoListDueTo, List<InitMessageInfo> infoListBefore) {
        ArrayList<Long> receivers = new ArrayList<Long>();
        if (null != plan.get("planperson")) {
            receivers.add(plan.get("planperson") instanceof DynamicObject ? plan.getDynamicObject("planperson").getLong("id") : plan.getLong("planperson"));
        }
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"name");
        long day = DateUtils.getSubDay((Date)plan.getDate("enddate"), (Date)DateUtils.getNowDateZero());
        if (day > 0L) {
            InitMessageInfo info = new InitMessageInfoBuilder().buildReceivers(receivers).buildSenderName(currentUser.getString("name")).buildSenderId(Long.valueOf(currentUser.getLong("id"))).buildEntityName(this.getEntityName(plan)).buildEntityId(Long.valueOf(plan.getLong("id"))).buildContent(String.format(Locale.ROOT, this.MESSAGE_CONTENT_TWO, plan.getString("name"), day)).buildTitle(this.MESSAGE_TITLE_TWO).buildTag(this.MESSAGE_TAG).build();
            infoListBefore.add(info);
        } else {
            InitMessageInfo info = new InitMessageInfoBuilder().buildReceivers(receivers).buildSenderName(currentUser.getString("name")).buildSenderId(Long.valueOf(currentUser.getLong("id"))).buildEntityName(this.getEntityName(plan)).buildEntityId(Long.valueOf(plan.getLong("id"))).buildContent(String.format(Locale.ROOT, this.MESSAGE_CONTENT_ONE, plan.getString("name"), HRDateTimeUtils.format((Date)plan.getDate("enddate"), (String)"yyyy-MM-dd"))).buildTitle(this.MESSAGE_TITLE_TWO).buildTag(this.MESSAGE_TAG).build();
            infoListDueTo.add(info);
        }
    }

    private String getEntityName(DynamicObject plan) {
        return HRStringUtils.equals((String)plan.getString("planstatus"), (String)"A") ? "hric_initplan" : "hric_initplandetail";
    }
}

