/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.common.bean.InitMessageInfo;
import kd.hrmp.hric.common.exception.KDHricException;

public class InitMessageInfoBuilder {
    private String title;
    private List<Long> receivers;
    private String senderName;
    private Long senderId;
    private String entityName;
    private Long entityId;
    private List<String> messageChannelList = Lists.newArrayList();
    private String content;
    private String tag;
    private List<String> phone;
    private Map<String, Object> extInfo = Maps.newHashMap();

    public String getTitle() {
        return this.title;
    }

    public List<Long> getReceivers() {
        return this.receivers;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public Long getSenderId() {
        return this.senderId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public List<String> getMessageChannelList() {
        return this.messageChannelList;
    }

    public String getContent() {
        return this.content;
    }

    public String getTag() {
        return this.tag;
    }

    public List<String> getPhone() {
        return this.phone;
    }

    public Map<String, Object> getExtInfo() {
        return this.extInfo;
    }

    public InitMessageInfo build() {
        this.doCheck();
        return new InitMessageInfo(this);
    }

    public InitMessageInfoBuilder buildTitle(String title) {
        this.title = title;
        return this;
    }

    public InitMessageInfoBuilder buildReceivers(List<Long> receivers) {
        this.receivers = receivers;
        return this;
    }

    public InitMessageInfoBuilder buildSenderName(String senderName) {
        this.senderName = senderName;
        return this;
    }

    public InitMessageInfoBuilder buildSenderId(Long senderId) {
        this.senderId = senderId;
        return this;
    }

    public InitMessageInfoBuilder buildEntityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public InitMessageInfoBuilder buildEntityId(Long entityId) {
        this.entityId = entityId;
        return this;
    }

    public InitMessageInfoBuilder buildMessageChannelList(String messageChannel) {
        this.messageChannelList.add(messageChannel);
        return this;
    }

    public InitMessageInfoBuilder buildContent(String content) {
        this.content = content;
        return this;
    }

    public InitMessageInfoBuilder buildTag(String tag) {
        this.tag = tag;
        return this;
    }

    public InitMessageInfoBuilder buildPhone(List<String> phone) {
        this.phone = phone;
        return this;
    }

    private void doCheck() {
        StringBuilder builder = new StringBuilder();
        if (HRStringUtils.isEmpty((String)this.title)) {
            builder.append(" title ");
        } else if (CollectionUtils.isEmpty(this.receivers)) {
            builder.append(" receivers ");
        } else if (HRStringUtils.isEmpty((String)this.senderName)) {
            builder.append(" senderName ");
        } else if (null == this.senderId || this.senderId == 0L) {
            builder.append(" senderId ");
        } else if (HRStringUtils.isEmpty((String)this.entityName)) {
            builder.append(" entityName ");
        } else if (null == this.entityId || this.entityId == 0L) {
            builder.append(" entityId ");
        } else if (HRStringUtils.isEmpty((String)this.content)) {
            builder.append(" content ");
        } else if (HRStringUtils.isEmpty((String)this.tag)) {
            builder.append(" tag ");
        }
        if (HRStringUtils.isNotEmpty((String)builder.toString())) {
            throw new KDHricException(builder.append(" is Empty---InitMessageInfoBuilder ").toString());
        }
    }
}

