/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.hrmp.hric.common.exception.KDHricException;

public enum OperateEnum {
    INITIMPORTDATA(Lists.newArrayList(), "A", "A", "initimportdata", "H", "initimportdata"),
    SOURCESYSDI(null, "", "", "sourcesystemdi", "I", "sourcesystemdi"),
    INITCHECK(Lists.newArrayList((Object[])new String[]{"A"}), "B1", "B3", "initvalidate", "G", "initvalidate"),
    CHECK(Lists.newArrayList((Object[])new String[]{"B1"}), "C1", "C3", "validate", "A", "bizvalidation"),
    SYNC(Lists.newArrayList((Object[])new String[]{"B1", "C1"}), "D1", "D3", "save", "B", "syncbiz"),
    VERIFY(Lists.newArrayList((Object[])new String[]{"D1"}), "E1", "", "changeValidatedStatus", "C", "res_verify"),
    CANCEL_VERIFY(Lists.newArrayList((Object[])new String[]{"E1"}), "D1", "", "changeProcessingStatus", "D", "res_calcel_verify"),
    FINISH(Lists.newArrayList((Object[])new String[]{"E1"}), "G1", "", "changeSuccessStatus", "E", "res_finish"),
    ROLLBACK(Lists.newArrayList((Object[])new String[]{"D1", "E1"}), "H1", "", "rollback", "F", "rollback"),
    DISCARD(Lists.newArrayList((Object[])new String[]{"D1", "E1", "G1"}), "J1", "", "discard", "H", "discard");

    private List<String> handleStatusList;
    private String successStatus;
    private String errorStatus;
    private String method;
    private String operateType;
    private String btnKey;

    private OperateEnum(List<String> handleStatusList, String successStatus, String errorStatus, String method, String operateType, String btnKey) {
        this.handleStatusList = handleStatusList;
        this.successStatus = successStatus;
        this.errorStatus = errorStatus;
        this.method = method;
        this.operateType = operateType;
        this.btnKey = btnKey;
    }

    public List<String> getHandleStatusList() {
        return this.handleStatusList;
    }

    public String getSuccessStatus() {
        return this.successStatus;
    }

    public String getErrorStatus() {
        return this.errorStatus;
    }

    public String getMethod() {
        return this.method;
    }

    public String getOperateType() {
        return this.operateType;
    }

    public String getBtnKey() {
        return this.btnKey;
    }

    public static OperateEnum getOperateEnumByOperateType(String operateType) {
        for (OperateEnum operate : OperateEnum.values()) {
            if (!operate.getOperateType().equals(operateType)) continue;
            return operate;
        }
        throw new KDHricException(ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"OperateEnum_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
    }
}

