/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common.bean;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hrmp.hric.common.InitMessageInfoBuilder;

public class InitMessageInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title;
    private List<Long> receivers;
    private String senderName;
    private Long senderId;
    private String entityName;
    private Long entityId;
    private List<String> messageChannelList = Lists.newArrayList();
    private String content;
    private String tag;
    private List<String> phone;
    public static final String SHORTMSG = "sms";
    public static final String MCENTER = "mcenter";

    public InitMessageInfo(InitMessageInfoBuilder initMessageInfoBuilder) {
        this.title = initMessageInfoBuilder.getTitle();
        this.receivers = initMessageInfoBuilder.getReceivers();
        this.content = initMessageInfoBuilder.getContent();
        this.tag = initMessageInfoBuilder.getTag();
        this.entityName = initMessageInfoBuilder.getEntityName();
        this.entityId = initMessageInfoBuilder.getEntityId();
        this.senderId = initMessageInfoBuilder.getSenderId();
        this.senderName = initMessageInfoBuilder.getSenderName();
        this.phone = initMessageInfoBuilder.getPhone();
        this.messageChannelList = initMessageInfoBuilder.getMessageChannelList();
    }

    public InitMessageInfo() {
    }

    public String getSenderName() {
        return this.senderName;
    }

    public Long getSenderId() {
        return this.senderId;
    }

    public void setPhone(List<String> phone) {
        this.phone = phone;
    }

    public List<String> getPhone() {
        return this.phone;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Long> getReceivers() {
        return this.receivers;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public String getContent() {
        return this.content;
    }

    public String getTag() {
        return this.tag;
    }

    private String getContentUrl() {
        return "?formId=" + this.getEntityName() + "&id=" + this.getEntityId();
    }

    public MessageInfo convertToMessageInfo() {
        MessageInfo message = new MessageInfo();
        message.setType("message");
        message.setTitle(this.getTitle());
        message.setUserIds(this.getReceivers());
        message.setSenderName(this.getSenderName());
        message.setSenderId(this.getSenderId());
        message.setEntityNumber(this.getEntityName());
        message.setBizDataId(this.getEntityId());
        message.setTag(this.getTag());
        message.setContentUrl(this.getContentUrl());
        message.setContent(this.getContent());
        return message;
    }

    public ShortMessageInfo convertToShortMessageInfo() {
        ShortMessageInfo info = new ShortMessageInfo();
        info.setPhone(this.getPhone());
        info.setMessage(this.getShortMessageContent());
        return info;
    }

    private String getShortMessageContent() {
        return this.getTitle() + "-" + this.getContent();
    }

    public void addMessageChannel(String channel) {
        this.messageChannelList.add(channel);
    }

    public List<String> getMessageChannelList() {
        return this.messageChannelList;
    }
}

