/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common.bean.vo;

import com.google.common.collect.Lists;
import java.util.List;
import kd.hrmp.hric.common.OperateEnum;

public class TaskProcessingVO {
    private Long totalCount;
    private Long finishCount;
    private OperateEnum operateEnum;
    private String execResult;
    private String labelText = "transdetail";
    private List<TaskProcessingVO> subTaskProcessingVOList = Lists.newArrayList();

    private TaskProcessingVO(Long totalCount, Long finishCount, OperateEnum operateEnum) {
        this.totalCount = totalCount;
        this.finishCount = finishCount;
        this.operateEnum = operateEnum;
    }

    public static TaskProcessingVO getInstance() {
        return TaskProcessingVO.getInstance(null, 0L, null);
    }

    public static TaskProcessingVO getInstance(Long totalCount, Long finishCount, OperateEnum operateEnum) {
        return new TaskProcessingVO(totalCount, finishCount, operateEnum);
    }

    public static TaskProcessingVO getInstance(Long totalCount, Long finishCount, OperateEnum operateEnum, String execResult, String labelText) {
        TaskProcessingVO taskProcessingVO = new TaskProcessingVO(totalCount, finishCount, operateEnum);
        taskProcessingVO.execResult = execResult;
        taskProcessingVO.labelText = labelText;
        return taskProcessingVO;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public Long getFinishCount() {
        return this.finishCount;
    }

    public int getPercent() {
        if (this.totalCount == null || this.totalCount == 0L) {
            return 0;
        }
        long count = this.finishCount;
        return (int)(count * 100L / this.totalCount);
    }

    public OperateEnum getOperateEnum() {
        return this.operateEnum;
    }

    public boolean isProcessing() {
        if (this.subTaskProcessingVOList.isEmpty()) {
            return this.operateEnum != null;
        }
        return this.subTaskProcessingVOList.stream().anyMatch(it -> it.isProcessing());
    }

    public void addSubProcessingInfo(TaskProcessingVO processingVO) {
        this.subTaskProcessingVOList.add(processingVO);
    }

    public String getExecResult() {
        return this.execResult;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public String toString() {
        return "TaskProcessingVO{totalCount=" + this.totalCount + ", finishCount=" + this.finishCount + ", operateEnum=" + (Object)((Object)this.operateEnum) + '}';
    }
}

